/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.client.impl.ClientLargeMessageImpl;
import org.apache.activemq.artemis.core.client.impl.ClientMessageImpl;
import org.apache.activemq.artemis.core.persistence.CoreMessageObjectPools;
import org.apache.activemq.artemis.core.protocol.core.CoreRemotingConnection;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketDecoder;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionReceiveClientLargeMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionReceiveMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionReceiveMessage_1X;

public class ClientPacketDecoder
extends PacketDecoder {
    private static final long serialVersionUID = 6952614096979334582L;
    protected final CoreMessageObjectPools coreMessageObjectPools = new CoreMessageObjectPools();

    @Override
    public Packet decode(ActiveMQBuffer in, CoreRemotingConnection connection) {
        byte packetType = in.readByte();
        Packet packet = this.decode(packetType, connection);
        packet.decode(in);
        return packet;
    }

    @Override
    public Packet decode(byte packetType, CoreRemotingConnection connection) {
        return switch (packetType) {
            case 75 -> {
                if (connection.isVersionBeforeAddressChange()) {
                    yield new SessionReceiveMessage_1X(new ClientMessageImpl(this.coreMessageObjectPools));
                }
                yield new SessionReceiveMessage(new ClientMessageImpl(this.coreMessageObjectPools));
            }
            case 76 -> new SessionReceiveClientLargeMessage(new ClientLargeMessageImpl());
            default -> super.decode(packetType, connection);
        };
    }
}

