/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.message.frontend;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.message.frontend.FrontendMessage;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public final class CompositeFrontendMessage
implements FrontendMessage,
FrontendMessage.DirectEncoder {
    private final List<FrontendMessage.DirectEncoder> messages;

    public CompositeFrontendMessage(FrontendMessage.DirectEncoder ... messages) {
        this(Arrays.asList(messages));
    }

    public CompositeFrontendMessage(List<FrontendMessage.DirectEncoder> messages) {
        this.messages = messages;
    }

    public boolean contains(FrontendMessage message) {
        return this.messages.contains(message);
    }

    @Override
    public Publisher<ByteBuf> encode(ByteBufAllocator byteBufAllocator) {
        return Mono.fromSupplier(() -> {
            ByteBuf buffer = byteBufAllocator.buffer();
            this.encode(buffer);
            return buffer;
        });
    }

    @Override
    public void encode(ByteBuf byteBuf) {
        for (FrontendMessage.DirectEncoder message : this.messages) {
            message.encode(byteBuf);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CompositeFrontendMessage)) {
            return false;
        }
        CompositeFrontendMessage that = (CompositeFrontendMessage)o;
        return Objects.equals(this.messages, that.messages);
    }

    public int hashCode() {
        return Objects.hash(this.messages);
    }

    public String toString() {
        return this.messages.toString();
    }
}

