/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.AddRequest;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.CompareRequest;
import com.unboundid.ldap.sdk.CompareResult;
import com.unboundid.ldap.sdk.DeleteRequest;
import com.unboundid.ldap.sdk.DereferencePolicy;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.FullLDAPInterface;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.LDAPSearchException;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModifyDNRequest;
import com.unboundid.ldap.sdk.ModifyRequest;
import com.unboundid.ldap.sdk.ReadOnlyAddRequest;
import com.unboundid.ldap.sdk.ReadOnlyCompareRequest;
import com.unboundid.ldap.sdk.ReadOnlyDeleteRequest;
import com.unboundid.ldap.sdk.ReadOnlyModifyDNRequest;
import com.unboundid.ldap.sdk.ReadOnlyModifyRequest;
import com.unboundid.ldap.sdk.ReadOnlySearchRequest;
import com.unboundid.ldap.sdk.RootDSE;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultListener;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldif.LDIFException;
import com.unboundid.util.Extensible;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.Collection;
import java.util.List;

@Extensible
@ThreadSafety(level=ThreadSafetyLevel.MOSTLY_THREADSAFE)
public class MockableLDAPConnection
implements FullLDAPInterface {
    @NotNull
    private final LDAPConnection connection;

    public MockableLDAPConnection(@NotNull LDAPConnection connection) {
        Validator.ensureNotNullWithMessage(connection, "MockableLDAPConnection.connection must not be null.");
        this.connection = connection;
    }

    @NotNull
    public final LDAPConnection getWrappedConnection() {
        return this.connection;
    }

    @Override
    public void close() {
        this.connection.close();
    }

    @Override
    @Nullable
    public RootDSE getRootDSE() throws LDAPException {
        return this.connection.getRootDSE();
    }

    @Override
    @Nullable
    public Schema getSchema() throws LDAPException {
        return this.connection.getSchema();
    }

    @Override
    @Nullable
    public Schema getSchema(@Nullable String entryDN) throws LDAPException {
        return this.connection.getSchema(entryDN);
    }

    @Override
    @Nullable
    public SearchResultEntry getEntry(@NotNull String dn) throws LDAPException {
        return this.connection.getEntry(dn);
    }

    @Override
    @Nullable
    public SearchResultEntry getEntry(@NotNull String dn, String ... attributes) throws LDAPException {
        return this.connection.getEntry(dn, attributes);
    }

    @Override
    @NotNull
    public LDAPResult add(@NotNull String dn, Attribute ... attributes) throws LDAPException {
        return this.connection.add(dn, attributes);
    }

    @Override
    @NotNull
    public LDAPResult add(@NotNull String dn, @NotNull Collection<Attribute> attributes) throws LDAPException {
        return this.connection.add(dn, attributes);
    }

    @Override
    @NotNull
    public LDAPResult add(@NotNull Entry entry) throws LDAPException {
        return this.connection.add(entry);
    }

    @Override
    @NotNull
    public LDAPResult add(String ... ldifLines) throws LDIFException, LDAPException {
        return this.connection.add(ldifLines);
    }

    @Override
    @NotNull
    public LDAPResult add(@NotNull AddRequest addRequest) throws LDAPException {
        return this.connection.add(addRequest);
    }

    @Override
    @NotNull
    public LDAPResult add(@NotNull ReadOnlyAddRequest addRequest) throws LDAPException {
        return this.connection.add(addRequest);
    }

    @Override
    @NotNull
    public BindResult bind(@Nullable String bindDN, @Nullable String password) throws LDAPException {
        return this.connection.bind(bindDN, password);
    }

    @Override
    @NotNull
    public BindResult bind(@NotNull BindRequest bindRequest) throws LDAPException {
        return this.connection.bind(bindRequest);
    }

    @Override
    @NotNull
    public CompareResult compare(@NotNull String dn, @NotNull String attributeName, @NotNull String assertionValue) throws LDAPException {
        return this.connection.compare(dn, attributeName, assertionValue);
    }

    @Override
    @NotNull
    public CompareResult compare(@NotNull CompareRequest compareRequest) throws LDAPException {
        return this.connection.compare(compareRequest);
    }

    @Override
    @NotNull
    public CompareResult compare(@NotNull ReadOnlyCompareRequest compareRequest) throws LDAPException {
        return this.connection.compare(compareRequest);
    }

    @Override
    @NotNull
    public LDAPResult delete(@NotNull String dn) throws LDAPException {
        return this.connection.delete(dn);
    }

    @Override
    @NotNull
    public LDAPResult delete(@NotNull DeleteRequest deleteRequest) throws LDAPException {
        return this.connection.delete(deleteRequest);
    }

    @Override
    @NotNull
    public LDAPResult delete(@NotNull ReadOnlyDeleteRequest deleteRequest) throws LDAPException {
        return this.connection.delete(deleteRequest);
    }

    @Override
    @NotNull
    public ExtendedResult processExtendedOperation(@NotNull String requestOID) throws LDAPException {
        return this.connection.processExtendedOperation(requestOID);
    }

    @Override
    @NotNull
    public ExtendedResult processExtendedOperation(@NotNull String requestOID, @Nullable ASN1OctetString requestValue) throws LDAPException {
        return this.connection.processExtendedOperation(requestOID, requestValue);
    }

    @Override
    @NotNull
    public ExtendedResult processExtendedOperation(@NotNull ExtendedRequest extendedRequest) throws LDAPException {
        return this.connection.processExtendedOperation(extendedRequest);
    }

    @Override
    @NotNull
    public LDAPResult modify(@NotNull String dn, @NotNull Modification mod) throws LDAPException {
        return this.connection.modify(dn, mod);
    }

    @Override
    @NotNull
    public LDAPResult modify(@NotNull String dn, Modification ... mods) throws LDAPException {
        return this.connection.modify(dn, mods);
    }

    @Override
    @NotNull
    public LDAPResult modify(@NotNull String dn, @NotNull List<Modification> mods) throws LDAPException {
        return this.connection.modify(dn, mods);
    }

    @Override
    @NotNull
    public LDAPResult modify(String ... ldifModificationLines) throws LDIFException, LDAPException {
        return this.connection.modify(ldifModificationLines);
    }

    @Override
    @NotNull
    public LDAPResult modify(@NotNull ModifyRequest modifyRequest) throws LDAPException {
        return this.connection.modify(modifyRequest);
    }

    @Override
    @NotNull
    public LDAPResult modify(@NotNull ReadOnlyModifyRequest modifyRequest) throws LDAPException {
        return this.connection.modify(modifyRequest);
    }

    @Override
    @NotNull
    public LDAPResult modifyDN(@NotNull String dn, @NotNull String newRDN, boolean deleteOldRDN) throws LDAPException {
        return this.connection.modifyDN(dn, newRDN, deleteOldRDN);
    }

    @Override
    @NotNull
    public LDAPResult modifyDN(@NotNull String dn, @NotNull String newRDN, boolean deleteOldRDN, @Nullable String newSuperiorDN) throws LDAPException {
        return this.connection.modifyDN(dn, newRDN, deleteOldRDN, newSuperiorDN);
    }

    @Override
    @NotNull
    public LDAPResult modifyDN(@NotNull ModifyDNRequest modifyDNRequest) throws LDAPException {
        return this.connection.modifyDN(modifyDNRequest);
    }

    @Override
    @NotNull
    public LDAPResult modifyDN(@NotNull ReadOnlyModifyDNRequest modifyDNRequest) throws LDAPException {
        return this.connection.modifyDN(modifyDNRequest);
    }

    @Override
    @NotNull
    public SearchResult search(@NotNull String baseDN, @NotNull SearchScope scope, @NotNull String filter, String ... attributes) throws LDAPSearchException {
        return this.connection.search(baseDN, scope, filter, attributes);
    }

    @Override
    @NotNull
    public SearchResult search(@NotNull String baseDN, @NotNull SearchScope scope, @NotNull Filter filter, String ... attributes) throws LDAPSearchException {
        return this.connection.search(baseDN, scope, filter, attributes);
    }

    @Override
    @NotNull
    public SearchResult search(@Nullable SearchResultListener searchResultListener, @NotNull String baseDN, @NotNull SearchScope scope, @NotNull String filter, String ... attributes) throws LDAPSearchException {
        return this.connection.search(searchResultListener, baseDN, scope, filter, attributes);
    }

    @Override
    @NotNull
    public SearchResult search(@Nullable SearchResultListener searchResultListener, @NotNull String baseDN, @NotNull SearchScope scope, @NotNull Filter filter, String ... attributes) throws LDAPSearchException {
        return this.connection.search(searchResultListener, baseDN, scope, filter, attributes);
    }

    @Override
    @NotNull
    public SearchResult search(@NotNull String baseDN, @NotNull SearchScope scope, @NotNull DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, @NotNull String filter, String ... attributes) throws LDAPSearchException {
        return this.connection.search(baseDN, scope, derefPolicy, sizeLimit, timeLimit, typesOnly, filter, attributes);
    }

    @Override
    @NotNull
    public SearchResult search(@NotNull String baseDN, @NotNull SearchScope scope, @NotNull DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, @NotNull Filter filter, String ... attributes) throws LDAPSearchException {
        return this.connection.search(baseDN, scope, derefPolicy, sizeLimit, timeLimit, typesOnly, filter, attributes);
    }

    @Override
    @NotNull
    public SearchResult search(@Nullable SearchResultListener searchResultListener, @NotNull String baseDN, @NotNull SearchScope scope, @NotNull DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, @NotNull String filter, String ... attributes) throws LDAPSearchException {
        return this.connection.search(searchResultListener, baseDN, scope, derefPolicy, sizeLimit, timeLimit, typesOnly, filter, attributes);
    }

    @Override
    @NotNull
    public SearchResult search(@Nullable SearchResultListener searchResultListener, @NotNull String baseDN, @NotNull SearchScope scope, @NotNull DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, @NotNull Filter filter, String ... attributes) throws LDAPSearchException {
        return this.connection.search(searchResultListener, baseDN, scope, derefPolicy, sizeLimit, timeLimit, typesOnly, filter, attributes);
    }

    @Override
    @NotNull
    public SearchResult search(@NotNull SearchRequest searchRequest) throws LDAPSearchException {
        return this.connection.search(searchRequest);
    }

    @Override
    @NotNull
    public SearchResult search(@NotNull ReadOnlySearchRequest searchRequest) throws LDAPSearchException {
        return this.connection.search(searchRequest);
    }

    @Override
    @Nullable
    public SearchResultEntry searchForEntry(@NotNull String baseDN, @NotNull SearchScope scope, @NotNull String filter, String ... attributes) throws LDAPSearchException {
        return this.connection.searchForEntry(baseDN, scope, filter, attributes);
    }

    @Override
    @Nullable
    public SearchResultEntry searchForEntry(@NotNull String baseDN, @NotNull SearchScope scope, @NotNull Filter filter, String ... attributes) throws LDAPSearchException {
        return this.connection.searchForEntry(baseDN, scope, filter, attributes);
    }

    @Override
    @Nullable
    public SearchResultEntry searchForEntry(@NotNull String baseDN, @NotNull SearchScope scope, @NotNull DereferencePolicy derefPolicy, int timeLimit, boolean typesOnly, @NotNull String filter, String ... attributes) throws LDAPSearchException {
        return this.connection.searchForEntry(baseDN, scope, derefPolicy, timeLimit, typesOnly, filter, attributes);
    }

    @Override
    @Nullable
    public SearchResultEntry searchForEntry(@NotNull String baseDN, @NotNull SearchScope scope, @NotNull DereferencePolicy derefPolicy, int timeLimit, boolean typesOnly, @NotNull Filter filter, String ... attributes) throws LDAPSearchException {
        return this.connection.searchForEntry(baseDN, scope, derefPolicy, timeLimit, typesOnly, filter, attributes);
    }

    @Override
    @Nullable
    public SearchResultEntry searchForEntry(@NotNull SearchRequest searchRequest) throws LDAPSearchException {
        return this.connection.searchForEntry(searchRequest);
    }

    @Override
    @Nullable
    public SearchResultEntry searchForEntry(@NotNull ReadOnlySearchRequest searchRequest) throws LDAPSearchException {
        return this.connection.searchForEntry(searchRequest);
    }
}

