/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.rank_eval;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.core.rank_eval.DocumentRating;
import org.opensearch.client.opensearch.core.rank_eval.RankEvalQuery;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class RankEvalRequestItem
implements PlainJsonSerializable {
    private final String id;
    @Nullable
    private final RankEvalQuery request;
    private final List<DocumentRating> ratings;
    @Nullable
    private final String templateId;
    private final Map<String, JsonData> params;
    public static final JsonpDeserializer<RankEvalRequestItem> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RankEvalRequestItem::setupRankEvalRequestItemDeserializer);

    private RankEvalRequestItem(Builder builder) {
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.request = builder.request;
        this.ratings = ApiTypeHelper.unmodifiableRequired(builder.ratings, (Object)this, "ratings");
        this.templateId = builder.templateId;
        this.params = ApiTypeHelper.unmodifiable(builder.params);
    }

    public static RankEvalRequestItem of(Function<Builder, ObjectBuilder<RankEvalRequestItem>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String id() {
        return this.id;
    }

    @Nullable
    public final RankEvalQuery request() {
        return this.request;
    }

    public final List<DocumentRating> ratings() {
        return this.ratings;
    }

    @Nullable
    public final String templateId() {
        return this.templateId;
    }

    public final Map<String, JsonData> params() {
        return this.params;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("id");
        generator.write(this.id);
        if (this.request != null) {
            generator.writeKey("request");
            this.request.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.ratings)) {
            generator.writeKey("ratings");
            generator.writeStartArray();
            for (DocumentRating documentRating : this.ratings) {
                documentRating.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.templateId != null) {
            generator.writeKey("template_id");
            generator.write(this.templateId);
        }
        if (ApiTypeHelper.isDefined(this.params)) {
            generator.writeKey("params");
            generator.writeStartObject();
            for (Map.Entry entry : this.params.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupRankEvalRequestItemDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id");
        op.add(Builder::request, RankEvalQuery._DESERIALIZER, "request");
        op.add(Builder::ratings, JsonpDeserializer.arrayDeserializer(DocumentRating._DESERIALIZER), "ratings");
        op.add(Builder::templateId, JsonpDeserializer.stringDeserializer(), "template_id");
        op.add(Builder::params, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "params");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<RankEvalRequestItem> {
        private String id;
        @Nullable
        private RankEvalQuery request;
        private List<DocumentRating> ratings;
        @Nullable
        private String templateId;
        @Nullable
        private Map<String, JsonData> params;

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder request(@Nullable RankEvalQuery value) {
            this.request = value;
            return this;
        }

        public final Builder request(Function<RankEvalQuery.Builder, ObjectBuilder<RankEvalQuery>> fn) {
            return this.request(fn.apply(new RankEvalQuery.Builder()).build());
        }

        public final Builder ratings(List<DocumentRating> list) {
            this.ratings = Builder._listAddAll(this.ratings, list);
            return this;
        }

        public final Builder ratings(DocumentRating value, DocumentRating ... values) {
            this.ratings = Builder._listAdd(this.ratings, value, values);
            return this;
        }

        public final Builder ratings(Function<DocumentRating.Builder, ObjectBuilder<DocumentRating>> fn) {
            return this.ratings(fn.apply(new DocumentRating.Builder()).build(), new DocumentRating[0]);
        }

        public final Builder templateId(@Nullable String value) {
            this.templateId = value;
            return this;
        }

        public final Builder params(Map<String, JsonData> map) {
            this.params = Builder._mapPutAll(this.params, map);
            return this;
        }

        public final Builder params(String key, JsonData value) {
            this.params = Builder._mapPut(this.params, key, value);
            return this;
        }

        @Override
        public RankEvalRequestItem build() {
            this._checkSingleUse();
            return new RankEvalRequestItem(this);
        }
    }
}

