/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver.tls;

import java.util.Optional;
import org.apache.james.core.Username;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.HookReturnCode;
import org.apache.james.protocols.smtp.hook.MailParametersHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmtpRequireTlsParameterHook
implements MailParametersHook {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmtpRequireTlsParameterHook.class);
    private static final String REQUIRETLS = "REQUIRETLS";
    public static final ProtocolSession.AttachmentKey<Boolean> REQUIRETLS_KEY = ProtocolSession.AttachmentKey.of((String)"REQUIRETLS", Boolean.class);

    public HookResult doMailParameter(SMTPSession session, String paramName, String paramValue) {
        if (session.getAttachment(REQUIRETLS_KEY, ProtocolSession.State.Transaction).isPresent()) {
            LOGGER.debug("The Mail parameter cannot contain more than one REQUIRETLS parameter at the same time");
            return HookResult.builder().smtpReturnCode("501").hookReturnCode(HookReturnCode.deny()).smtpDescription("The Mail parameter cannot contain more than one REQUIRETLS parameter at the same time").build();
        }
        if (paramName.equals(REQUIRETLS) && session.isStartTLSSupported() && session.isTLSStarted()) {
            session.setAttachment(REQUIRETLS_KEY, (Object)true, ProtocolSession.State.Transaction);
            String userName = Optional.ofNullable(session.getUsername()).map(Username::asString).orElse("unauthorized");
            LOGGER.info("SMTP sessionID: {}, User: {}, REQUIRETLS=true", (Object)session.getSessionID(), (Object)userName);
        }
        return HookResult.DECLINED;
    }

    public String[] getMailParamNames() {
        return new String[]{REQUIRETLS};
    }
}

