/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.tika;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.james.mailbox.model.ContentType;
import org.apache.james.util.Port;

public class TikaConfiguration {
    public static final long DEFAULT_CACHE_LIMIT_100_MB = 0x6400000L;
    public static final Duration DEFAULT_CACHE_EVICTION_PERIOD = Duration.ofDays(1L);
    public static final boolean DEFAULT_DISABLED = false;
    public static final String DEFAULT_HOST = "127.0.0.1";
    public static final int DEFAULT_PORT = 9998;
    public static final int DEFAULT_TIMEOUT_IN_MS = Ints.checkedCast((long)TimeUnit.SECONDS.toMillis(30L));
    private final boolean enabled;
    private final boolean cacheEnabled;
    private final String host;
    private final int port;
    private final int timeoutInMillis;
    private final Duration cacheEvictionPeriod;
    private final long cacheWeightInBytes;
    private final ImmutableSet<ContentType.MimeType> contentTypeBlacklist;

    public static Builder builder() {
        return new Builder();
    }

    private TikaConfiguration(boolean enabled, boolean cacheEnabled, String host, int port, int timeoutInMillis, Duration cacheEvictionPeriod, long cacheWeightInBytes, ImmutableSet<ContentType.MimeType> contentTypeBlacklist) {
        this.enabled = enabled;
        this.cacheEnabled = cacheEnabled;
        this.host = host;
        this.port = port;
        this.timeoutInMillis = timeoutInMillis;
        this.cacheEvictionPeriod = cacheEvictionPeriod;
        this.cacheWeightInBytes = cacheWeightInBytes;
        this.contentTypeBlacklist = contentTypeBlacklist;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getTimeoutInMillis() {
        return this.timeoutInMillis;
    }

    public Duration getCacheEvictionPeriod() {
        return this.cacheEvictionPeriod;
    }

    public long getCacheWeightInBytes() {
        return this.cacheWeightInBytes;
    }

    public ImmutableSet<ContentType.MimeType> getContentTypeBlacklist() {
        return this.contentTypeBlacklist;
    }

    public final boolean equals(Object o) {
        if (o instanceof TikaConfiguration) {
            TikaConfiguration that = (TikaConfiguration)o;
            return Objects.equals(this.enabled, that.enabled) && Objects.equals(this.cacheEnabled, that.cacheEnabled) && Objects.equals(this.port, that.port) && Objects.equals(this.timeoutInMillis, that.timeoutInMillis) && Objects.equals(this.cacheWeightInBytes, that.cacheWeightInBytes) && Objects.equals(this.host, that.host) && Objects.equals(this.cacheEvictionPeriod, that.cacheEvictionPeriod) && Objects.equals(this.contentTypeBlacklist, that.contentTypeBlacklist);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.enabled, this.cacheEnabled, this.host, this.port, this.timeoutInMillis, this.cacheEvictionPeriod, this.cacheWeightInBytes, this.contentTypeBlacklist);
    }

    public static class Builder {
        private Optional<Boolean> isEnabled = Optional.empty();
        private Optional<Boolean> isCacheEnabled = Optional.empty();
        private Optional<String> host = Optional.empty();
        private Optional<Integer> port = Optional.empty();
        private Optional<Integer> timeoutInMillis = Optional.empty();
        private Optional<Duration> cacheEvictionPeriod = Optional.empty();
        private Optional<Long> cacheWeightInBytes = Optional.empty();
        private ImmutableSet.Builder<ContentType.MimeType> contentTypeBlacklist = ImmutableSet.builder();

        private Builder() {
        }

        public Builder enable(Optional<Boolean> isEnabled) {
            Preconditions.checkNotNull(isEnabled);
            this.isEnabled = isEnabled;
            return this;
        }

        public Builder enabled() {
            this.isEnabled = Optional.of(true);
            return this;
        }

        public Builder disabled() {
            this.isEnabled = Optional.of(false);
            return this;
        }

        public Builder cacheEnable(Optional<Boolean> isEnabled) {
            Preconditions.checkNotNull(isEnabled);
            this.isCacheEnabled = isEnabled;
            return this;
        }

        public Builder cacheEnabled() {
            this.isCacheEnabled = Optional.of(true);
            return this;
        }

        public Builder cacheDisabled() {
            this.isCacheEnabled = Optional.of(false);
            return this;
        }

        public Builder host(String host) {
            Preconditions.checkNotNull((Object)host);
            this.host = Optional.of(host);
            return this;
        }

        public Builder host(Optional<String> host) {
            Preconditions.checkNotNull(host);
            this.host = host;
            return this;
        }

        public Builder port(int port) {
            this.port = Optional.of(port);
            return this;
        }

        public Builder port(Optional<Integer> port) {
            Preconditions.checkNotNull(port);
            this.port = port;
            return this;
        }

        public Builder timeoutInMillis(int timeoutInMillis) {
            this.timeoutInMillis = Optional.of(timeoutInMillis);
            return this;
        }

        public Builder timeoutInMillis(Optional<Integer> timeoutInMillis) {
            Preconditions.checkNotNull(timeoutInMillis);
            this.timeoutInMillis = timeoutInMillis;
            return this;
        }

        public Builder cacheEvictionPeriod(Duration duration) {
            this.cacheEvictionPeriod = Optional.of(duration);
            return this;
        }

        public Builder cacheEvictionPeriod(Optional<Duration> duration) {
            this.cacheEvictionPeriod = duration;
            return this;
        }

        public Builder cacheWeightInBytes(long weight) {
            this.cacheWeightInBytes = Optional.of(weight);
            return this;
        }

        public Builder cacheWeightInBytes(Optional<Long> weight) {
            this.cacheWeightInBytes = weight;
            return this;
        }

        public Builder contentTypeBlacklist(Set<ContentType.MimeType> contentTypeBlacklist) {
            Preconditions.checkNotNull(contentTypeBlacklist);
            this.contentTypeBlacklist.addAll(contentTypeBlacklist);
            return this;
        }

        public TikaConfiguration build() {
            this.port.ifPresent(Port::assertValid);
            return new TikaConfiguration(this.isEnabled.orElse(false), this.isCacheEnabled.orElse(false), this.host.orElse(TikaConfiguration.DEFAULT_HOST), this.port.orElse(9998), this.timeoutInMillis.orElse(DEFAULT_TIMEOUT_IN_MS), this.cacheEvictionPeriod.orElse(DEFAULT_CACHE_EVICTION_PERIOD), this.cacheWeightInBytes.orElse(0x6400000L), (ImmutableSet<ContentType.MimeType>)this.contentTypeBlacklist.build());
        }
    }
}

