/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core.fastfail;

import com.google.common.annotations.VisibleForTesting;
import jakarta.inject.Inject;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.RcptHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpamTrapHandler
implements RcptHook {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpamTrapHandler.class);
    private final Map<String, Long> blockedIps;
    private final Clock clock;
    private Collection<String> spamTrapRecips = new ArrayList<String>();
    protected long blockTime = 4320000L;

    @Inject
    public SpamTrapHandler() {
        this(Clock.systemUTC());
    }

    @VisibleForTesting
    public SpamTrapHandler(Clock clock) {
        this.blockedIps = new ConcurrentHashMap<String, Long>();
        this.clock = clock;
    }

    public void setSpamTrapRecipients(Collection<String> spamTrapRecips) {
        this.spamTrapRecips = spamTrapRecips;
    }

    public void setBlockTime(long blockTime) {
        this.blockTime = blockTime;
    }

    @Override
    public HookResult doRcpt(SMTPSession session, MaybeSender sender, MailAddress rcpt) {
        String address = session.getRemoteAddress().getAddress().getHostAddress();
        if (this.isBlocked(address)) {
            return HookResult.DENY;
        }
        if (this.spamTrapRecips.contains(rcpt.toString().toLowerCase(Locale.US))) {
            this.addIp(address);
            return HookResult.DENY;
        }
        return HookResult.DECLINED;
    }

    private boolean isBlocked(String ip) {
        Long rawTime = this.blockedIps.get(ip);
        if (rawTime != null) {
            long blockTime = rawTime;
            if (blockTime > this.clock.millis()) {
                LOGGER.debug("BlockList contain Ip {}", (Object)ip);
                return true;
            }
            LOGGER.debug("Remove ip {} from blockList", (Object)ip);
            this.blockedIps.remove(ip);
        }
        return false;
    }

    private void addIp(String ip) {
        long bTime = this.clock.millis() + this.blockTime;
        LOGGER.debug("Add ip {} for {} to blockList", (Object)ip, (Object)bTime);
        this.blockedIps.put(ip, bTime);
    }
}

