/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox;

import com.github.fge.lambdas.Throwing;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterators;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.mail.Flags;
import javax.mail.internet.SharedInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.UnsupportedRightException;
import org.apache.james.mailbox.model.ByteContent;
import org.apache.james.mailbox.model.ComposedMessageId;
import org.apache.james.mailbox.model.ComposedMessageIdWithMetaData;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxCounters;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageAttachmentMetadata;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mailbox.model.MessageResultIterator;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.mailbox.model.ThreadId;
import org.apache.james.mailbox.model.UidValidity;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.message.DefaultMessageWriter;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface MessageManager {
    public long getMessageCount(MailboxSession var1) throws MailboxException;

    public MailboxCounters getMailboxCounters(MailboxSession var1) throws MailboxException;

    public Publisher<MailboxCounters> getMailboxCountersReactive(MailboxSession var1);

    @Deprecated
    public boolean isWriteable(MailboxSession var1) throws MailboxException;

    public Publisher<MessageUid> search(SearchQuery var1, MailboxSession var2) throws MailboxException;

    public Iterator<MessageUid> expunge(MessageRange var1, MailboxSession var2) throws MailboxException;

    default public Flux<MessageUid> expungeReactive(MessageRange set, MailboxSession mailboxSession) {
        return Flux.fromStream((Supplier)Throwing.supplier(() -> StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.expunge(set, mailboxSession), 16), false)));
    }

    public void delete(List<MessageUid> var1, MailboxSession var2) throws MailboxException;

    default public Mono<Void> deleteReactive(List<MessageUid> uids, MailboxSession mailboxSession) {
        return Mono.fromRunnable((Runnable)Throwing.runnable(() -> this.delete(uids, mailboxSession)));
    }

    public Map<MessageUid, Flags> setFlags(Flags var1, FlagsUpdateMode var2, MessageRange var3, MailboxSession var4) throws MailboxException;

    default public Publisher<Map<MessageUid, Flags>> setFlagsReactive(Flags flags, FlagsUpdateMode flagsUpdateMode, MessageRange set, MailboxSession mailboxSession) {
        return Mono.fromCallable(() -> this.setFlags(flags, flagsUpdateMode, set, mailboxSession));
    }

    public AppendResult appendMessage(InputStream var1, Date var2, MailboxSession var3, boolean var4, Flags var5) throws MailboxException;

    public AppendResult appendMessage(AppendCommand var1, MailboxSession var2) throws MailboxException;

    public Publisher<AppendResult> appendMessageReactive(AppendCommand var1, MailboxSession var2);

    public MessageResultIterator getMessages(MessageRange var1, FetchGroup var2, MailboxSession var3) throws MailboxException;

    default public Publisher<MessageResult> getMessagesReactive(MessageRange set, FetchGroup fetchGroup, MailboxSession mailboxSession) {
        try {
            MessageResultIterator messages = this.getMessages(set, fetchGroup, mailboxSession);
            Stream<MessageResult> stream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(messages, 16), false);
            return Flux.fromStream(stream);
        }
        catch (MailboxException e) {
            return Flux.error((Throwable)e);
        }
    }

    public Publisher<ComposedMessageIdWithMetaData> listMessagesMetadata(MessageRange var1, MailboxSession var2);

    public Mailbox getMailboxEntity() throws MailboxException;

    public EnumSet<MailboxManager.MessageCapabilities> getSupportedMessageCapabilities();

    public MailboxId getId();

    public MailboxPath getMailboxPath();

    public Flags getApplicableFlags(MailboxSession var1) throws MailboxException;

    default public Mono<Flags> getApplicableFlagsReactive(MailboxSession session) {
        return Mono.fromCallable(() -> this.getApplicableFlags(session));
    }

    default public MailboxMetaData getMetaData(MailboxMetaData.RecentMode recentMode, MailboxSession mailboxSession, MailboxMetaData.FetchGroup fetchGroup) throws MailboxException {
        return this.getMetaData(recentMode, mailboxSession, fetchGroup.getItems());
    }

    public MailboxMetaData getMetaData(MailboxMetaData.RecentMode var1, MailboxSession var2, EnumSet<MailboxMetaData.Item> var3) throws MailboxException;

    default public Mono<MailboxMetaData> getMetaDataReactive(MailboxMetaData.RecentMode recentMode, MailboxSession mailboxSession, EnumSet<MailboxMetaData.Item> items) throws MailboxException {
        return Mono.fromCallable(() -> this.getMetaData(recentMode, mailboxSession, items));
    }

    public Flags getPermanentFlags(MailboxSession var1);

    public MailboxACL getResolvedAcl(MailboxSession var1) throws UnsupportedRightException;

    public static class MailboxMetaData {
        private final long recentCount;
        private final ImmutableList<MessageUid> recent;
        private final Flags permanentFlags;
        private final UidValidity uidValidity;
        private final MessageUid nextUid;
        private final long messageCount;
        private final long unseenCount;
        private final MessageUid firstUnseen;
        private final boolean writeable;
        private final ModSeq highestModSeq;
        private final MailboxACL acl;

        public static MailboxMetaData sensibleInformationFree(MailboxACL resolvedAcl, UidValidity uidValidity, boolean writeable) {
            ImmutableList recents = ImmutableList.of();
            MessageUid uidNext = MessageUid.MIN_VALUE;
            ModSeq highestModSeq = ModSeq.first();
            long messageCount = 0L;
            long unseenCount = 0L;
            MessageUid firstUnseen = null;
            return new MailboxMetaData((List<MessageUid>)recents, new Flags(), uidValidity, uidNext, highestModSeq, messageCount, unseenCount, firstUnseen, writeable, resolvedAcl);
        }

        public MailboxMetaData(List<MessageUid> recent, Flags permanentFlags, UidValidity uidValidity, MessageUid uidNext, ModSeq highestModSeq, long messageCount, long unseenCount, MessageUid firstUnseen, boolean writeable, MailboxACL acl) {
            this.recent = Optional.ofNullable(recent).map(ImmutableList::copyOf).orElseGet(ImmutableList::of);
            this.highestModSeq = highestModSeq;
            this.recentCount = this.recent.size();
            this.permanentFlags = permanentFlags;
            this.uidValidity = uidValidity;
            this.nextUid = uidNext;
            this.messageCount = messageCount;
            this.unseenCount = unseenCount;
            this.firstUnseen = firstUnseen;
            this.writeable = writeable;
            this.acl = acl;
        }

        public long countRecent() {
            return this.recentCount;
        }

        public Flags getPermanentFlags() {
            return this.permanentFlags;
        }

        public List<MessageUid> getRecent() {
            return this.recent;
        }

        public UidValidity getUidValidity() {
            return this.uidValidity;
        }

        public MessageUid getUidNext() {
            return this.nextUid;
        }

        public long getMessageCount() {
            return this.messageCount;
        }

        public long getUnseenCount() {
            return this.unseenCount;
        }

        public MessageUid getFirstUnseen() {
            return this.firstUnseen;
        }

        public boolean isWriteable() {
            return this.writeable;
        }

        public ModSeq getHighestModSeq() {
            return this.highestModSeq;
        }

        public MailboxACL getACL() {
            return this.acl;
        }

        public static enum FetchGroup {
            NO_UNSEEN(EnumSet.of(Item.MailboxCounters, Item.NextUid, Item.HighestModSeq)),
            UNSEEN_COUNT(EnumSet.of(Item.MailboxCounters, Item.NextUid, Item.HighestModSeq)),
            FIRST_UNSEEN(EnumSet.of(Item.MailboxCounters, Item.NextUid, Item.HighestModSeq, Item.FirstUnseen)),
            NO_COUNT(EnumSet.of(Item.NextUid, Item.HighestModSeq));

            private final EnumSet<Item> items;

            private FetchGroup(EnumSet<Item> items) {
                this.items = items;
            }

            public EnumSet<Item> getItems() {
                return this.items;
            }
        }

        public static enum Item {
            MailboxCounters,
            FirstUnseen,
            HighestModSeq,
            NextUid;

        }

        public static enum RecentMode {
            RESET,
            RETRIEVE,
            IGNORE;

        }
    }

    public static class AppendCommand {
        private final Content msgIn;
        private final Date internalDate;
        private final boolean isRecent;
        private final boolean isDelivery;
        private final Flags flags;
        private final Optional<Message> maybeParsedMessage;

        public static AppendCommand from(Message.Builder builder) throws IOException {
            return AppendCommand.builder().build(builder);
        }

        public static AppendCommand from(Message message) throws IOException {
            return AppendCommand.builder().build(message);
        }

        public static AppendCommand from(Content message) {
            return AppendCommand.builder().build(message);
        }

        public static AppendCommand from(SharedInputStream message) {
            return AppendCommand.builder().build(message);
        }

        public static Builder builder() {
            return new Builder();
        }

        private AppendCommand(Content msgIn, Date internalDate, boolean isRecent, boolean isDelivery, Flags flags, Optional<Message> maybeParsedMessage) {
            this.msgIn = msgIn;
            this.internalDate = internalDate;
            this.isRecent = isRecent;
            this.isDelivery = isDelivery;
            this.flags = flags;
            this.maybeParsedMessage = maybeParsedMessage;
        }

        public Content getMsgIn() {
            return this.msgIn;
        }

        public Date getInternalDate() {
            return this.internalDate;
        }

        public boolean isRecent() {
            return this.isRecent;
        }

        public boolean isDelivery() {
            return this.isDelivery;
        }

        public Flags getFlags() {
            return this.flags;
        }

        public Optional<Message> getMaybeParsedMessage() {
            return this.maybeParsedMessage;
        }

        public static class Builder {
            private Optional<Date> internalDate = Optional.empty();
            private Optional<Boolean> isRecent = Optional.empty();
            private Optional<Boolean> isDelivery = Optional.empty();
            private Optional<Flags> flags = Optional.empty();
            private Optional<Message> maybeParsedMessage = Optional.empty();

            private Builder() {
            }

            public Builder withFlags(Flags flags) {
                this.flags = Optional.of(flags);
                return this;
            }

            public Builder withInternalDate(Date date) {
                this.internalDate = Optional.of(date);
                return this;
            }

            public Builder withInternalDate(Optional<Date> date) {
                this.internalDate = date;
                return this;
            }

            public Builder isRecent(boolean recent) {
                this.isRecent = Optional.of(recent);
                return this;
            }

            public Builder recent() {
                return this.isRecent(true);
            }

            public Builder notRecent() {
                return this.isRecent(false);
            }

            public Builder isDelivery(boolean isDelivery) {
                this.isDelivery = Optional.of(isDelivery);
                return this;
            }

            public Builder delivery() {
                return this.isDelivery(true);
            }

            public Builder notDelivery() {
                return this.isDelivery(false);
            }

            public Builder withParsedMessage(Message message) {
                this.maybeParsedMessage = Optional.of(message);
                return this;
            }

            public AppendCommand build(Content msgIn) {
                return new AppendCommand(msgIn, this.internalDate.orElse(new Date()), this.isRecent.orElse(true), this.isDelivery.orElse(false), this.flags.orElse(new Flags()), this.maybeParsedMessage);
            }

            public AppendCommand build(final SharedInputStream msgIn) {
                return this.build(new Content(){

                    @Override
                    public InputStream getInputStream() {
                        return msgIn.newStream(0L, -1L);
                    }

                    @Override
                    public long size() throws MailboxException {
                        try {
                            return IOUtils.consume((InputStream)this.getInputStream());
                        }
                        catch (IOException e) {
                            throw new MailboxException("Cannot compute content size", e);
                        }
                    }
                });
            }

            public AppendCommand build(byte[] msgIn) {
                return this.build(new ByteContent(msgIn));
            }

            public AppendCommand build(String msgIn) {
                return this.build(msgIn.getBytes(StandardCharsets.UTF_8));
            }

            public AppendCommand build(Message message) throws IOException {
                return this.withParsedMessage(message).build(DefaultMessageWriter.asBytes((Message)message));
            }

            public AppendCommand build(Message.Builder messageBuilder) throws IOException {
                return this.build(messageBuilder.build());
            }
        }
    }

    public static class AppendResult {
        private final ComposedMessageId id;
        private final Long size;
        private final Optional<List<MessageAttachmentMetadata>> messageAttachments;
        private final ThreadId threadId;

        public AppendResult(ComposedMessageId id, Long size, Optional<List<MessageAttachmentMetadata>> messageAttachments, ThreadId threadId) {
            this.id = id;
            this.size = size;
            this.messageAttachments = messageAttachments;
            this.threadId = threadId;
        }

        public ComposedMessageId getId() {
            return this.id;
        }

        public Long getSize() {
            return this.size;
        }

        public List<MessageAttachmentMetadata> getMessageAttachments() {
            Preconditions.checkState((boolean)this.messageAttachments.isPresent(), (Object)"'attachment storage' not supported by the implementation");
            return this.messageAttachments.get();
        }

        public ThreadId getThreadId() {
            return this.threadId;
        }

        public final boolean equals(Object o) {
            if (o instanceof AppendResult) {
                AppendResult that = (AppendResult)o;
                return Objects.equals(this.id, that.id) && Objects.equals(this.messageAttachments, that.messageAttachments) && Objects.equals(this.size, that.size) && Objects.equals(this.threadId, that.threadId);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.id, this.messageAttachments, this.size, this.threadId);
        }
    }

    public static enum FlagsUpdateMode {
        ADD,
        REMOVE,
        REPLACE;

    }
}

