/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.data;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import java.io.FileNotFoundException;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.backends.cassandra.components.CassandraModule;
import org.apache.james.core.healthcheck.HealthCheck;
import org.apache.james.eventsourcing.Event;
import org.apache.james.eventsourcing.eventstore.EventStore;
import org.apache.james.eventsourcing.eventstore.cassandra.dto.EventDTO;
import org.apache.james.eventsourcing.eventstore.cassandra.dto.EventDTOModule;
import org.apache.james.jmap.api.access.AccessTokenRepository;
import org.apache.james.jmap.api.filtering.FilteringManagement;
import org.apache.james.jmap.api.filtering.impl.EventSourcingFilteringManagement;
import org.apache.james.jmap.api.filtering.impl.FilterUsernameChangeTaskStep;
import org.apache.james.jmap.api.identity.CustomIdentityDAO;
import org.apache.james.jmap.api.projections.EmailQueryView;
import org.apache.james.jmap.api.projections.MessageFastViewProjection;
import org.apache.james.jmap.api.projections.MessageFastViewProjectionHealthCheck;
import org.apache.james.jmap.api.pushsubscription.PushSubscriptionRepository;
import org.apache.james.jmap.api.upload.UploadRepository;
import org.apache.james.jmap.cassandra.access.CassandraAccessModule;
import org.apache.james.jmap.cassandra.access.CassandraAccessTokenRepository;
import org.apache.james.jmap.cassandra.change.CassandraEmailChangeModule;
import org.apache.james.jmap.cassandra.change.CassandraMailboxChangeModule;
import org.apache.james.jmap.cassandra.filtering.CassandraFilteringProjection;
import org.apache.james.jmap.cassandra.filtering.CassandraFilteringProjectionModule;
import org.apache.james.jmap.cassandra.filtering.FilteringRuleSetDefineDTOModules;
import org.apache.james.jmap.cassandra.identity.CassandraCustomIdentityDAO;
import org.apache.james.jmap.cassandra.identity.CassandraCustomIdentityModule;
import org.apache.james.jmap.cassandra.projections.CassandraEmailQueryView;
import org.apache.james.jmap.cassandra.projections.CassandraEmailQueryViewModule;
import org.apache.james.jmap.cassandra.projections.CassandraMessageFastViewProjection;
import org.apache.james.jmap.cassandra.projections.CassandraMessageFastViewProjectionModule;
import org.apache.james.jmap.cassandra.pushsubscription.CassandraPushSubscriptionModule;
import org.apache.james.jmap.cassandra.pushsubscription.CassandraPushSubscriptionRepository;
import org.apache.james.jmap.cassandra.upload.CassandraUploadRepository;
import org.apache.james.jmap.cassandra.upload.UploadConfiguration;
import org.apache.james.jmap.cassandra.upload.UploadDAO;
import org.apache.james.jmap.cassandra.upload.UploadModule;
import org.apache.james.user.api.UsernameChangeTaskStep;
import org.apache.james.utils.PropertiesProvider;

public class CassandraJmapModule
extends AbstractModule {
    protected void configure() {
        this.bind(CassandraAccessTokenRepository.class).in(Scopes.SINGLETON);
        this.bind(AccessTokenRepository.class).to(CassandraAccessTokenRepository.class);
        this.bind(CassandraUploadRepository.class).in(Scopes.SINGLETON);
        this.bind(UploadDAO.class).in(Scopes.SINGLETON);
        this.bind(UploadRepository.class).to(CassandraUploadRepository.class);
        this.bind(UploadConfiguration.class).toInstance((Object)UploadConfiguration.SINGLETON);
        this.bind(CassandraCustomIdentityDAO.class).in(Scopes.SINGLETON);
        this.bind(CustomIdentityDAO.class).to(CassandraCustomIdentityDAO.class);
        this.bind(CassandraFilteringProjection.class).in(Scopes.SINGLETON);
        this.bind(EventSourcingFilteringManagement.ReadProjection.class).to(CassandraFilteringProjection.class);
        this.bind(CassandraPushSubscriptionRepository.class).in(Scopes.SINGLETON);
        this.bind(PushSubscriptionRepository.class).to(CassandraPushSubscriptionRepository.class);
        this.bind(CassandraMessageFastViewProjection.class).in(Scopes.SINGLETON);
        this.bind(MessageFastViewProjection.class).to(CassandraMessageFastViewProjection.class);
        this.bind(MessageFastViewProjectionHealthCheck.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)this.binder(), HealthCheck.class).addBinding().to(MessageFastViewProjectionHealthCheck.class);
        this.bind(CassandraEmailQueryView.class).in(Scopes.SINGLETON);
        this.bind(EmailQueryView.class).to(CassandraEmailQueryView.class);
        Multibinder cassandraDataDefinitions = Multibinder.newSetBinder((Binder)this.binder(), CassandraModule.class);
        cassandraDataDefinitions.addBinding().toInstance((Object)CassandraAccessModule.MODULE);
        cassandraDataDefinitions.addBinding().toInstance((Object)CassandraMessageFastViewProjectionModule.MODULE);
        cassandraDataDefinitions.addBinding().toInstance((Object)CassandraEmailQueryViewModule.MODULE);
        cassandraDataDefinitions.addBinding().toInstance((Object)CassandraMailboxChangeModule.MODULE);
        cassandraDataDefinitions.addBinding().toInstance((Object)CassandraEmailChangeModule.MODULE);
        cassandraDataDefinitions.addBinding().toInstance((Object)UploadModule.MODULE);
        cassandraDataDefinitions.addBinding().toInstance((Object)CassandraPushSubscriptionModule.MODULE);
        cassandraDataDefinitions.addBinding().toInstance((Object)CassandraFilteringProjectionModule.MODULE);
        cassandraDataDefinitions.addBinding().toInstance((Object)CassandraCustomIdentityModule.MODULE());
        Multibinder eventDTOModuleBinder = Multibinder.newSetBinder((Binder)this.binder(), (TypeLiteral)new TypeLiteral<EventDTOModule<? extends Event, ? extends EventDTO>>(){});
        eventDTOModuleBinder.addBinding().toInstance((Object)FilteringRuleSetDefineDTOModules.FILTERING_RULE_SET_DEFINED);
        eventDTOModuleBinder.addBinding().toInstance((Object)FilteringRuleSetDefineDTOModules.FILTERING_INCREMENT);
        Multibinder.newSetBinder((Binder)this.binder(), UsernameChangeTaskStep.class).addBinding().to(FilterUsernameChangeTaskStep.class);
    }

    @Singleton
    @Provides
    FilteringManagement provideFilteringManagement(EventStore eventStore, CassandraFilteringProjection cassandraFilteringProjection, PropertiesProvider propertiesProvider) throws ConfigurationException {
        if (this.cassandraFilterProjectionActivated(propertiesProvider)) {
            return new EventSourcingFilteringManagement(eventStore, (EventSourcingFilteringManagement.ReadProjection)cassandraFilteringProjection);
        }
        return new EventSourcingFilteringManagement(eventStore, (EventSourcingFilteringManagement.ReadProjection)new EventSourcingFilteringManagement.NoReadProjection(eventStore));
    }

    private boolean cassandraFilterProjectionActivated(PropertiesProvider propertiesProvider) throws ConfigurationException {
        try {
            return propertiesProvider.getConfiguration("jmap").getBoolean("cassandra.filter.projection.activated", false);
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }
}

