/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.opensearch.query;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.Date;
import org.apache.james.mailbox.model.SearchQuery;

public class DateResolutionFormatter {
    public static ZonedDateTime computeUpperDate(ZonedDateTime date, SearchQuery.DateResolution resolution) {
        return DateResolutionFormatter.computeLowerDate(date, resolution).plus(1L, DateResolutionFormatter.convertDateResolutionField(resolution));
    }

    public static ZonedDateTime computeLowerDate(ZonedDateTime date, SearchQuery.DateResolution resolution) {
        switch (resolution) {
            case Year: {
                return date.truncatedTo(ChronoUnit.DAYS).withDayOfYear(1);
            }
            case Month: {
                return date.truncatedTo(ChronoUnit.DAYS).withDayOfMonth(1);
            }
        }
        return date.truncatedTo(DateResolutionFormatter.convertDateResolutionField(resolution));
    }

    private static TemporalUnit convertDateResolutionField(SearchQuery.DateResolution resolution) {
        switch (resolution) {
            case Year: {
                return ChronoUnit.YEARS;
            }
            case Month: {
                return ChronoUnit.MONTHS;
            }
            case Day: {
                return ChronoUnit.DAYS;
            }
            case Hour: {
                return ChronoUnit.HOURS;
            }
            case Minute: {
                return ChronoUnit.MINUTES;
            }
            case Second: {
                return ChronoUnit.SECONDS;
            }
        }
        throw new RuntimeException("Unknown Date resolution used");
    }

    public static ZonedDateTime convertDateToZonedDateTime(Date date) {
        return ZonedDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
    }
}

