/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.cassandra;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BatchStatementBuilder;
import com.datastax.oss.driver.api.core.cql.BatchType;
import com.datastax.oss.driver.api.core.cql.BatchableStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.datastax.oss.driver.api.querybuilder.update.Update;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.core.Username;
import org.apache.james.user.api.AlreadyExistInUsersRepositoryException;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.user.api.model.User;
import org.apache.james.user.cassandra.CassandraRepositoryConfiguration;
import org.apache.james.user.cassandra.tables.CassandraUserTable;
import org.apache.james.user.lib.UsersDAO;
import org.apache.james.user.lib.model.Algorithm;
import org.apache.james.user.lib.model.DefaultUser;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraUsersDAO
implements UsersDAO {
    private final CassandraAsyncExecutor executor;
    private final PreparedStatement getUserStatement;
    private final PreparedStatement updateUserStatement;
    private final PreparedStatement removeUserStatement;
    private final PreparedStatement countUserStatement;
    private final PreparedStatement listStatement;
    private final PreparedStatement insertStatement;
    private final PreparedStatement removeAllAuthorizedUsersStatement;
    private final PreparedStatement getAuthorizedUsersStatement;
    private final PreparedStatement addAuthorizedUsersStatement;
    private final PreparedStatement removeAuthorizedUsersStatement;
    private final PreparedStatement getDelegatedToUsersStatement;
    private final PreparedStatement addDelegatedToUsersStatement;
    private final PreparedStatement removeDelegatedToUsersStatement;
    private final Algorithm preferredAlgorithm;
    private final Algorithm.HashingMode fallbackHashingMode;

    @Inject
    public CassandraUsersDAO(CqlSession session, CassandraRepositoryConfiguration configuration) {
        this.executor = new CassandraAsyncExecutor(session);
        this.preferredAlgorithm = configuration.getPreferredAlgorithm();
        this.fallbackHashingMode = configuration.getFallbackHashingMode();
        this.getUserStatement = session.prepare(((Select)QueryBuilder.selectFrom((String)"user").columns(new CqlIdentifier[]{CassandraUserTable.NAME, CassandraUserTable.PASSWORD, CassandraUserTable.ALGORITHM}).whereColumn(CassandraUserTable.NAME).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraUserTable.NAME))).build());
        this.updateUserStatement = session.prepare(((Update)((Update)QueryBuilder.update((String)"user").setColumn(CassandraUserTable.REALNAME, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraUserTable.REALNAME)).setColumn(CassandraUserTable.PASSWORD, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraUserTable.PASSWORD)).setColumn(CassandraUserTable.ALGORITHM, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraUserTable.ALGORITHM)).whereColumn(CassandraUserTable.NAME).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraUserTable.NAME))).ifExists()).build());
        this.removeUserStatement = session.prepare(((Delete)((Delete)QueryBuilder.deleteFrom((String)"user").whereColumn(CassandraUserTable.NAME).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraUserTable.NAME))).ifExists()).build());
        this.countUserStatement = session.prepare(QueryBuilder.selectFrom((String)"user").countAll().build());
        this.listStatement = session.prepare(QueryBuilder.selectFrom((String)"user").column(CassandraUserTable.NAME).build());
        this.insertStatement = session.prepare(QueryBuilder.insertInto((String)"user").value(CassandraUserTable.NAME, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraUserTable.NAME)).value(CassandraUserTable.REALNAME, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraUserTable.REALNAME)).value(CassandraUserTable.PASSWORD, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraUserTable.PASSWORD)).value(CassandraUserTable.ALGORITHM, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraUserTable.ALGORITHM)).ifNotExists().build());
        this.removeAllAuthorizedUsersStatement = session.prepare(((Delete)QueryBuilder.deleteFrom((String)"user").column(CassandraUserTable.AUTHORIZED_USERS).whereColumn(CassandraUserTable.NAME).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraUserTable.NAME))).build());
        this.getAuthorizedUsersStatement = session.prepare(((Select)QueryBuilder.selectFrom((String)"user").columns(new CqlIdentifier[]{CassandraUserTable.AUTHORIZED_USERS}).whereColumn(CassandraUserTable.NAME).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraUserTable.NAME))).build());
        this.addAuthorizedUsersStatement = session.prepare(((Update)QueryBuilder.update((String)"user").append(CassandraUserTable.AUTHORIZED_USERS, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraUserTable.AUTHORIZED_USERS)).whereColumn(CassandraUserTable.NAME).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraUserTable.NAME))).build());
        this.removeAuthorizedUsersStatement = session.prepare(((Update)QueryBuilder.update((String)"user").remove(CassandraUserTable.AUTHORIZED_USERS, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraUserTable.AUTHORIZED_USERS)).whereColumn(CassandraUserTable.NAME).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraUserTable.NAME))).build());
        this.getDelegatedToUsersStatement = session.prepare(((Select)QueryBuilder.selectFrom((String)"user").columns(new CqlIdentifier[]{CassandraUserTable.DELEGATED_USERS}).whereColumn(CassandraUserTable.NAME).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraUserTable.NAME))).build());
        this.addDelegatedToUsersStatement = session.prepare(((Update)QueryBuilder.update((String)"user").append(CassandraUserTable.DELEGATED_USERS, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraUserTable.DELEGATED_USERS)).whereColumn(CassandraUserTable.NAME).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraUserTable.NAME))).build());
        this.removeDelegatedToUsersStatement = session.prepare(((Update)QueryBuilder.update((String)"user").remove(CassandraUserTable.DELEGATED_USERS, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraUserTable.DELEGATED_USERS)).whereColumn(CassandraUserTable.NAME).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraUserTable.NAME))).build());
    }

    @VisibleForTesting
    public CassandraUsersDAO(CqlSession session) {
        this(session, CassandraRepositoryConfiguration.DEFAULT);
    }

    public Optional<DefaultUser> getUserByName(Username name) {
        return this.getUserByNameReactive(name).blockOptional();
    }

    private Mono<DefaultUser> getUserByNameReactive(Username name) {
        return this.executor.executeSingleRow((Statement)this.getUserStatement.bind(new Object[0]).setString(CassandraUserTable.NAME, name.asString())).map(row -> new DefaultUser(Username.of((String)row.getString(CassandraUserTable.NAME)), row.getString(CassandraUserTable.PASSWORD), Algorithm.of((String)row.getString(CassandraUserTable.ALGORITHM), (Algorithm.HashingMode)this.fallbackHashingMode), this.preferredAlgorithm));
    }

    public Mono<Boolean> exist(Username name) {
        return this.executor.executeReturnExists((Statement)this.getUserStatement.bind(new Object[0]).setString(CassandraUserTable.NAME, name.asString()));
    }

    public void updateUser(User user) throws UsersRepositoryException {
        Preconditions.checkArgument((boolean)(user instanceof DefaultUser));
        DefaultUser defaultUser = (DefaultUser)user;
        boolean executed = (Boolean)this.executor.executeReturnApplied((Statement)((BoundStatement)((BoundStatement)((BoundStatement)this.updateUserStatement.bind(new Object[0]).setString(CassandraUserTable.REALNAME, defaultUser.getUserName().asString())).setString(CassandraUserTable.PASSWORD, defaultUser.getHashedPassword())).setString(CassandraUserTable.ALGORITHM, defaultUser.getHashAlgorithm().asString())).setString(CassandraUserTable.NAME, defaultUser.getUserName().asString())).block();
        if (!executed) {
            throw new UsersRepositoryException("Unable to update user");
        }
    }

    public Mono<Void> addAuthorizedUsers(Username baseUser, Username userWithAccess) {
        BatchStatementBuilder batchBuilder = new BatchStatementBuilder(BatchType.LOGGED);
        BoundStatement addAuthorizedStatement = (BoundStatement)((BoundStatement)this.addAuthorizedUsersStatement.bind(new Object[0]).setString(CassandraUserTable.NAME, baseUser.asString())).setSet(CassandraUserTable.AUTHORIZED_USERS, (Set)ImmutableSet.of((Object)userWithAccess.asString()), String.class);
        batchBuilder.addStatement((BatchableStatement)addAuthorizedStatement);
        batchBuilder.addStatement((BatchableStatement)((BoundStatement)this.addDelegatedToUsersStatement.bind(new Object[0]).setString(CassandraUserTable.NAME, userWithAccess.asString())).setSet(CassandraUserTable.DELEGATED_USERS, (Set)ImmutableSet.of((Object)baseUser.asString()), String.class));
        return this.executor.executeVoid((Statement)batchBuilder.build());
    }

    public Mono<Void> removeAuthorizedUser(Username baseUser, Username userWithAccess) {
        return this.executor.executeVoid((Statement)new BatchStatementBuilder(BatchType.LOGGED).addStatement((BatchableStatement)((BoundStatement)this.removeAuthorizedUsersStatement.bind(new Object[0]).setString(CassandraUserTable.NAME, baseUser.asString())).setSet(CassandraUserTable.AUTHORIZED_USERS, (Set)ImmutableSet.of((Object)userWithAccess.asString()), String.class)).addStatement((BatchableStatement)((BoundStatement)this.removeDelegatedToUsersStatement.bind(new Object[0]).setString(CassandraUserTable.NAME, userWithAccess.asString())).setSet(CassandraUserTable.DELEGATED_USERS, (Set)ImmutableSet.of((Object)baseUser.asString()), String.class)).build());
    }

    public Mono<Void> removeAllAuthorizedUsers(Username baseUser) {
        return this.getAuthorizedUsers(baseUser).collectList().map(authorizedList -> {
            BatchStatementBuilder batch = new BatchStatementBuilder(BatchType.LOGGED);
            authorizedList.forEach(username -> batch.addStatement((BatchableStatement)((BoundStatement)this.removeDelegatedToUsersStatement.bind(new Object[0]).setString(CassandraUserTable.NAME, username.asString())).setSet(CassandraUserTable.DELEGATED_USERS, (Set)ImmutableSet.of((Object)baseUser.asString()), String.class)));
            batch.addStatement((BatchableStatement)this.removeAllAuthorizedUsersStatement.bind(new Object[0]).setString(CassandraUserTable.NAME, baseUser.asString()));
            return batch.build();
        }).flatMap(arg_0 -> ((CassandraAsyncExecutor)this.executor).executeVoid(arg_0));
    }

    public Flux<Username> getAuthorizedUsers(Username name) {
        return this.executor.executeSingleRow((Statement)this.getAuthorizedUsersStatement.bind(new Object[0]).setString(CassandraUserTable.NAME, name.asString())).mapNotNull(row -> row.getSet(CassandraUserTable.AUTHORIZED_USERS, String.class)).flatMapIterable(set -> set).map(Username::of);
    }

    public Mono<Void> removeDelegatedToUser(Username baseUser, Username delegatedToUser) {
        return this.executor.executeVoid((Statement)new BatchStatementBuilder(BatchType.LOGGED).addStatement((BatchableStatement)((BoundStatement)this.removeAuthorizedUsersStatement.bind(new Object[0]).setString(CassandraUserTable.NAME, delegatedToUser.asString())).setSet(CassandraUserTable.AUTHORIZED_USERS, (Set)ImmutableSet.of((Object)baseUser.asString()), String.class)).addStatement((BatchableStatement)((BoundStatement)this.removeDelegatedToUsersStatement.bind(new Object[0]).setString(CassandraUserTable.NAME, baseUser.asString())).setSet(CassandraUserTable.DELEGATED_USERS, (Set)ImmutableSet.of((Object)delegatedToUser.asString()), String.class)).build());
    }

    public Flux<Username> getDelegatedToUsers(Username name) {
        return this.executor.executeSingleRow((Statement)this.getDelegatedToUsersStatement.bind(new Object[0]).setString(CassandraUserTable.NAME, name.asString())).mapNotNull(row -> row.getSet(CassandraUserTable.DELEGATED_USERS, String.class)).flatMapIterable(set -> set).map(Username::of);
    }

    public void removeUser(Username name) throws UsersRepositoryException {
        boolean executed = (Boolean)this.executor.executeReturnApplied((Statement)this.removeUserStatement.bind(new Object[0]).setString(CassandraUserTable.NAME, name.asString())).block();
        if (!executed) {
            throw new UsersRepositoryException("unable to remove unknown user " + name.asString());
        }
    }

    public boolean contains(Username name) {
        return this.getUserByName(name).isPresent();
    }

    public Publisher<Boolean> containsReactive(Username name) {
        return this.getUserByNameReactive(name).hasElement();
    }

    public int countUsers() {
        return (Integer)this.executor.executeSingleRow((Statement)this.countUserStatement.bind(new Object[0])).map(row -> Ints.checkedCast((long)row.getLong(0))).block();
    }

    public Iterator<Username> list() {
        return this.listReactive().toIterable().iterator();
    }

    public Flux<Username> listReactive() {
        return this.executor.executeRows((Statement)this.listStatement.bind(new Object[0])).mapNotNull(row -> row.getString(CassandraUserTable.NAME)).map(Username::of);
    }

    public void addUser(Username username, String password) throws UsersRepositoryException {
        DefaultUser user = new DefaultUser(username, this.preferredAlgorithm, this.preferredAlgorithm);
        user.setPassword(password);
        boolean executed = (Boolean)this.executor.executeReturnApplied((Statement)((BoundStatement)((BoundStatement)((BoundStatement)this.insertStatement.bind(new Object[0]).setString(CassandraUserTable.NAME, user.getUserName().asString())).setString(CassandraUserTable.REALNAME, user.getUserName().asString())).setString(CassandraUserTable.PASSWORD, user.getHashedPassword())).setString(CassandraUserTable.ALGORITHM, user.getHashAlgorithm().asString())).block();
        if (!executed) {
            throw new AlreadyExistInUsersRepositoryException("User with username " + username + " already exist!");
        }
    }

    public boolean getDefaultVirtualHostingValue() {
        return true;
    }
}

