/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.pushsubscription;

import com.google.common.annotations.VisibleForTesting;
import eu.timepit.refined.api.Refined;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import org.apache.james.events.Event;
import org.apache.james.events.EventListener;
import org.apache.james.events.Group;
import org.apache.james.jmap.api.model.PushSubscription;
import org.apache.james.jmap.api.model.TypeName;
import org.apache.james.jmap.api.pushsubscription.PushSubscriptionRepository;
import org.apache.james.jmap.change.EmailDeliveryTypeName$;
import org.apache.james.jmap.change.StateChangeEvent;
import org.apache.james.jmap.core.StateChange;
import org.apache.james.jmap.json.PushSerializer;
import org.apache.james.jmap.pushsubscription.Aes128gcm$;
import org.apache.james.jmap.pushsubscription.High$;
import org.apache.james.jmap.pushsubscription.Low$;
import org.apache.james.jmap.pushsubscription.PushListener$;
import org.apache.james.jmap.pushsubscription.PushListenerGroup;
import org.apache.james.jmap.pushsubscription.PushRequest;
import org.apache.james.jmap.pushsubscription.PushTTL$;
import org.apache.james.jmap.pushsubscription.PushUrgency;
import org.apache.james.jmap.pushsubscription.WebPushClient;
import org.apache.james.user.api.DelegationStore;
import org.reactivestreams.Publisher;
import play.api.libs.json.Json$;
import reactor.core.scala.publisher.MapablePublisher;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SMono$;
import reactor.core.scala.publisher.package$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005]v!B\t\u0013\u0011\u0003ib!B\u0010\u0013\u0011\u0003\u0001\u0003\"B\u0014\u0002\t\u0003A\u0003\"B\u0015\u0002\t\u0003Qc\u0001B\u0010\u0013\u0001QC\u0001\u0002\u001b\u0003\u0003\u0002\u0003\u0006I!\u001b\u0005\ta\u0012\u0011\t\u0011)A\u0005c\"AA\u000f\u0002B\u0001B\u0003%Q\u000f\u0003\u0005|\t\t\u0005\t\u0015!\u0003}\u0011\u00199C\u0001\"\u0001\u0002\b!9\u0011Q\u0005\u0003\u0005B\u0005\u001d\u0002bBA\u0019\t\u0011\u0005\u00131\u0007\u0005\b\u0003#\"A\u0011IA*\u0011\u001d\ti\u0006\u0002C\u0005\u0003?Bq!!#\u0005\t\u0013\tY\tC\u0004\u0002\u0018\u0012!I!!'\t\u000f\u0005-F\u0001\"\u0003\u0002.\u0006a\u0001+^:i\u0019&\u001cH/\u001a8fe*\u00111\u0003F\u0001\u0011aV\u001c\bn];cg\u000e\u0014\u0018\u000e\u001d;j_:T!!\u0006\f\u0002\t)l\u0017\r\u001d\u0006\u0003/a\tQA[1nKNT!!\u0007\u000e\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0012aA8sO\u000e\u0001\u0001C\u0001\u0010\u0002\u001b\u0005\u0011\"\u0001\u0004)vg\"d\u0015n\u001d;f]\u0016\u00148CA\u0001\"!\t\u0011S%D\u0001$\u0015\u0005!\u0013!B:dC2\f\u0017B\u0001\u0014$\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!H\u0001\rKb$(/Y2u)>\u0004\u0018n\u0019\u000b\u0003W}\u0002\"\u0001\f\u001f\u000f\u00055RdB\u0001\u0018:\u001d\ty\u0003H\u0004\u00021o9\u0011\u0011G\u000e\b\u0003eUj\u0011a\r\u0006\u0003iq\ta\u0001\u0010:p_Rt\u0014\"A\u000e\n\u0005eQ\u0012BA\f\u0019\u0013\t)b#\u0003\u0002\u0014)%\u00111HE\u0001\n!V\u001c\b\u000eV8qS\u000eL!!\u0010 \u0003\u0013A+8\u000f\u001b+pa&\u001c'BA\u001e\u0013\u0011\u0015\u00015\u00011\u0001B\u0003-\u0019H/\u0019;f\u0007\"\fgnZ3\u0011\u0005\t+U\"A\"\u000b\u0005\u0011#\u0012\u0001B2pe\u0016L!AR\"\u0003\u0017M#\u0018\r^3DQ\u0006tw-\u001a\u0015\u0003\u0007!\u0003\"!\u0013*\u000e\u0003)S!a\u0013'\u0002\u0017\u0005tgn\u001c;bi&|gn\u001d\u0006\u0003\u001b:\u000baaY8n[>t'BA(Q\u0003\u00199wn\\4mK*\t\u0011+A\u0002d_6L!a\u0015&\u0003#YK7/\u001b2mK\u001a{'\u000fV3ti&twmE\u0002\u0005+v\u0003\"AV.\u000e\u0003]S!\u0001W-\u0002\t1\fgn\u001a\u0006\u00025\u0006!!.\u0019<b\u0013\tavK\u0001\u0004PE*,7\r\u001e\t\u0003=\u0016t!a\u00182\u000f\u0005=\u0002\u0017BA1\u0017\u0003\u0019)g/\u001a8ug&\u00111\rZ\u0001\u000e\u000bZ,g\u000e\u001e'jgR,g.\u001a:\u000b\u0005\u00054\u0012B\u00014h\u0005i\u0011V-Y2uSZ,wI]8va\u00163XM\u001c;MSN$XM\\3s\u0015\t\u0019G-\u0001\bqkND'+\u001a9pg&$xN]=\u0011\u0005)tW\"A6\u000b\u0005Ma'BA7\u0015\u0003\r\t\u0007/[\u0005\u0003_.\u0014!\u0004U;tQN+(m]2sSB$\u0018n\u001c8SKB|7/\u001b;pef\fQb^3c!V\u001c\bn\u00117jK:$\bC\u0001\u0010s\u0013\t\u0019(CA\u0007XK\n\u0004Vo\u001d5DY&,g\u000e^\u0001\u000faV\u001c\bnU3sS\u0006d\u0017N_3s!\t1\u00180D\u0001x\u0015\tAH#\u0001\u0003kg>t\u0017B\u0001>x\u00059\u0001Vo\u001d5TKJL\u0017\r\\5{KJ\fq\u0002Z3mK\u001e\fG/[8o'R|'/\u001a\t\u0004{\u0006\rQ\"\u0001@\u000b\u00055|(bAA\u0001-\u0005!Qo]3s\u0013\r\t)A \u0002\u0010\t\u0016dWmZ1uS>t7\u000b^8sKRQ\u0011\u0011BA\u0006\u0003\u001b\ty!!\u0005\u0011\u0005y!\u0001\"\u00025\n\u0001\u0004I\u0007\"\u00029\n\u0001\u0004\t\b\"\u0002;\n\u0001\u0004)\b\"B>\n\u0001\u0004a\bfA\u0005\u0002\u0016A!\u0011qCA\u0011\u001b\t\tIB\u0003\u0003\u0002\u001c\u0005u\u0011AB5oU\u0016\u001cGO\u0003\u0002\u0002 \u0005)!.\u0019<bq&!\u00111EA\r\u0005\u0019IeN[3di\u0006yq-\u001a;EK\u001a\fW\u000f\u001c;He>,\b\u000f\u0006\u0002\u0002*A!\u00111FA\u0017\u001b\u0005!\u0017bAA\u0018I\n)qI]8va\u0006i!/Z1di&4X-\u0012<f]R$B!!\u000e\u0002HA1\u0011qGA\u001f\u0003\u0003j!!!\u000f\u000b\u0007\u0005m\"$A\bsK\u0006\u001cG/\u001b<fgR\u0014X-Y7t\u0013\u0011\ty$!\u000f\u0003\u0013A+(\r\\5tQ\u0016\u0014\bc\u0001,\u0002D%\u0019\u0011QI,\u0003\tY{\u0017\u000e\u001a\u0005\b\u0003\u0013Z\u0001\u0019AA&\u0003\u0015)g/\u001a8u!\u0011\tY#!\u0014\n\u0007\u0005=CMA\u0003Fm\u0016tG/\u0001\u0006jg\"\u000bg\u000e\u001a7j]\u001e$B!!\u0016\u0002\\A\u0019!%a\u0016\n\u0007\u0005e3EA\u0004C_>dW-\u00198\t\u000f\u0005%C\u00021\u0001\u0002L\u0005\u00012/\u001a8e\u001d>$\u0018NZ5dCRLwN\u001c\u000b\u0007\u0003C\nI'!\u001f\u0011\r\u0005]\u0012QHA2!\r\u0011\u0013QM\u0005\u0004\u0003O\u001a#\u0001B+oSRDq!a\u001b\u000e\u0001\u0004\ti'\u0001\tqkND7+\u001e2tGJL\u0007\u000f^5p]B!\u0011qNA;\u001b\t\t\tHC\u0002\u0002t1\fQ!\\8eK2LA!a\u001e\u0002r\t\u0001\u0002+^:i'V\u00147o\u0019:jaRLwN\u001c\u0005\b\u0003wj\u0001\u0019AA?\u0003A\u0019H/\u0019;f\u0007\"\fgnZ3Fm\u0016tG\u000f\u0005\u0003\u0002\u0000\u0005\u0015UBAAA\u0015\r\t\u0019\tF\u0001\u0007G\"\fgnZ3\n\t\u0005\u001d\u0015\u0011\u0011\u0002\u0011'R\fG/Z\"iC:<W-\u0012<f]R\fQ\"Y:QkND'+Z9vKN$HCBAG\u0003'\u000b)\nE\u0002\u001f\u0003\u001fK1!!%\u0013\u0005-\u0001Vo\u001d5SKF,Xm\u001d;\t\u000b\u0001s\u0001\u0019A!\t\u000f\u0005-d\u00021\u0001\u0002n\u00059\u0011m\u001d\"zi\u0016\u001cHCBAN\u0003O\u000bI\u000bE\u0003#\u0003;\u000b\t+C\u0002\u0002 \u000e\u0012Q!\u0011:sCf\u00042AIAR\u0013\r\t)k\t\u0002\u0005\u0005f$X\rC\u0003A\u001f\u0001\u0007\u0011\tC\u0004\u0002l=\u0001\r!!\u001c\u0002\u000fU\u0014x-\u001a8dsR!\u0011qVA[!\rq\u0012\u0011W\u0005\u0004\u0003g\u0013\"a\u0003)vg\",&oZ3oGfDQ\u0001\u0011\tA\u0002\u0005\u0003")
public class PushListener
implements EventListener.ReactiveGroupEventListener {
    private final PushSubscriptionRepository pushRepository;
    private final WebPushClient webPushClient;
    private final PushSerializer pushSerializer;
    private final DelegationStore delegationStore;

    @VisibleForTesting
    public static String extractTopic(StateChange stateChange) {
        return PushListener$.MODULE$.extractTopic(stateChange);
    }

    public void event(Event x$1) throws Exception {
        super.event(x$1);
    }

    public Group getDefaultGroup() {
        return new PushListenerGroup();
    }

    public Publisher<Void> reactiveEvent(Event event) {
        Event event2 = event;
        if (event2 instanceof StateChangeEvent) {
            StateChangeEvent stateChangeEvent = (StateChangeEvent)event2;
            SFlux qual$1 = SMono$.MODULE$.just((Object)stateChangeEvent.username()).concatWith(this.delegationStore.authorizedUsers(stateChangeEvent.username()));
            Function1 & Serializable x$12 = (Function1 & Serializable)x$1 -> $this.pushRepository.list(x$1);
            int x$22 = qual$1.flatMap$default$2();
            int x$3 = qual$1.flatMap$default$3();
            boolean x$4 = qual$1.flatMap$default$4();
            SFlux qual$2 = qual$1.flatMap((Function1)x$12, x$22, x$3, x$4).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.validated()));
            Function1 & Serializable x$5 = (Function1 & Serializable)x$2 -> this.sendNotification((PushSubscription)x$2, stateChangeEvent);
            int x$6 = 16;
            int x$7 = qual$2.flatMap$default$3();
            boolean x$8 = qual$2.flatMap$default$4();
            return package$.MODULE$.publisherUnit2PublisherVoid((MapablePublisher)qual$2.flatMap((Function1)x$5, 16, x$7, x$8).then());
        }
        return SMono$.MODULE$.empty();
    }

    public boolean isHandling(Event event) {
        return event instanceof StateChangeEvent;
    }

    private Publisher<BoxedUnit> sendNotification(PushSubscription pushSubscription, StateChangeEvent stateChangeEvent) {
        return (Publisher)stateChangeEvent.asStateChange().filter((Set<TypeName>)pushSubscription.types().toSet()).fold((Function0 & Serializable)() -> SMono$.MODULE$.empty(), (Function1 & Serializable)stateChange -> SMono$.MODULE$.apply($this.webPushClient.push(pushSubscription.url(), this.asPushRequest((StateChange)stateChange, pushSubscription))));
    }

    private PushRequest asPushRequest(StateChange stateChange, PushSubscription pushSubscription) {
        Long x$1 = PushTTL$.MODULE$.MAX();
        Some x$2 = new Some((Object)this.urgency(stateChange));
        Some x$32 = new Some((Object)new Refined((Object)PushListener$.MODULE$.extractTopic(stateChange)));
        Option x$4 = pushSubscription.keys().map((Function1 & Serializable)x$3 -> Aes128gcm$.MODULE$);
        byte[] x$5 = this.asBytes(stateChange, pushSubscription);
        return new PushRequest(x$1, x$4, (Option)x$32, (Option)x$2, x$5);
    }

    private byte[] asBytes(StateChange stateChange, PushSubscription pushSubscription) {
        byte[] clearTextPayload = Json$.MODULE$.stringify(this.pushSerializer.serializeSSE(stateChange)).getBytes(StandardCharsets.UTF_8);
        return (byte[])pushSubscription.keys().map((Function1 & Serializable)keys -> keys.encrypt(clearTextPayload)).getOrElse((Function0 & Serializable)() -> clearTextPayload);
    }

    private PushUrgency urgency(StateChange stateChange) {
        if (((IterableOnceOps)stateChange.changes().values().flatMap((Function1 & Serializable)x$4 -> x$4.changes().keys())).toList().contains((Object)EmailDeliveryTypeName$.MODULE$)) {
            return High$.MODULE$;
        }
        return Low$.MODULE$;
    }

    @Inject
    public PushListener(PushSubscriptionRepository pushRepository, WebPushClient webPushClient, PushSerializer pushSerializer, DelegationStore delegationStore) {
        this.pushRepository = pushRepository;
        this.webPushClient = webPushClient;
        this.pushSerializer = pushSerializer;
        this.delegationStore = delegationStore;
    }
}

