/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.method;

import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.Collection;
import javax.inject.Inject;
import javax.mail.Flags;
import org.apache.james.jmap.core.SetError;
import org.apache.james.jmap.core.SetError$;
import org.apache.james.jmap.json.EmailSetSerializer;
import org.apache.james.jmap.mail.EmailSet$;
import org.apache.james.jmap.mail.EmailSetRequest;
import org.apache.james.jmap.mail.Keywords;
import org.apache.james.jmap.mail.KeywordsFactory$;
import org.apache.james.jmap.mail.MailboxIds;
import org.apache.james.jmap.mail.UnparsedMessageId;
import org.apache.james.jmap.mail.ValidatedEmailSetUpdate;
import org.apache.james.jmap.method.EmailSetUpdatePerformer$EmailUpdateSuccess$;
import org.apache.james.jmap.method.MessageNotFoundException;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.exception.OverQuotaException;
import org.apache.james.mailbox.model.ComposedMessageIdWithMetaData;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageRange;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsValue;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\u0011\u0005t!B/_\u0011\u0003Ig!B6_\u0011\u0003a\u0007\"B:\u0002\t\u0003!haB;\u0002!\u0003\r\nA\u001e\u0004\u0005o\u0006\u0001\u0005\u0010\u0003\u0006\u0002\u0016\u0011\u0011)\u001a!C\u0001\u0003/A!\"!\u000b\u0005\u0005#\u0005\u000b\u0011BA\r\u0011\u0019\u0019H\u0001\"\u0001\u0002,!I\u0011\u0011\u0007\u0003\u0002\u0002\u0013\u0005\u00111\u0007\u0005\n\u0003o!\u0011\u0013!C\u0001\u0003sA\u0011\"a\u0014\u0005\u0003\u0003%\t%!\u0015\t\u0013\u0005\rD!!A\u0005\u0002\u0005\u0015\u0004\"CA7\t\u0005\u0005I\u0011AA8\u0011%\tY\bBA\u0001\n\u0003\ni\bC\u0005\u0002\f\u0012\t\t\u0011\"\u0001\u0002\u000e\"I\u0011q\u0013\u0003\u0002\u0002\u0013\u0005\u0013\u0011\u0014\u0005\n\u0003;#\u0011\u0011!C!\u0003?C\u0011\"!)\u0005\u0003\u0003%\t%a)\t\u0013\u0005\u0015F!!A\u0005B\u0005\u001dv!CAV\u0003\u0005\u0005\t\u0012AAW\r!9\u0018!!A\t\u0002\u0005=\u0006BB:\u0015\t\u0003\t9\rC\u0005\u0002\"R\t\t\u0011\"\u0012\u0002$\"I\u0011\u0011\u001a\u000b\u0002\u0002\u0013\u0005\u00151\u001a\u0005\n\u0003\u001f$\u0012\u0011!CA\u0003#D\u0011\"!8\u0015\u0003\u0003%I!a8\u0007\r\u0005\u001d\u0018\u0001QAu\u0011)\tYO\u0007BK\u0002\u0013\u0005\u0011Q\u001e\u0005\u000b\u0003wT\"\u0011#Q\u0001\n\u0005=\bBCA\u007f5\tU\r\u0011\"\u0001\u0002\u0000\"Q!q\u0001\u000e\u0003\u0012\u0003\u0006IA!\u0001\t\rMTB\u0011\u0001B\u0005\u0011\u001d\u0011\tB\u0007C\u0001\u0005'A\u0011\"!\r\u001b\u0003\u0003%\tA!\t\t\u0013\u0005]\"$%A\u0005\u0002\t\u001d\u0002\"\u0003B\u00165E\u0005I\u0011\u0001B\u0017\u0011%\tyEGA\u0001\n\u0003\n\t\u0006C\u0005\u0002di\t\t\u0011\"\u0001\u0002f!I\u0011Q\u000e\u000e\u0002\u0002\u0013\u0005!\u0011\u0007\u0005\n\u0003wR\u0012\u0011!C!\u0003{B\u0011\"a#\u001b\u0003\u0003%\tA!\u000e\t\u0013\u0005]%$!A\u0005B\te\u0002\"CAO5\u0005\u0005I\u0011IAP\u0011%\t\tKGA\u0001\n\u0003\n\u0019\u000bC\u0005\u0002&j\t\t\u0011\"\u0011\u0003>\u001dI!\u0011I\u0001\u0002\u0002#\u0005!1\t\u0004\n\u0003O\f\u0011\u0011!E\u0001\u0005\u000bBaa\u001d\u0018\u0005\u0002\t5\u0003\"CAQ]\u0005\u0005IQIAR\u0011%\tIMLA\u0001\n\u0003\u0013y\u0005C\u0005\u0002P:\n\t\u0011\"!\u0003V!I\u0011Q\u001c\u0018\u0002\u0002\u0013%\u0011q\u001c\u0004\u0007\u0005C\n\u0001Ia\u0019\t\u0015\t\u0015DG!f\u0001\n\u0003\u00119\u0007\u0003\u0006\u0003pQ\u0012\t\u0012)A\u0005\u0005SBaa\u001d\u001b\u0005\u0002\tE\u0004b\u0002B<i\u0011\u0005!\u0011\u0010\u0005\b\u0005'#D\u0011\u0001BK\u0011%\t\t\u0004NA\u0001\n\u0003\u0011Y\nC\u0005\u00028Q\n\n\u0011\"\u0001\u0003 \"I\u0011q\n\u001b\u0002\u0002\u0013\u0005\u0013\u0011\u000b\u0005\n\u0003G\"\u0014\u0011!C\u0001\u0003KB\u0011\"!\u001c5\u0003\u0003%\tAa)\t\u0013\u0005mD'!A\u0005B\u0005u\u0004\"CAFi\u0005\u0005I\u0011\u0001BT\u0011%\t9\nNA\u0001\n\u0003\u0012Y\u000bC\u0005\u0002\u001eR\n\t\u0011\"\u0011\u0002 \"I\u0011\u0011\u0015\u001b\u0002\u0002\u0013\u0005\u00131\u0015\u0005\n\u0003K#\u0014\u0011!C!\u0005_;\u0011Ba-\u0002\u0003\u0003E\tA!.\u0007\u0013\t\u0005\u0014!!A\t\u0002\t]\u0006BB:G\t\u0003\u0011Y\fC\u0005\u0002\"\u001a\u000b\t\u0011\"\u0012\u0002$\"I\u0011\u0011\u001a$\u0002\u0002\u0013\u0005%Q\u0018\u0005\n\u0003\u001f4\u0015\u0011!CA\u0005\u0003D\u0011\"!8G\u0003\u0003%I!a8\u0007\u000b-t\u0006Aa2\t\u0015\t%GJ!A!\u0002\u0013\u0011Y\r\u0003\u0006\u0003X2\u0013\t\u0011)A\u0005\u00053D!B!9M\u0005\u0003\u0005\u000b\u0011\u0002Br\u0011)\u0011I\u000f\u0014B\u0001B\u0003%!1\u001e\u0005\u0007g2#\tA!?\t\u000f\r]A\n\"\u0001\u0004\u001a!91q\u0003'\u0005\n\rm\u0003bBB?\u0019\u0012%1q\u0010\u0005\b\u0007[cE\u0011BBX\u0011\u001d\u0019\u0019\r\u0014C\u0005\u0007\u000bDqaa@M\t\u0013!\t\u0001C\u0004\u0005\u000e1#I\u0001b\u0004\t\u000f\u0011\u0005B\n\"\u0003\u0005$!9A1\u0006'\u0005\n\u00115\u0002b\u0002C\u001f\u0019\u0012%Aq\b\u0005\b\t#bE\u0011\u0002C*\u0003])U.Y5m'\u0016$X\u000b\u001d3bi\u0016\u0004VM\u001d4pe6,'O\u0003\u0002`A\u00061Q.\u001a;i_\u0012T!!\u00192\u0002\t)l\u0017\r\u001d\u0006\u0003G\u0012\fQA[1nKNT!!\u001a4\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0017aA8sO\u000e\u0001\u0001C\u00016\u0002\u001b\u0005q&aF#nC&d7+\u001a;Va\u0012\fG/\u001a)fe\u001a|'/\\3s'\t\tQ\u000e\u0005\u0002oc6\tqNC\u0001q\u0003\u0015\u00198-\u00197b\u0013\t\u0011xN\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003%\u0014\u0011#R7bS2,\u0006\u000fZ1uKJ+7/\u001e7u'\t\u0019QN\u0001\nF[\u0006LG.\u00169eCR,7+^2dKN\u001c8#\u0002\u0003nsnt\bC\u0001>\u0004\u001b\u0005\t\u0001C\u00018}\u0013\tixNA\u0004Qe>$Wo\u0019;\u0011\u0007}\fyA\u0004\u0003\u0002\u0002\u0005-a\u0002BA\u0002\u0003\u0013i!!!\u0002\u000b\u0007\u0005\u001d\u0001.\u0001\u0004=e>|GOP\u0005\u0002a&\u0019\u0011QB8\u0002\u000fA\f7m[1hK&!\u0011\u0011CA\n\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\r\tia\\\u0001\n[\u0016\u001c8/Y4f\u0013\u0012,\"!!\u0007\u0011\t\u0005m\u0011QE\u0007\u0003\u0003;QA!a\b\u0002\"\u0005)Qn\u001c3fY*\u0019\u00111\u00052\u0002\u000f5\f\u0017\u000e\u001c2pq&!\u0011qEA\u000f\u0005%iUm]:bO\u0016LE-\u0001\u0006nKN\u001c\u0018mZ3JI\u0002\"B!!\f\u00020A\u0011!\u0010\u0002\u0005\b\u0003+9\u0001\u0019AA\r\u0003\u0011\u0019w\u000e]=\u0015\t\u00055\u0012Q\u0007\u0005\n\u0003+A\u0001\u0013!a\u0001\u00033\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002<)\"\u0011\u0011DA\u001fW\t\ty\u0004\u0005\u0003\u0002B\u0005-SBAA\"\u0015\u0011\t)%a\u0012\u0002\u0013Ut7\r[3dW\u0016$'bAA%_\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u00055\u00131\t\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002TA!\u0011QKA0\u001b\t\t9F\u0003\u0003\u0002Z\u0005m\u0013\u0001\u00027b]\u001eT!!!\u0018\u0002\t)\fg/Y\u0005\u0005\u0003C\n9F\u0001\u0004TiJLgnZ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003O\u00022A\\A5\u0013\r\tYg\u001c\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003c\n9\bE\u0002o\u0003gJ1!!\u001ep\u0005\r\te.\u001f\u0005\n\u0003sb\u0011\u0011!a\u0001\u0003O\n1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA@!\u0019\t\t)a\"\u0002r5\u0011\u00111\u0011\u0006\u0004\u0003\u000b{\u0017AC2pY2,7\r^5p]&!\u0011\u0011RAB\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005=\u0015Q\u0013\t\u0004]\u0006E\u0015bAAJ_\n9!i\\8mK\u0006t\u0007\"CA=\u001d\u0005\u0005\t\u0019AA9\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005M\u00131\u0014\u0005\n\u0003sz\u0011\u0011!a\u0001\u0003O\n\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003O\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003'\na!Z9vC2\u001cH\u0003BAH\u0003SC\u0011\"!\u001f\u0013\u0003\u0003\u0005\r!!\u001d\u0002%\u0015k\u0017-\u001b7Va\u0012\fG/Z*vG\u000e,7o\u001d\t\u0003uR\u0019R\u0001FAY\u0003{\u0003\u0002\"a-\u0002:\u0006e\u0011QF\u0007\u0003\u0003kS1!a.p\u0003\u001d\u0011XO\u001c;j[\u0016LA!a/\u00026\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u0019\u0011\t\u0005}\u0016QY\u0007\u0003\u0003\u0003TA!a1\u0002\\\u0005\u0011\u0011n\\\u0005\u0005\u0003#\t\t\r\u0006\u0002\u0002.\u0006)\u0011\r\u001d9msR!\u0011QFAg\u0011\u001d\t)b\u0006a\u0001\u00033\tq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002T\u0006e\u0007#\u00028\u0002V\u0006e\u0011bAAl_\n1q\n\u001d;j_:D\u0011\"a7\u0019\u0003\u0003\u0005\r!!\f\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0002bB!\u0011QKAr\u0013\u0011\t)/a\u0016\u0003\r=\u0013'.Z2u\u0005I)U.Y5m+B$\u0017\r^3GC&dWO]3\u0014\u000bii\u0017p\u001f@\u0002#Ut\u0007/\u0019:tK\u0012lUm]:bO\u0016LE-\u0006\u0002\u0002pB!\u0011\u0011_A|\u001b\t\t\u0019PC\u0002\u0002v\u0002\fA!\\1jY&!\u0011\u0011`Az\u0005E)f\u000e]1sg\u0016$W*Z:tC\u001e,\u0017\nZ\u0001\u0013k:\u0004\u0018M]:fI6+7o]1hK&#\u0007%A\u0001f+\t\u0011\t\u0001E\u0002\u0000\u0005\u0007IAA!\u0002\u0002\u0014\tIA\u000b\u001b:po\u0006\u0014G.Z\u0001\u0003K\u0002\"bAa\u0003\u0003\u000e\t=\u0001C\u0001>\u001b\u0011\u001d\tYo\ba\u0001\u0003_Dq!!@ \u0001\u0004\u0011\t!A\tbg6+7o]1hKN+G/\u0012:s_J,\"A!\u0006\u0011\t\t]!QD\u0007\u0003\u00053Q1Aa\u0007a\u0003\u0011\u0019wN]3\n\t\t}!\u0011\u0004\u0002\t'\u0016$XI\u001d:peR1!1\u0002B\u0012\u0005KA\u0011\"a;\"!\u0003\u0005\r!a<\t\u0013\u0005u\u0018\u0005%AA\u0002\t\u0005QC\u0001B\u0015U\u0011\ty/!\u0010\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!q\u0006\u0016\u0005\u0005\u0003\ti\u0004\u0006\u0003\u0002r\tM\u0002\"CA=M\u0005\u0005\t\u0019AA4)\u0011\tyIa\u000e\t\u0013\u0005e\u0004&!AA\u0002\u0005ED\u0003BA*\u0005wA\u0011\"!\u001f*\u0003\u0003\u0005\r!a\u001a\u0015\t\u0005=%q\b\u0005\n\u0003sb\u0013\u0011!a\u0001\u0003c\n!#R7bS2,\u0006\u000fZ1uK\u001a\u000b\u0017\u000e\\;sKB\u0011!PL\n\u0006]\t\u001d\u0013Q\u0018\t\u000b\u0003g\u0013I%a<\u0003\u0002\t-\u0011\u0002\u0002B&\u0003k\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83)\t\u0011\u0019\u0005\u0006\u0004\u0003\f\tE#1\u000b\u0005\b\u0003W\f\u0004\u0019AAx\u0011\u001d\ti0\ra\u0001\u0005\u0003!BAa\u0016\u0003`A)a.!6\u0003ZA9aNa\u0017\u0002p\n\u0005\u0011b\u0001B/_\n1A+\u001e9mKJB\u0011\"a73\u0003\u0003\u0005\rAa\u0003\u0003%\u0015k\u0017-\u001b7Va\u0012\fG/\u001a*fgVdGo]\n\u0005i5\\h0A\u0004sKN,H\u000e^:\u0016\u0005\t%\u0004\u0003B@\u0003leLAA!\u001c\u0002\u0014\t\u00191+Z9\u0002\u0011I,7/\u001e7ug\u0002\"BAa\u001d\u0003vA\u0011!\u0010\u000e\u0005\b\u0005K:\u0004\u0019\u0001B5\u0003\u001d)\b\u000fZ1uK\u0012,\"Aa\u001f\u0011\u000b9\f)N! \u0011\u0011\t}$qQA\r\u0005\u001bsAA!!\u0003\u0004B\u0019\u00111A8\n\u0007\t\u0015u.\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0005\u0013\u0013YIA\u0002NCBT1A!\"p!\rq'qR\u0005\u0004\u0005#{'\u0001B+oSR\f!B\\8u+B$\u0017\r^3e+\t\u00119\nE\u0003o\u0003+\u0014I\n\u0005\u0005\u0003\u0000\t\u001d\u0015q\u001eB\u000b)\u0011\u0011\u0019H!(\t\u0013\t\u0015$\b%AA\u0002\t%TC\u0001BQU\u0011\u0011I'!\u0010\u0015\t\u0005E$Q\u0015\u0005\n\u0003sr\u0014\u0011!a\u0001\u0003O\"B!a$\u0003*\"I\u0011\u0011\u0010!\u0002\u0002\u0003\u0007\u0011\u0011\u000f\u000b\u0005\u0003'\u0012i\u000bC\u0005\u0002z\u0005\u000b\t\u00111\u0001\u0002hQ!\u0011q\u0012BY\u0011%\tI\bRA\u0001\u0002\u0004\t\t(\u0001\nF[\u0006LG.\u00169eCR,'+Z:vYR\u001c\bC\u0001>G'\u00151%\u0011XA_!!\t\u0019,!/\u0003j\tMDC\u0001B[)\u0011\u0011\u0019Ha0\t\u000f\t\u0015\u0014\n1\u0001\u0003jQ!!1\u0019Bc!\u0015q\u0017Q\u001bB5\u0011%\tYNSA\u0001\u0002\u0004\u0011\u0019h\u0005\u0002M[\u0006Q1/\u001a:jC2L'0\u001a:\u0011\t\t5'1[\u0007\u0003\u0005\u001fT1A!5a\u0003\u0011Q7o\u001c8\n\t\tU'q\u001a\u0002\u0013\u000b6\f\u0017\u000e\\*fiN+'/[1mSj,'/\u0001\tnKN\u001c\u0018mZ3JI6\u000bg.Y4feB!!1\u001cBo\u001b\t\t\t#\u0003\u0003\u0003`\u0006\u0005\"\u0001E'fgN\fw-Z%e\u001b\u0006t\u0017mZ3s\u00039i\u0017-\u001b7c_bl\u0015M\\1hKJ\u0004BAa7\u0003f&!!q]A\u0011\u00059i\u0015-\u001b7c_bl\u0015M\\1hKJ\f\u0001#\\3tg\u0006<W-\u00133GC\u000e$xN]=\u0011\t\t5(1\u001f\b\u0005\u00037\u0011y/\u0003\u0003\u0003r\u0006u\u0011!C'fgN\fw-Z%e\u0013\u0011\u0011)Pa>\u0003\u000f\u0019\u000b7\r^8ss*!!\u0011_A\u000f))\u0011YP!@\u0003\u0000\u000e\u000511\u0001\t\u0003U2CqA!3R\u0001\u0004\u0011Y\rC\u0004\u0003XF\u0003\rA!7\t\u000f\t\u0005\u0018\u000b1\u0001\u0003d\"9!\u0011^)A\u0002\t-\bfA)\u0004\bA!1\u0011BB\n\u001b\t\u0019YA\u0003\u0003\u0004\u000e\r=\u0011AB5oU\u0016\u001cGO\u0003\u0002\u0004\u0012\u0005)!.\u0019<bq&!1QCB\u0006\u0005\u0019IeN[3di\u00061Q\u000f\u001d3bi\u0016$baa\u0007\u0004H\rE\u0003CBB\u000f\u0007W\u0019y#\u0004\u0002\u0004 )!1\u0011EB\u0012\u0003%\u0001XO\u00197jg\",'OC\u0002q\u0007KQAAa\u0007\u0004()\u00111\u0011F\u0001\be\u0016\f7\r^8s\u0013\u0011\u0019ica\b\u0003\u000bMkuN\\8\u0011\u0007\rEBGD\u0002\u00044\u0001qAa!\u000e\u0004F9!1qGB\"\u001d\u0011\u0019Id!\u0011\u000f\t\rm2q\b\b\u0005\u0003\u0007\u0019i$C\u0001h\u0013\t)g-\u0003\u0002dI&\u0011\u0011MY\u0005\u0003?\u0002Dqa!\u0013S\u0001\u0004\u0019Y%A\bf[\u0006LGnU3u%\u0016\fX/Z:u!\u0011\t\tp!\u0014\n\t\r=\u00131\u001f\u0002\u0010\u000b6\f\u0017\u000e\\*fiJ+\u0017/^3ti\"911\u000b*A\u0002\rU\u0013AD7bS2\u0014w\u000e_*fgNLwN\u001c\t\u0005\u00057\u001c9&\u0003\u0003\u0004Z\u0005\u0005\"AD'bS2\u0014w\u000e_*fgNLwN\u001c\u000b\u0007\u00077\u0019if!\u001f\t\u000f\r}3\u000b1\u0001\u0004b\u00059Q\u000f\u001d3bi\u0016\u001c\b\u0003\u0003B@\u0005\u000f\u000byoa\u0019\u0011\t\r\u00154QO\u0007\u0003\u0007ORAA!5\u0004j)!11NB7\u0003\u0011a\u0017NY:\u000b\t\r=4\u0011O\u0001\u0004CBL'BAB:\u0003\u0011\u0001H.Y=\n\t\r]4q\r\u0002\t\u0015N|%M[3di\"911P*A\u0002\rU\u0013aB:fgNLwN\\\u0001\tI>,\u0006\u000fZ1uKRA1\u0011QBD\u00073\u001bY\u000b\u0005\u0004\u0004\u001e\r-21\u0011\t\u0006\u007f\n-4Q\u0011\t\u0004\u0007c\u0019\u0001bBBE)\u0002\u000711R\u0001\rm\u0006d\u0017\u000eZ+qI\u0006$Xm\u001d\t\u0006\u007f\u000e55\u0011S\u0005\u0005\u0007\u001f\u000b\u0019B\u0001\u0003MSN$\bc\u00028\u0003\\\u0005e11\u0013\t\u0005\u0003c\u001c)*\u0003\u0003\u0004\u0018\u0006M(a\u0006,bY&$\u0017\r^3e\u000b6\f\u0017\u000e\\*fiV\u0003H-\u0019;f\u0011\u001d\u0019Y\n\u0016a\u0001\u0007;\u000b\u0001\"\\3uC\u0012\u000bG/\u0019\t\t\u0005\u007f\u00129)!\u0007\u0004 B)qp!)\u0004&&!11UA\n\u0005-!&/\u0019<feN\f'\r\\3\u0011\t\u0005m1qU\u0005\u0005\u0007S\u000biBA\u000fD_6\u0004xn]3e\u001b\u0016\u001c8/Y4f\u0013\u0012<\u0016\u000e\u001e5NKR\fG)\u0019;b\u0011\u001d\u0019Y\b\u0016a\u0001\u0007+\n\u0001\"Y:SC:<Wm\u001d\u000b\u0005\u0007c\u001b\t\r\u0005\u0004\u00044\u000ee61X\u0007\u0003\u0007kSAaa.\u0002\u0004\u0006I\u0011.\\7vi\u0006\u0014G.Z\u0005\u0005\u0007\u001f\u001b)\f\u0005\u0003\u0002\u001c\ru\u0016\u0002BB`\u0003;\u0011A\"T3tg\u0006<WMU1oO\u0016Dqaa'V\u0001\u0004\u0019i*\u0001\nva\u0012\fG/\u001a$mC\u001e\u001c()\u001f*b]\u001e,GCDBA\u0007\u000f\u001c\tna8\u0004f\u000e\u001d8Q \u0005\b\u0007\u00134\u0006\u0019ABf\u0003%i\u0017-\u001b7c_bLE\r\u0005\u0003\u0002\u001c\r5\u0017\u0002BBh\u0003;\u0011\u0011\"T1jY\n|\u00070\u00133\t\u000f\rMg\u000b1\u0001\u0004V\u0006)a\r\\1hgB!1q[Bn\u001b\t\u0019IN\u0003\u0003\u0002v\u000e=\u0011\u0002BBo\u00073\u0014QA\u00127bONDqa!9W\u0001\u0004\u0019\u0019/\u0001\u0004sC:<Wm\u001d\t\u0006\u007f\u000e551\u0018\u0005\b\u000773\u0006\u0019ABO\u0011\u001d\u0019IO\u0016a\u0001\u0007W\f!\"\u001e9eCR,Wj\u001c3f!\u0011\u0019ioa>\u000f\t\r=81\u001f\b\u0005\u0007o\u0019\t0C\u0002\u0002$\tLAa!>\u0002\"\u0005qQ*Z:tC\u001e,W*\u00198bO\u0016\u0014\u0018\u0002BB}\u0007w\u0014qB\u00127bON,\u0006\u000fZ1uK6{G-\u001a\u0006\u0005\u0007k\f\t\u0003C\u0004\u0004|Y\u0003\ra!\u0016\u0002\u00175|g/\u001a\"z%\u0006tw-\u001a\u000b\r\u0007\u0003#\u0019\u0001\"\u0002\u0005\b\u0011%A1\u0002\u0005\b\u0007\u0013<\u0006\u0019ABf\u0011\u001d\u00199b\u0016a\u0001\u0007'Cqa!9X\u0001\u0004\u0019\u0019\u000fC\u0004\u0004\u001c^\u0003\ra!(\t\u000f\rmt\u000b1\u0001\u0004V\u0005iQ\u000f\u001d3bi\u0016\u0014\u0015PU1oO\u0016$\u0002b!!\u0005\u0012\u0011MAQ\u0003\u0005\b\u0007CD\u0006\u0019ABr\u0011\u001d\u0019Y\n\u0017a\u0001\u0007;Cq\u0001b\u0006Y\u0001\u0004!I\"A\u0005pa\u0016\u0014\u0018\r^5p]B9a\u000eb\u0007\u0004<\u0012}\u0011b\u0001C\u000f_\nIa)\u001e8di&|g.\r\t\u0007\u0007;\u0019YC!$\u0002#U\u0004H-\u0019;f\u000b\u0006\u001c\u0007.T3tg\u0006<W\r\u0006\u0005\u0004\u0002\u0012\u0015Bq\u0005C\u0015\u0011\u001d\u0019I)\u0017a\u0001\u0007\u0017Cqaa'Z\u0001\u0004\u0019i\nC\u0004\u0004|e\u0003\ra!\u0016\u0002'U\u0004H-\u0019;f'&tw\r\\3NKN\u001c\u0018mZ3\u0015\u0015\u0011=B\u0011\u0007C\u001a\tk!Y\u0004\u0005\u0004\u0004\u001e\r-2Q\u0011\u0005\b\u0003+Q\u0006\u0019AA\r\u0011\u001d\u00199B\u0017a\u0001\u0007'Cq\u0001b\u000e[\u0001\u0004!I$\u0001\bti>\u0014X\rZ'fi\u0006$\u0015\r^1\u0011\u000b}\u001cii!*\t\u000f\rm$\f1\u0001\u0004V\u0005\u0001R\u000f\u001d3bi\u0016l\u0015-\u001b7c_bLEm\u001d\u000b\u000b\t_!\t\u0005b\u0011\u0005F\u0011=\u0003bBA\u000b7\u0002\u0007\u0011\u0011\u0004\u0005\b\u0007/Y\u0006\u0019ABJ\u0011\u001d!9e\u0017a\u0001\t\u0013\n!\"\\1jY\n|\u00070\u00133t!\u0011\t\t\u0010b\u0013\n\t\u00115\u00131\u001f\u0002\u000b\u001b\u0006LGNY8y\u0013\u0012\u001c\bbBB>7\u0002\u00071QK\u0001\fkB$\u0017\r^3GY\u0006<7\u000f\u0006\u0007\u00050\u0011UCq\u000bC-\t7\"y\u0006C\u0004\u0002\u0016q\u0003\r!!\u0007\t\u000f\r]A\f1\u0001\u0004\u0014\"9Aq\t/A\u0002\u0011%\u0003b\u0002C/9\u0002\u00071Q[\u0001\u000e_JLw-\u001b8bY\u001ac\u0017mZ:\t\u000f\rmD\f1\u0001\u0004V\u0001")
public class EmailSetUpdatePerformer {
    private final EmailSetSerializer serializer;
    private final MessageIdManager messageIdManager;
    private final MailboxManager mailboxManager;
    private final MessageId.Factory messageIdFactory;

    public SMono<EmailUpdateResults> update(EmailSetRequest emailSetRequest, MailboxSession mailboxSession) {
        return (SMono)emailSetRequest.update().filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.nonEmpty())).map((Function1 & Serializable)x$4 -> this.update((Map<UnparsedMessageId, JsObject>)x$4, mailboxSession)).getOrElse((Function0 & Serializable)() -> SMono$.MODULE$.just((Object)new EmailUpdateResults((scala.collection.immutable.Seq<EmailUpdateResult>)((scala.collection.immutable.Seq)Nil$.MODULE$))));
    }

    private SMono<EmailUpdateResults> update(Map<UnparsedMessageId, JsObject> updates2, MailboxSession session) {
        List validatedUpdates = ((IterableOnceOps)updates2.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                UnparsedMessageId unparsedMessageId = (UnparsedMessageId)tuple2._1();
                JsObject json = (JsObject)tuple2._2();
                return EmailSet$.MODULE$.parse($this.messageIdFactory, unparsedMessageId).toEither().left().map((Function1 & Serializable)e -> new EmailUpdateFailure(unparsedMessageId, (Throwable)e)).flatMap((Function1 & Serializable)id -> (Either)$this.serializer.deserializeEmailSetUpdate((JsValue)json).asEither().left().map((Function1 & Serializable)e -> new IllegalArgumentException(e.toString())).flatMap((Function1 & Serializable)x$5 -> x$5.validate()).fold((Function1 & Serializable)e -> package$.MODULE$.Left().apply((Object)new EmailUpdateFailure(unparsedMessageId, (Throwable)e)), (Function1 & Serializable)emailSetUpdate -> package$.MODULE$.Right().apply((Object)new Tuple2(id, emailSetUpdate))));
            }
            throw new MatchError((Object)tuple2);
        })).toList();
        List failures = validatedUpdates.flatMap((Function1 & Serializable)x0$2 -> {
            Either either = x0$2;
            if (either instanceof Left) {
                Left left = (Left)either;
                EmailUpdateFailure e = (EmailUpdateFailure)left.value();
                return new Some((Object)e);
            }
            return None$.MODULE$;
        });
        List validUpdates = validatedUpdates.flatMap((Function1 & Serializable)x0$3 -> {
            Either either = x0$3;
            if (either instanceof Right) {
                Right right = (Right)either;
                Tuple2 pair = (Tuple2)right.value();
                return new Some((Object)pair);
            }
            return None$.MODULE$;
        });
        return SFlux$.MODULE$.fromPublisher(this.messageIdManager.messagesMetadata(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)validUpdates.map((Function1 & Serializable)x$6 -> (MessageId)x$6._1())).asJavaCollection(), session)).collectMultimap((Function1 & Serializable)metaData -> metaData.getComposedMessageId().getMessageId()).flatMap((Function1 & Serializable)x$7 -> this.doUpdate((List<Tuple2<MessageId, ValidatedEmailSetUpdate>>)validUpdates, (Map<MessageId, Iterable<ComposedMessageIdWithMetaData>>)x$7, session)).map((Function1 & Serializable)updates -> new EmailUpdateResults((scala.collection.immutable.Seq<EmailUpdateResult>)((scala.collection.immutable.Seq)updates.$plus$plus((IterableOnce)failures))));
    }

    private SMono<scala.collection.immutable.Seq<EmailUpdateResult>> doUpdate(List<Tuple2<MessageId, ValidatedEmailSetUpdate>> validUpdates, Map<MessageId, Iterable<ComposedMessageIdWithMetaData>> metaData, MailboxSession session) {
        boolean singleMailbox;
        boolean sameUpdate = ((SeqOps)validUpdates.map((Function1 & Serializable)x$8 -> (ValidatedEmailSetUpdate)x$8._2()).distinctBy((Function1 & Serializable)x$9 -> x$9.update())).size() == 1;
        boolean bl = singleMailbox = ((IterableOnceOps)((IterableOps)metaData.values().flatten(Predef$.MODULE$.$conforms())).map((Function1 & Serializable)x$10 -> x$10.getComposedMessageId().getMailboxId())).toSet().size() == 1;
        if (sameUpdate && singleMailbox && validUpdates.size() > 3) {
            ValidatedEmailSetUpdate update = (ValidatedEmailSetUpdate)validUpdates.map((Function1 & Serializable)x$11 -> (ValidatedEmailSetUpdate)x$11._2()).headOption().get();
            List<MessageRange> ranges = this.asRanges(metaData);
            MailboxId mailboxId = (MailboxId)((IterableOps)((IterableOps)metaData.values().flatten(Predef$.MODULE$.$conforms())).map((Function1 & Serializable)x$12 -> x$12.getComposedMessageId().getMailboxId())).headOption().get();
            if (update.update().isOnlyFlagAddition()) {
                return this.updateFlagsByRange(mailboxId, ((Keywords)update.update().keywordsToAdd().get()).asFlags(), ranges, metaData, MessageManager.FlagsUpdateMode.ADD, session);
            }
            if (update.update().isOnlyFlagRemoval()) {
                return this.updateFlagsByRange(mailboxId, ((Keywords)update.update().keywordsToRemove().get()).asFlags(), ranges, metaData, MessageManager.FlagsUpdateMode.REMOVE, session);
            }
            if (update.update().isOnlyMove()) {
                return this.moveByRange(mailboxId, update, ranges, metaData, session);
            }
            return this.updateEachMessage(validUpdates, metaData, session);
        }
        return this.updateEachMessage(validUpdates, metaData, session);
    }

    private List<MessageRange> asRanges(Map<MessageId, Iterable<ComposedMessageIdWithMetaData>> metaData) {
        return CollectionConverters$.MODULE$.ListHasAsScala(MessageRange.toRanges((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)((IterableOps)metaData.values().flatten(Predef$.MODULE$.$conforms())).map((Function1 & Serializable)x$13 -> x$13.getComposedMessageId().getUid())).toList().distinct()).asJava())).asScala().toList();
    }

    private SMono<scala.collection.immutable.Seq<EmailUpdateResult>> updateFlagsByRange(MailboxId mailboxId, Flags flags, List<MessageRange> ranges, Map<MessageId, Iterable<ComposedMessageIdWithMetaData>> metaData, MessageManager.FlagsUpdateMode updateMode, MailboxSession session) {
        SMono mailboxMono = SMono$.MODULE$.apply(this.mailboxManager.getMailboxReactive(mailboxId, session));
        return mailboxMono.flatMap((Function1 & Serializable)mailbox -> this.updateByRange(ranges, metaData, (Function1<MessageRange, SMono<BoxedUnit>>)(Function1 & Serializable)range -> SMono$.MODULE$.apply(mailbox.setFlagsReactive(flags, updateMode, range, session)).then()));
    }

    private SMono<scala.collection.immutable.Seq<EmailUpdateResult>> moveByRange(MailboxId mailboxId, ValidatedEmailSetUpdate update, List<MessageRange> ranges, Map<MessageId, Iterable<ComposedMessageIdWithMetaData>> metaData, MailboxSession session) {
        MailboxId targetId = (MailboxId)((MailboxIds)update.update().mailboxIds().get()).value().headOption().get();
        return this.updateByRange(ranges, metaData, (Function1<MessageRange, SMono<BoxedUnit>>)(Function1 & Serializable)range -> SMono$.MODULE$.apply($this.mailboxManager.moveMessagesReactive(range, mailboxId, targetId, session)).then());
    }

    private SMono<scala.collection.immutable.Seq<EmailUpdateResult>> updateByRange(List<MessageRange> ranges, Map<MessageId, Iterable<ComposedMessageIdWithMetaData>> metaData, Function1<MessageRange, SMono<BoxedUnit>> operation) {
        SFlux qual$1 = SFlux$.MODULE$.fromIterable(ranges);
        Function1 & Serializable x$1 = (Function1 & Serializable)range -> {
            scala.collection.immutable.Seq messageIds = ((MapOps)metaData.filter((Function1 & Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)EmailSetUpdatePerformer.$anonfun$updateByRange$2(range, entry)))).keys().toSeq();
            return ((SMono)operation.apply(range)).then(SMono$.MODULE$.just(messageIds.map((Function1)EmailSetUpdatePerformer$EmailUpdateSuccess$.MODULE$))).onErrorResume((Function1 & Serializable)e -> SMono$.MODULE$.just(messageIds.map((Function1 & Serializable)id -> new EmailUpdateFailure(EmailSet$.MODULE$.asUnparsed((MessageId)id), (Throwable)e))));
        };
        int x$2 = qual$1.concatMap$default$2();
        return qual$1.concatMap((Function1)x$1, x$2).reduce((Object)Nil$.MODULE$, (Function2 & Serializable)(x$14, x$15) -> (scala.collection.immutable.Seq)x$14.$plus$plus((IterableOnce)x$15));
    }

    private SMono<scala.collection.immutable.Seq<EmailUpdateResult>> updateEachMessage(List<Tuple2<MessageId, ValidatedEmailSetUpdate>> validUpdates, Map<MessageId, Iterable<ComposedMessageIdWithMetaData>> metaData, MailboxSession session) {
        SFlux qual$1 = SFlux$.MODULE$.fromIterable(validUpdates);
        Function1 & Serializable x$1 = (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                MessageId messageId = (MessageId)tuple2._1();
                ValidatedEmailSetUpdate updatePatch = (ValidatedEmailSetUpdate)tuple2._2();
                return this.updateSingleMessage(messageId, updatePatch, (List<ComposedMessageIdWithMetaData>)((List)metaData.get((Object)messageId).toList().flatten(Predef$.MODULE$.$conforms())), session);
            }
            throw new MatchError((Object)tuple2);
        };
        int x$2 = qual$1.concatMap$default$2();
        return qual$1.concatMap((Function1)x$1, x$2).collectSeq();
    }

    private SMono<EmailUpdateResult> updateSingleMessage(MessageId messageId, ValidatedEmailSetUpdate update, List<ComposedMessageIdWithMetaData> storedMetaData, MailboxSession session) {
        MailboxIds mailboxIds = new MailboxIds((List<MailboxId>)storedMetaData.map((Function1 & Serializable)metaData -> metaData.getComposedMessageId().getMailboxId()));
        Flags originFlags = (Flags)storedMetaData.foldLeft((Object)new Flags(), (Function2 & Serializable)(flags, m) -> {
            flags.add(m.getFlags());
            return flags;
        });
        if (mailboxIds.value().isEmpty()) {
            return SMono$.MODULE$.just((Object)new EmailUpdateFailure(EmailSet$.MODULE$.asUnparsed(messageId), new MessageNotFoundException(messageId)));
        }
        return this.updateFlags(messageId, update, mailboxIds, originFlags, session).flatMap((Function1 & Serializable)x0$1 -> {
            EmailUpdateResult emailUpdateResult = x0$1;
            if (emailUpdateResult instanceof EmailUpdateFailure) {
                EmailUpdateFailure emailUpdateFailure = (EmailUpdateFailure)emailUpdateResult;
                return SMono$.MODULE$.just((Object)emailUpdateFailure);
            }
            if (emailUpdateResult instanceof EmailUpdateSuccess) {
                return this.updateMailboxIds(messageId, update, mailboxIds, session);
            }
            throw new MatchError((Object)emailUpdateResult);
        }).onErrorResume((Function1 & Serializable)e -> SMono$.MODULE$.just((Object)new EmailUpdateFailure(EmailSet$.MODULE$.asUnparsed(messageId), (Throwable)e))).switchIfEmpty(SMono$.MODULE$.just((Object)new EmailUpdateSuccess(messageId)));
    }

    private SMono<EmailUpdateResult> updateMailboxIds(MessageId messageId, ValidatedEmailSetUpdate update, MailboxIds mailboxIds, MailboxSession session) {
        MailboxIds targetIds = (MailboxIds)update.mailboxIdsTransformation().apply((Object)mailboxIds);
        if (targetIds.equals(mailboxIds)) {
            return SMono$.MODULE$.just((Object)new EmailUpdateSuccess(messageId));
        }
        return SMono$.MODULE$.apply(this.messageIdManager.setInMailboxesReactive(messageId, (Collection)CollectionConverters$.MODULE$.SeqHasAsJava(targetIds.value()).asJava(), session)).then(SMono$.MODULE$.just((Object)new EmailUpdateSuccess(messageId))).onErrorResume((Function1 & Serializable)e -> SMono$.MODULE$.just((Object)new EmailUpdateFailure(EmailSet$.MODULE$.asUnparsed(messageId), (Throwable)e))).switchIfEmpty(SMono$.MODULE$.just((Object)new EmailUpdateSuccess(messageId)));
    }

    private SMono<EmailUpdateResult> updateFlags(MessageId messageId, ValidatedEmailSetUpdate update, MailboxIds mailboxIds, Flags originalFlags, MailboxSession session) {
        Flags newFlags = ((Keywords)update.keywordsTransformation().apply(KeywordsFactory$.MODULE$.LENIENT_KEYWORDS_FACTORY().fromFlags(originalFlags).get())).asFlagsWithRecentAndDeletedFrom(originalFlags);
        if (newFlags.equals((Object)originalFlags)) {
            return SMono$.MODULE$.just((Object)new EmailUpdateSuccess(messageId));
        }
        return SMono$.MODULE$.apply(this.messageIdManager.setFlagsReactive(newFlags, MessageManager.FlagsUpdateMode.REPLACE, messageId, (java.util.List)ImmutableList.copyOf((Collection)CollectionConverters$.MODULE$.IterableHasAsJava(mailboxIds.value()).asJavaCollection()), session)).then(SMono$.MODULE$.just((Object)new EmailUpdateSuccess(messageId)));
    }

    public static final /* synthetic */ boolean $anonfun$updateByRange$2(MessageRange range$1, Tuple2 entry) {
        return ((IterableOnceOps)entry._2()).exists((Function1 & Serializable)composedId -> BoxesRunTime.boxToBoolean((boolean)range$1.includes(composedId.getComposedMessageId().getUid())));
    }

    @Inject
    public EmailSetUpdatePerformer(EmailSetSerializer serializer, MessageIdManager messageIdManager, MailboxManager mailboxManager, MessageId.Factory messageIdFactory) {
        this.serializer = serializer;
        this.messageIdManager = messageIdManager;
        this.mailboxManager = mailboxManager;
        this.messageIdFactory = messageIdFactory;
    }

    public static class EmailUpdateFailure
    implements EmailUpdateResult,
    Product,
    Serializable {
        private final UnparsedMessageId unparsedMessageId;
        private final Throwable e;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public UnparsedMessageId unparsedMessageId() {
            return this.unparsedMessageId;
        }

        public Throwable e() {
            return this.e;
        }

        public SetError asMessageSetError() {
            Throwable throwable = this.e();
            if (throwable instanceof IllegalArgumentException) {
                IllegalArgumentException illegalArgumentException = (IllegalArgumentException)throwable;
                return SetError$.MODULE$.invalidPatch(new StringBuilder(27).append("Message update is invalid: ").append(illegalArgumentException.getMessage()).toString());
            }
            if (throwable instanceof MailboxNotFoundException) {
                return SetError$.MODULE$.notFound("Mailbox not found");
            }
            if (throwable instanceof MessageNotFoundException) {
                MessageNotFoundException messageNotFoundException = (MessageNotFoundException)throwable;
                return SetError$.MODULE$.notFound(new StringBuilder(36).append("Cannot find message with messageId: ").append(messageNotFoundException.messageId().serialize()).toString());
            }
            if (throwable instanceof OverQuotaException) {
                OverQuotaException overQuotaException = (OverQuotaException)throwable;
                return SetError$.MODULE$.overQuota(overQuotaException.getMessage());
            }
            return SetError$.MODULE$.serverFail(this.e().getMessage());
        }

        public EmailUpdateFailure copy(UnparsedMessageId unparsedMessageId, Throwable e) {
            return new EmailUpdateFailure(unparsedMessageId, e);
        }

        public UnparsedMessageId copy$default$1() {
            return this.unparsedMessageId();
        }

        public Throwable copy$default$2() {
            return this.e();
        }

        public String productPrefix() {
            return "EmailUpdateFailure";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.unparsedMessageId();
                }
                case 1: {
                    return this.e();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof EmailUpdateFailure;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "unparsedMessageId";
                }
                case 1: {
                    return "e";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof EmailUpdateFailure)) return false;
            boolean bl = true;
            if (!bl) return false;
            EmailUpdateFailure emailUpdateFailure = (EmailUpdateFailure)x$1;
            UnparsedMessageId unparsedMessageId = this.unparsedMessageId();
            UnparsedMessageId unparsedMessageId2 = emailUpdateFailure.unparsedMessageId();
            if (unparsedMessageId == null) {
                if (unparsedMessageId2 != null) {
                    return false;
                }
            } else if (!((Object)unparsedMessageId).equals(unparsedMessageId2)) return false;
            Throwable throwable = this.e();
            Throwable throwable2 = emailUpdateFailure.e();
            if (throwable == null) {
                if (throwable2 != null) {
                    return false;
                }
            } else if (!throwable.equals(throwable2)) return false;
            if (!emailUpdateFailure.canEqual(this)) return false;
            return true;
        }

        public EmailUpdateFailure(UnparsedMessageId unparsedMessageId, Throwable e) {
            this.unparsedMessageId = unparsedMessageId;
            this.e = e;
            Product.$init$((Product)this);
        }
    }

    public static interface EmailUpdateResult {
    }

    public static class EmailUpdateResults
    implements Product,
    Serializable {
        private final scala.collection.immutable.Seq<EmailUpdateResult> results;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public scala.collection.immutable.Seq<EmailUpdateResult> results() {
            return this.results;
        }

        public Option<Map<MessageId, BoxedUnit>> updated() {
            return Option$.MODULE$.apply((Object)((IterableOnceOps)this.results().flatMap((Function1 & Serializable)x0$1 -> {
                EmailUpdateResult emailUpdateResult = x0$1;
                if (emailUpdateResult instanceof EmailUpdateSuccess) {
                    EmailUpdateSuccess emailUpdateSuccess = (EmailUpdateSuccess)emailUpdateResult;
                    return new Some((Object)new Tuple2((Object)emailUpdateSuccess.messageId(), (Object)BoxedUnit.UNIT));
                }
                return None$.MODULE$;
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.nonEmpty()));
        }

        public Option<Map<UnparsedMessageId, SetError>> notUpdated() {
            return Option$.MODULE$.apply((Object)((IterableOnceOps)this.results().flatMap((Function1 & Serializable)x0$1 -> {
                EmailUpdateResult emailUpdateResult = x0$1;
                if (emailUpdateResult instanceof EmailUpdateFailure) {
                    EmailUpdateFailure emailUpdateFailure = (EmailUpdateFailure)emailUpdateResult;
                    return new Some((Object)new Tuple2((Object)emailUpdateFailure.unparsedMessageId(), (Object)emailUpdateFailure.asMessageSetError()));
                }
                return None$.MODULE$;
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.nonEmpty()));
        }

        public EmailUpdateResults copy(scala.collection.immutable.Seq<EmailUpdateResult> results) {
            return new EmailUpdateResults(results);
        }

        public scala.collection.immutable.Seq<EmailUpdateResult> copy$default$1() {
            return this.results();
        }

        public String productPrefix() {
            return "EmailUpdateResults";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.results();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof EmailUpdateResults;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "results";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof EmailUpdateResults)) return false;
            boolean bl = true;
            if (!bl) return false;
            EmailUpdateResults emailUpdateResults = (EmailUpdateResults)x$1;
            scala.collection.immutable.Seq<EmailUpdateResult> seq = this.results();
            scala.collection.immutable.Seq<EmailUpdateResult> seq2 = emailUpdateResults.results();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!emailUpdateResults.canEqual(this)) return false;
            return true;
        }

        public EmailUpdateResults(scala.collection.immutable.Seq<EmailUpdateResult> results) {
            this.results = results;
            Product.$init$((Product)this);
        }
    }

    public static class EmailUpdateSuccess
    implements EmailUpdateResult,
    Product,
    Serializable {
        private final MessageId messageId;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public MessageId messageId() {
            return this.messageId;
        }

        public EmailUpdateSuccess copy(MessageId messageId) {
            return new EmailUpdateSuccess(messageId);
        }

        public MessageId copy$default$1() {
            return this.messageId();
        }

        public String productPrefix() {
            return "EmailUpdateSuccess";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.messageId();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof EmailUpdateSuccess;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "messageId";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof EmailUpdateSuccess)) return false;
            boolean bl = true;
            if (!bl) return false;
            EmailUpdateSuccess emailUpdateSuccess = (EmailUpdateSuccess)x$1;
            MessageId messageId = this.messageId();
            MessageId messageId2 = emailUpdateSuccess.messageId();
            if (messageId == null) {
                if (messageId2 != null) {
                    return false;
                }
            } else if (!messageId.equals(messageId2)) return false;
            if (!emailUpdateSuccess.canEqual(this)) return false;
            return true;
        }

        public EmailUpdateSuccess(MessageId messageId) {
            this.messageId = messageId;
            Product.$init$((Product)this);
        }
    }
}

