/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.mail;

import java.io.Serializable;
import javax.inject.Inject;
import org.apache.james.jmap.api.model.Size$;
import org.apache.james.jmap.core.UTCDate;
import org.apache.james.jmap.core.UTCDate$;
import org.apache.james.jmap.mail.BlobId;
import org.apache.james.jmap.mail.BlobId$;
import org.apache.james.jmap.mail.EmailGetRequest;
import org.apache.james.jmap.mail.EmailMetadata;
import org.apache.james.jmap.mail.EmailMetadataView;
import org.apache.james.jmap.mail.EmailViewFactory;
import org.apache.james.jmap.mail.Keywords;
import org.apache.james.jmap.mail.KeywordsFactory$;
import org.apache.james.jmap.mail.MailboxIds;
import org.apache.james.jmap.method.ZoneIdProvider;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.util.html.HtmlTextExtractor;
import scala.Function0;
import scala.Function1;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u00154A\u0001B\u0003\u0005!!Aa\u0004\u0001B\u0001B\u0003%q\u0004C\u0003&\u0001\u0011\u0005a\u0005C\u00033\u0001\u0011\u00053G\u0001\rF[\u0006LG.T3uC\u0012\fG/\u0019,jK^4\u0015m\u0019;pefT!AB\u0004\u0002\t5\f\u0017\u000e\u001c\u0006\u0003\u0011%\tAA[7ba*\u0011!bC\u0001\u0006U\u0006lWm\u001d\u0006\u0003\u00195\ta!\u00199bG\",'\"\u0001\b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\tr\u0003\u0005\u0002\u0013+5\t1CC\u0001\u0015\u0003\u0015\u00198-\u00197b\u0013\t12C\u0001\u0004B]f\u0014VM\u001a\t\u00041eYR\"A\u0003\n\u0005i)!\u0001E#nC&dg+[3x\r\u0006\u001cGo\u001c:z!\tAB$\u0003\u0002\u001e\u000b\t\tR)\\1jY6+G/\u00193bi\u00064\u0016.Z<\u0002\u001di|g.Z%e!J|g/\u001b3feB\u0011\u0001eI\u0007\u0002C)\u0011!eB\u0001\u0007[\u0016$\bn\u001c3\n\u0005\u0011\n#A\u0004.p]\u0016LE\r\u0015:pm&$WM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u001dB\u0003C\u0001\r\u0001\u0011\u0015q\"\u00011\u0001 Q\t\u0011!\u0006\u0005\u0002,a5\tAF\u0003\u0002.]\u00051\u0011N\u001c6fGRT\u0011aL\u0001\u0006U\u00064\u0018\r_\u0005\u0003c1\u0012a!\u00138kK\u000e$\u0018a\u0002;p\u000b6\f\u0017\u000e\u001c\u000b\u0004i]\u0003GCA\u001b<!\r1\u0014hG\u0007\u0002o)\u0011\u0001hE\u0001\u0005kRLG.\u0003\u0002;o\t\u0019AK]=\t\u000bq\u001a\u0001\u0019A\u001f\u0002\u000f5,7o]1hKB!!C\u0010!I\u0013\ty4C\u0001\u0004UkBdWM\r\t\u0003\u0003\u001ak\u0011A\u0011\u0006\u0003\u0007\u0012\u000bQ!\\8eK2T!!R\u0005\u0002\u000f5\f\u0017\u000e\u001c2pq&\u0011qI\u0011\u0002\n\u001b\u0016\u001c8/Y4f\u0013\u0012\u00042!S)U\u001d\tQuJ\u0004\u0002L\u001d6\tAJ\u0003\u0002N\u001f\u00051AH]8pizJ\u0011\u0001F\u0005\u0003!N\tq\u0001]1dW\u0006<W-\u0003\u0002S'\n\u00191+Z9\u000b\u0005A\u001b\u0002CA!V\u0013\t1&IA\u0007NKN\u001c\u0018mZ3SKN,H\u000e\u001e\u0005\u00061\u000e\u0001\r!W\u0001\u0012QRlG\u000eV3yi\u0016CHO]1di>\u0014\bC\u0001._\u001b\u0005Y&B\u0001/^\u0003\u0011AG/\u001c7\u000b\u0005aJ\u0011BA0\\\u0005EAE/\u001c7UKb$X\t\u001f;sC\u000e$xN\u001d\u0005\u0006C\u000e\u0001\rAY\u0001\be\u0016\fX/Z:u!\tA2-\u0003\u0002e\u000b\tyQ)\\1jY\u001e+GOU3rk\u0016\u001cH\u000f")
public class EmailMetadataViewFactory
implements EmailViewFactory<EmailMetadataView> {
    private final ZoneIdProvider zoneIdProvider;

    @Override
    public Try<EmailMetadataView> toEmail(HtmlTextExtractor htmlTextExtractor, EmailGetRequest request, Tuple2<MessageId, Seq<MessageResult>> message) {
        MessageId messageId = (MessageId)message._1();
        MailboxIds mailboxIds = new MailboxIds((List<MailboxId>)((IterableOnceOps)((IterableOps)message._2()).map((Function1 & Serializable)x$14 -> x$14.getMailboxId())).toList());
        String threadId = ((MessageResult)((IterableOps)message._2()).head()).getThreadId().serialize();
        return ((Try)((IterableOps)message._2()).headOption().map((Function1 & Serializable)x$15 -> new Success(x$15)).getOrElse((Function0 & Serializable)() -> new Failure((Throwable)new IllegalArgumentException("No message supplied")))).flatMap((Function1 & Serializable)firstMessage -> BlobId$.MODULE$.of(messageId).flatMap((Function1 & Serializable)blobId -> KeywordsFactory$.MODULE$.LENIENT_KEYWORDS_FACTORY().fromFlags(firstMessage.getFlags()).map((Function1 & Serializable)keywords -> {
            MessageId x$1 = messageId;
            BlobId x$2 = blobId;
            String x$3 = threadId;
            Keywords x$4 = keywords;
            MailboxIds x$5 = mailboxIds;
            UTCDate x$6 = UTCDate$.MODULE$.from(firstMessage.getInternalDate(), $this.zoneIdProvider.get());
            Long x$7 = Size$.MODULE$.sanitizeSize(firstMessage.getSize());
            return new EmailMetadataView(new EmailMetadata(x$1, x$2, x$3, x$4, x$5, x$7, x$6));
        })));
    }

    @Inject
    public EmailMetadataViewFactory(ZoneIdProvider zoneIdProvider) {
        this.zoneIdProvider = zoneIdProvider;
    }
}

