/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Integer;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DecodeableControl;
import com.unboundid.ldap.sdk.JSONControlDecodeHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.AuthenticationFailureReason;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.ldap.sdk.unboundidds.extensions.PasswordPolicyStateAccountUsabilityError;
import com.unboundid.ldap.sdk.unboundidds.extensions.PasswordPolicyStateAccountUsabilityNotice;
import com.unboundid.ldap.sdk.unboundidds.extensions.PasswordPolicyStateAccountUsabilityWarning;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONArray;
import com.unboundid.util.json.JSONField;
import com.unboundid.util.json.JSONNumber;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class GetPasswordPolicyStateIssuesResponseControl
extends Control
implements DecodeableControl {
    @NotNull
    public static final String GET_PASSWORD_POLICY_STATE_ISSUES_RESPONSE_OID = "1.3.6.1.4.1.30221.2.5.47";
    private static final byte TYPE_NOTICES = -96;
    private static final byte TYPE_WARNINGS = -95;
    private static final byte TYPE_ERRORS = -94;
    private static final byte TYPE_AUTH_FAILURE_REASON = -93;
    @NotNull
    private static final String JSON_FIELD_AUTH_FAILURE_REASON = "authentication-failure-reason";
    @NotNull
    private static final String JSON_FIELD_ERRORS = "errors";
    @NotNull
    private static final String JSON_FIELD_ID = "id";
    @NotNull
    private static final String JSON_FIELD_MESSAGE = "message";
    @NotNull
    private static final String JSON_FIELD_NAME = "name";
    @NotNull
    private static final String JSON_FIELD_NOTICES = "notices";
    @NotNull
    private static final String JSON_FIELD_WARNINGS = "warnings";
    private static final long serialVersionUID = 7509027658735069270L;
    @Nullable
    private final AuthenticationFailureReason authFailureReason;
    @NotNull
    private final List<PasswordPolicyStateAccountUsabilityError> errors;
    @NotNull
    private final List<PasswordPolicyStateAccountUsabilityNotice> notices;
    @NotNull
    private final List<PasswordPolicyStateAccountUsabilityWarning> warnings;

    GetPasswordPolicyStateIssuesResponseControl() {
        this.authFailureReason = null;
        this.notices = Collections.emptyList();
        this.warnings = Collections.emptyList();
        this.errors = Collections.emptyList();
    }

    public GetPasswordPolicyStateIssuesResponseControl(@Nullable List<PasswordPolicyStateAccountUsabilityNotice> notices, @Nullable List<PasswordPolicyStateAccountUsabilityWarning> warnings, @Nullable List<PasswordPolicyStateAccountUsabilityError> errors) {
        this(notices, warnings, errors, null);
    }

    public GetPasswordPolicyStateIssuesResponseControl(@Nullable List<PasswordPolicyStateAccountUsabilityNotice> notices, @Nullable List<PasswordPolicyStateAccountUsabilityWarning> warnings, @Nullable List<PasswordPolicyStateAccountUsabilityError> errors, @Nullable AuthenticationFailureReason authFailureReason) {
        super(GET_PASSWORD_POLICY_STATE_ISSUES_RESPONSE_OID, false, GetPasswordPolicyStateIssuesResponseControl.encodeValue(notices, warnings, errors, authFailureReason));
        this.authFailureReason = authFailureReason;
        this.notices = notices == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<PasswordPolicyStateAccountUsabilityNotice>(notices));
        this.warnings = warnings == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<PasswordPolicyStateAccountUsabilityWarning>(warnings));
        this.errors = errors == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<PasswordPolicyStateAccountUsabilityError>(errors));
    }

    public GetPasswordPolicyStateIssuesResponseControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        super(oid, isCritical, value);
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_PWP_STATE_ISSUES_RESPONSE_NO_VALUE.get());
        }
        AuthenticationFailureReason afr = null;
        List nList = Collections.emptyList();
        List wList = Collections.emptyList();
        List eList = Collections.emptyList();
        try {
            block9: for (ASN1Element e : ASN1Sequence.decodeAsSequence(value.getValue()).elements()) {
                switch (e.getType()) {
                    case -96: {
                        String message;
                        String name;
                        int type;
                        nList = new ArrayList(10);
                        for (ASN1Element ne : ASN1Sequence.decodeAsSequence(e).elements()) {
                            ASN1Element[] noticeElements = ASN1Sequence.decodeAsSequence(ne).elements();
                            type = ASN1Integer.decodeAsInteger(noticeElements[0]).intValue();
                            name = ASN1OctetString.decodeAsOctetString(noticeElements[1]).stringValue();
                            message = noticeElements.length == 3 ? ASN1OctetString.decodeAsOctetString(noticeElements[2]).stringValue() : null;
                            nList.add(new PasswordPolicyStateAccountUsabilityNotice(type, name, message));
                        }
                        nList = Collections.unmodifiableList(nList);
                        continue block9;
                    }
                    case -95: {
                        String message;
                        String name;
                        int type;
                        wList = new ArrayList(10);
                        for (ASN1Element we : ASN1Sequence.decodeAsSequence(e).elements()) {
                            ASN1Element[] warningElements = ASN1Sequence.decodeAsSequence(we).elements();
                            type = ASN1Integer.decodeAsInteger(warningElements[0]).intValue();
                            name = ASN1OctetString.decodeAsOctetString(warningElements[1]).stringValue();
                            message = warningElements.length == 3 ? ASN1OctetString.decodeAsOctetString(warningElements[2]).stringValue() : null;
                            wList.add(new PasswordPolicyStateAccountUsabilityWarning(type, name, message));
                        }
                        wList = Collections.unmodifiableList(wList);
                        continue block9;
                    }
                    case -94: {
                        String message;
                        String name;
                        int type;
                        eList = new ArrayList(10);
                        for (ASN1Element ee : ASN1Sequence.decodeAsSequence(e).elements()) {
                            ASN1Element[] errorElements = ASN1Sequence.decodeAsSequence(ee).elements();
                            type = ASN1Integer.decodeAsInteger(errorElements[0]).intValue();
                            name = ASN1OctetString.decodeAsOctetString(errorElements[1]).stringValue();
                            message = errorElements.length == 3 ? ASN1OctetString.decodeAsOctetString(errorElements[2]).stringValue() : null;
                            eList.add(new PasswordPolicyStateAccountUsabilityError(type, name, message));
                        }
                        eList = Collections.unmodifiableList(eList);
                        continue block9;
                    }
                    case -93: {
                        ASN1Element[] afrElements = ASN1Sequence.decodeAsSequence(e).elements();
                        int afrType = ASN1Integer.decodeAsInteger(afrElements[0]).intValue();
                        String afrName = ASN1OctetString.decodeAsOctetString(afrElements[1]).stringValue();
                        String afrMessage = afrElements.length == 3 ? ASN1OctetString.decodeAsOctetString(afrElements[2]).stringValue() : null;
                        afr = new AuthenticationFailureReason(afrType, afrName, afrMessage);
                        continue block9;
                    }
                    default: {
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_PWP_STATE_ISSUES_RESPONSE_UNEXPECTED_TYPE.get(StaticUtils.toHex(e.getType())));
                    }
                }
            }
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_PWP_STATE_ISSUES_RESPONSE_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
        this.authFailureReason = afr;
        this.notices = nList;
        this.warnings = wList;
        this.errors = eList;
    }

    @NotNull
    private static ASN1OctetString encodeValue(@Nullable List<PasswordPolicyStateAccountUsabilityNotice> notices, @Nullable List<PasswordPolicyStateAccountUsabilityWarning> warnings, @Nullable List<PasswordPolicyStateAccountUsabilityError> errors, @Nullable AuthenticationFailureReason authFailureReason) {
        ArrayList<ASN1Sequence> elements = new ArrayList<ASN1Sequence>(4);
        if (notices != null && !notices.isEmpty()) {
            ArrayList<ASN1Sequence> noticeElements = new ArrayList<ASN1Sequence>(notices.size());
            for (PasswordPolicyStateAccountUsabilityNotice n : notices) {
                if (n.getMessage() == null) {
                    noticeElements.add(new ASN1Sequence(new ASN1Integer(n.getIntValue()), new ASN1OctetString(n.getName())));
                    continue;
                }
                noticeElements.add(new ASN1Sequence(new ASN1Integer(n.getIntValue()), new ASN1OctetString(n.getName()), new ASN1OctetString(n.getMessage())));
            }
            elements.add(new ASN1Sequence(-96, noticeElements));
        }
        if (warnings != null && !warnings.isEmpty()) {
            ArrayList<ASN1Sequence> warningElements = new ArrayList<ASN1Sequence>(warnings.size());
            for (PasswordPolicyStateAccountUsabilityWarning w : warnings) {
                if (w.getMessage() == null) {
                    warningElements.add(new ASN1Sequence(new ASN1Integer(w.getIntValue()), new ASN1OctetString(w.getName())));
                    continue;
                }
                warningElements.add(new ASN1Sequence(new ASN1Integer(w.getIntValue()), new ASN1OctetString(w.getName()), new ASN1OctetString(w.getMessage())));
            }
            elements.add(new ASN1Sequence(-95, warningElements));
        }
        if (errors != null && !errors.isEmpty()) {
            ArrayList<ASN1Sequence> errorElements = new ArrayList<ASN1Sequence>(errors.size());
            for (PasswordPolicyStateAccountUsabilityError e : errors) {
                if (e.getMessage() == null) {
                    errorElements.add(new ASN1Sequence(new ASN1Integer(e.getIntValue()), new ASN1OctetString(e.getName())));
                    continue;
                }
                errorElements.add(new ASN1Sequence(new ASN1Integer(e.getIntValue()), new ASN1OctetString(e.getName()), new ASN1OctetString(e.getMessage())));
            }
            elements.add(new ASN1Sequence(-94, errorElements));
        }
        if (authFailureReason != null) {
            if (authFailureReason.getMessage() == null) {
                elements.add(new ASN1Sequence(-93, new ASN1Integer(authFailureReason.getIntValue()), new ASN1OctetString(authFailureReason.getName())));
            } else {
                elements.add(new ASN1Sequence(-93, new ASN1Integer(authFailureReason.getIntValue()), new ASN1OctetString(authFailureReason.getName()), new ASN1OctetString(authFailureReason.getMessage())));
            }
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    @Override
    @NotNull
    public GetPasswordPolicyStateIssuesResponseControl decodeControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        return new GetPasswordPolicyStateIssuesResponseControl(oid, isCritical, value);
    }

    @NotNull
    public List<PasswordPolicyStateAccountUsabilityNotice> getNotices() {
        return this.notices;
    }

    @NotNull
    public List<PasswordPolicyStateAccountUsabilityWarning> getWarnings() {
        return this.warnings;
    }

    @NotNull
    public List<PasswordPolicyStateAccountUsabilityError> getErrors() {
        return this.errors;
    }

    @Nullable
    public AuthenticationFailureReason getAuthenticationFailureReason() {
        return this.authFailureReason;
    }

    @Nullable
    public static GetPasswordPolicyStateIssuesResponseControl get(@NotNull BindResult bindResult) throws LDAPException {
        Control c = bindResult.getResponseControl(GET_PASSWORD_POLICY_STATE_ISSUES_RESPONSE_OID);
        if (c == null) {
            return null;
        }
        if (c instanceof GetPasswordPolicyStateIssuesResponseControl) {
            return (GetPasswordPolicyStateIssuesResponseControl)c;
        }
        return new GetPasswordPolicyStateIssuesResponseControl(c.getOID(), c.isCritical(), c.getValue());
    }

    @Nullable
    public static GetPasswordPolicyStateIssuesResponseControl get(@NotNull LDAPException ldapException) throws LDAPException {
        Control c = ldapException.getResponseControl(GET_PASSWORD_POLICY_STATE_ISSUES_RESPONSE_OID);
        if (c == null) {
            return null;
        }
        if (c instanceof GetPasswordPolicyStateIssuesResponseControl) {
            return (GetPasswordPolicyStateIssuesResponseControl)c;
        }
        return new GetPasswordPolicyStateIssuesResponseControl(c.getOID(), c.isCritical(), c.getValue());
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_GET_PWP_STATE_ISSUES_RESPONSE.get();
    }

    @Override
    @NotNull
    public JSONObject toJSONControl() {
        ArrayList<JSONObject> arrayValues;
        LinkedHashMap<String, JSONValue> valueFields = new LinkedHashMap<String, JSONValue>();
        if (!this.notices.isEmpty()) {
            arrayValues = new ArrayList<JSONObject>(this.notices.size());
            for (PasswordPolicyStateAccountUsabilityNotice notice : this.notices) {
                arrayValues.add(GetPasswordPolicyStateIssuesResponseControl.encodeItem(notice.getIntValue(), notice.getName(), notice.getMessage()));
            }
            valueFields.put(JSON_FIELD_NOTICES, new JSONArray(arrayValues));
        }
        if (!this.warnings.isEmpty()) {
            arrayValues = new ArrayList(this.warnings.size());
            for (PasswordPolicyStateAccountUsabilityWarning warning : this.warnings) {
                arrayValues.add(GetPasswordPolicyStateIssuesResponseControl.encodeItem(warning.getIntValue(), warning.getName(), warning.getMessage()));
            }
            valueFields.put(JSON_FIELD_WARNINGS, new JSONArray(arrayValues));
        }
        if (!this.errors.isEmpty()) {
            arrayValues = new ArrayList(this.notices.size());
            for (PasswordPolicyStateAccountUsabilityError error : this.errors) {
                arrayValues.add(GetPasswordPolicyStateIssuesResponseControl.encodeItem(error.getIntValue(), error.getName(), error.getMessage()));
            }
            valueFields.put(JSON_FIELD_ERRORS, new JSONArray(arrayValues));
        }
        if (this.authFailureReason != null) {
            valueFields.put(JSON_FIELD_AUTH_FAILURE_REASON, GetPasswordPolicyStateIssuesResponseControl.encodeItem(this.authFailureReason.getIntValue(), this.authFailureReason.getName(), this.authFailureReason.getMessage()));
        }
        return new JSONObject(new JSONField("oid", GET_PASSWORD_POLICY_STATE_ISSUES_RESPONSE_OID), new JSONField("control-name", ControlMessages.INFO_CONTROL_NAME_GET_PWP_STATE_ISSUES_RESPONSE.get()), new JSONField("criticality", this.isCritical()), new JSONField("value-json", new JSONObject(valueFields)));
    }

    @NotNull
    private static JSONObject encodeItem(int id, @NotNull String name, @Nullable String message) {
        LinkedHashMap<String, JSONValue> fields = new LinkedHashMap<String, JSONValue>();
        fields.put(JSON_FIELD_ID, new JSONNumber(id));
        fields.put(JSON_FIELD_NAME, new JSONString(name));
        if (message != null) {
            fields.put(JSON_FIELD_MESSAGE, new JSONString(message));
        }
        return new JSONObject(fields);
    }

    @NotNull
    public static GetPasswordPolicyStateIssuesResponseControl decodeJSONControl(@NotNull JSONObject controlObject, boolean strict) throws LDAPException {
        List<String> unrecognizedFields;
        AuthenticationFailureReason authFailureReason;
        JSONObject authFailureReasonObject;
        JSONControlDecodeHelper jsonControl = new JSONControlDecodeHelper(controlObject, strict, true, true);
        ASN1OctetString rawValue = jsonControl.getRawValue();
        if (rawValue != null) {
            return new GetPasswordPolicyStateIssuesResponseControl(jsonControl.getOID(), jsonControl.getCriticality(), rawValue);
        }
        JSONObject valueObject = jsonControl.getValueObject();
        ArrayList<PasswordPolicyStateAccountUsabilityNotice> notices = new ArrayList<PasswordPolicyStateAccountUsabilityNotice>();
        List<JSONValue> noticeValues = valueObject.getFieldAsArray(JSON_FIELD_NOTICES);
        if (noticeValues != null) {
            for (JSONValue v : noticeValues) {
                if (v instanceof JSONObject) {
                    JSONObject o = (JSONObject)v;
                    Integer id = o.getFieldAsInteger(JSON_FIELD_ID);
                    if (id == null) {
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_PWP_STATE_ISSUES_RESPONSE_JSON_MISSING_ITEM_FIELD.get(controlObject.toSingleLineString(), JSON_FIELD_NOTICES, JSON_FIELD_ID));
                    }
                    String name = o.getFieldAsString(JSON_FIELD_NAME);
                    if (name == null) {
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_PWP_STATE_ISSUES_RESPONSE_JSON_MISSING_ITEM_FIELD.get(controlObject.toSingleLineString(), JSON_FIELD_NOTICES, JSON_FIELD_NAME));
                    }
                    String message = o.getFieldAsString(JSON_FIELD_MESSAGE);
                    notices.add(new PasswordPolicyStateAccountUsabilityNotice(id, name, message));
                    continue;
                }
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_PWP_STATE_ISSUES_RESPONSE_JSON_VALUE_NOT_OBJECT.get(controlObject.toSingleLineString(), JSON_FIELD_NOTICES));
            }
        }
        ArrayList<PasswordPolicyStateAccountUsabilityWarning> warnings = new ArrayList<PasswordPolicyStateAccountUsabilityWarning>();
        List<JSONValue> warningValues = valueObject.getFieldAsArray(JSON_FIELD_WARNINGS);
        if (warningValues != null) {
            for (JSONValue v : warningValues) {
                if (v instanceof JSONObject) {
                    JSONObject o = (JSONObject)v;
                    Integer id = o.getFieldAsInteger(JSON_FIELD_ID);
                    if (id == null) {
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_PWP_STATE_ISSUES_RESPONSE_JSON_MISSING_ITEM_FIELD.get(controlObject.toSingleLineString(), JSON_FIELD_WARNINGS, JSON_FIELD_ID));
                    }
                    String name = o.getFieldAsString(JSON_FIELD_NAME);
                    if (name == null) {
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_PWP_STATE_ISSUES_RESPONSE_JSON_MISSING_ITEM_FIELD.get(controlObject.toSingleLineString(), JSON_FIELD_WARNINGS, JSON_FIELD_NAME));
                    }
                    String message = o.getFieldAsString(JSON_FIELD_MESSAGE);
                    warnings.add(new PasswordPolicyStateAccountUsabilityWarning(id, name, message));
                    continue;
                }
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_PWP_STATE_ISSUES_RESPONSE_JSON_VALUE_NOT_OBJECT.get(controlObject.toSingleLineString(), JSON_FIELD_WARNINGS));
            }
        }
        ArrayList<PasswordPolicyStateAccountUsabilityError> errors = new ArrayList<PasswordPolicyStateAccountUsabilityError>();
        List<JSONValue> errorValues = valueObject.getFieldAsArray(JSON_FIELD_ERRORS);
        if (errorValues != null) {
            for (JSONValue v : errorValues) {
                if (v instanceof JSONObject) {
                    JSONObject o = (JSONObject)v;
                    Integer id = o.getFieldAsInteger(JSON_FIELD_ID);
                    if (id == null) {
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_PWP_STATE_ISSUES_RESPONSE_JSON_MISSING_ITEM_FIELD.get(controlObject.toSingleLineString(), JSON_FIELD_ERRORS, JSON_FIELD_ID));
                    }
                    String name = o.getFieldAsString(JSON_FIELD_NAME);
                    if (name == null) {
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_PWP_STATE_ISSUES_RESPONSE_JSON_MISSING_ITEM_FIELD.get(controlObject.toSingleLineString(), JSON_FIELD_ERRORS, JSON_FIELD_NAME));
                    }
                    String message = o.getFieldAsString(JSON_FIELD_MESSAGE);
                    errors.add(new PasswordPolicyStateAccountUsabilityError(id, name, message));
                    continue;
                }
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_PWP_STATE_ISSUES_RESPONSE_JSON_VALUE_NOT_OBJECT.get(controlObject.toSingleLineString(), JSON_FIELD_ERRORS));
            }
        }
        if ((authFailureReasonObject = valueObject.getFieldAsObject(JSON_FIELD_AUTH_FAILURE_REASON)) == null) {
            authFailureReason = null;
        } else {
            Integer id = authFailureReasonObject.getFieldAsInteger(JSON_FIELD_ID);
            if (id == null) {
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_PWP_STATE_ISSUES_RESPONSE_JSON_MISSING_ITEM_FIELD.get(controlObject.toSingleLineString(), JSON_FIELD_AUTH_FAILURE_REASON, JSON_FIELD_ID));
            }
            String name = authFailureReasonObject.getFieldAsString(JSON_FIELD_NAME);
            if (name == null) {
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_PWP_STATE_ISSUES_RESPONSE_JSON_MISSING_ITEM_FIELD.get(controlObject.toSingleLineString(), JSON_FIELD_ERRORS, JSON_FIELD_NAME));
            }
            String message = authFailureReasonObject.getFieldAsString(JSON_FIELD_MESSAGE);
            authFailureReason = new AuthenticationFailureReason(id, name, message);
        }
        if (strict && !(unrecognizedFields = JSONControlDecodeHelper.getControlObjectUnexpectedFields(valueObject, JSON_FIELD_NOTICES, JSON_FIELD_WARNINGS, JSON_FIELD_ERRORS, JSON_FIELD_AUTH_FAILURE_REASON)).isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_PWP_STATE_ISSUES_RESPONSE_JSON_CONTROL_UNRECOGNIZED_FIELD.get(controlObject.toSingleLineString(), unrecognizedFields.get(0)));
        }
        return new GetPasswordPolicyStateIssuesResponseControl(notices, warnings, errors, authFailureReason);
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("GetPasswordPolicyStateIssuesResponseControl(notices={ ");
        Iterator<PasswordPolicyStateAccountUsabilityNotice> noticeIterator = this.notices.iterator();
        while (noticeIterator.hasNext()) {
            buffer.append(noticeIterator.next().toString());
            if (!noticeIterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("}, warnings={ ");
        Iterator<PasswordPolicyStateAccountUsabilityWarning> warningIterator = this.warnings.iterator();
        while (warningIterator.hasNext()) {
            buffer.append(warningIterator.next().toString());
            if (!warningIterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("}, errors={ ");
        Iterator<PasswordPolicyStateAccountUsabilityError> errorIterator = this.errors.iterator();
        while (errorIterator.hasNext()) {
            buffer.append(errorIterator.next().toString());
            if (!errorIterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append('}');
        if (this.authFailureReason != null) {
            buffer.append(", authFailureReason=");
            buffer.append(this.authFailureReason.toString());
        }
        buffer.append(')');
    }
}

