/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.mget;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.VersionType;
import org.opensearch.client.opensearch.core.search.SourceConfig;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class MultiGetOperation
implements JsonpSerializable {
    private final String id;
    @Nullable
    private final String index;
    @Nullable
    private final String routing;
    @Nullable
    private final SourceConfig source;
    private final List<String> storedFields;
    @Nullable
    private final Long version;
    @Nullable
    private final VersionType versionType;
    public static final JsonpDeserializer<MultiGetOperation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MultiGetOperation::setupMultiGetOperationDeserializer);

    private MultiGetOperation(Builder builder) {
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.index = builder.index;
        this.routing = builder.routing;
        this.source = builder.source;
        this.storedFields = ApiTypeHelper.unmodifiable(builder.storedFields);
        this.version = builder.version;
        this.versionType = builder.versionType;
    }

    public static MultiGetOperation of(Function<Builder, ObjectBuilder<MultiGetOperation>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String id() {
        return this.id;
    }

    @Nullable
    public final String index() {
        return this.index;
    }

    @Nullable
    public final String routing() {
        return this.routing;
    }

    @Nullable
    public final SourceConfig source() {
        return this.source;
    }

    public final List<String> storedFields() {
        return this.storedFields;
    }

    @Nullable
    public final Long version() {
        return this.version;
    }

    @Nullable
    public final VersionType versionType() {
        return this.versionType;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("_id");
        generator.write(this.id);
        if (this.index != null) {
            generator.writeKey("_index");
            generator.write(this.index);
        }
        if (this.routing != null) {
            generator.writeKey("routing");
            generator.write(this.routing);
        }
        if (this.source != null) {
            generator.writeKey("_source");
            this.source.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.storedFields)) {
            generator.writeKey("stored_fields");
            generator.writeStartArray();
            for (String item0 : this.storedFields) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version.longValue());
        }
        if (this.versionType != null) {
            generator.writeKey("version_type");
            this.versionType.serialize(generator, mapper);
        }
    }

    protected static void setupMultiGetOperationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "_id");
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "_index");
        op.add(Builder::routing, JsonpDeserializer.stringDeserializer(), "routing");
        op.add(Builder::source, SourceConfig._DESERIALIZER, "_source");
        op.add(Builder::storedFields, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "stored_fields");
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "version");
        op.add(Builder::versionType, VersionType._DESERIALIZER, "version_type");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<MultiGetOperation> {
        private String id;
        @Nullable
        private String index;
        @Nullable
        private String routing;
        @Nullable
        private SourceConfig source;
        @Nullable
        private List<String> storedFields;
        @Nullable
        private Long version;
        @Nullable
        private VersionType versionType;

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder index(@Nullable String value) {
            this.index = value;
            return this;
        }

        public final Builder routing(@Nullable String value) {
            this.routing = value;
            return this;
        }

        public final Builder source(@Nullable SourceConfig value) {
            this.source = value;
            return this;
        }

        public final Builder source(Function<SourceConfig.Builder, ObjectBuilder<SourceConfig>> fn) {
            return this.source(fn.apply(new SourceConfig.Builder()).build());
        }

        public final Builder storedFields(List<String> list) {
            this.storedFields = Builder._listAddAll(this.storedFields, list);
            return this;
        }

        public final Builder storedFields(String value, String ... values) {
            this.storedFields = Builder._listAdd(this.storedFields, value, values);
            return this;
        }

        public final Builder version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        public final Builder versionType(@Nullable VersionType value) {
            this.versionType = value;
            return this;
        }

        @Override
        public MultiGetOperation build() {
            this._checkSingleUse();
            return new MultiGetOperation(this);
        }
    }
}

