/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cluster.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class ClusterProcessor
implements JsonpSerializable {
    private final long count;
    private final long current;
    private final long failed;
    private final long timeInMillis;
    public static final JsonpDeserializer<ClusterProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterProcessor::setupClusterProcessorDeserializer);

    private ClusterProcessor(Builder builder) {
        this.count = ApiTypeHelper.requireNonNull(builder.count, this, "count");
        this.current = ApiTypeHelper.requireNonNull(builder.current, this, "current");
        this.failed = ApiTypeHelper.requireNonNull(builder.failed, this, "failed");
        this.timeInMillis = ApiTypeHelper.requireNonNull(builder.timeInMillis, this, "timeInMillis");
    }

    public static ClusterProcessor of(Function<Builder, ObjectBuilder<ClusterProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long count() {
        return this.count;
    }

    public final long current() {
        return this.current;
    }

    public final long failed() {
        return this.failed;
    }

    public final long timeInMillis() {
        return this.timeInMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        generator.writeKey("current");
        generator.write(this.current);
        generator.writeKey("failed");
        generator.write(this.failed);
        generator.writeKey("time_in_millis");
        generator.write(this.timeInMillis);
    }

    protected static void setupClusterProcessorDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count");
        op.add(Builder::current, JsonpDeserializer.longDeserializer(), "current");
        op.add(Builder::failed, JsonpDeserializer.longDeserializer(), "failed");
        op.add(Builder::timeInMillis, JsonpDeserializer.longDeserializer(), "time_in_millis");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ClusterProcessor> {
        private Long count;
        private Long current;
        private Long failed;
        private Long timeInMillis;

        public final Builder count(long value) {
            this.count = value;
            return this;
        }

        public final Builder current(long value) {
            this.current = value;
            return this;
        }

        public final Builder failed(long value) {
            this.failed = value;
            return this;
        }

        public final Builder timeInMillis(long value) {
            this.timeInMillis = value;
            return this;
        }

        @Override
        public ClusterProcessor build() {
            this._checkSingleUse();
            return new ClusterProcessor(this);
        }
    }
}

