/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.JsonpSerializer;
import org.opensearch.client.json.JsonpUtils;
import org.opensearch.client.json.UnionDeserializer;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.TaggedUnion;
import org.opensearch.client.util.TaggedUnionUtils;

public class Buckets<TBucket>
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    private final JsonpSerializer<TBucket> tBucketSerializer = null;

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    private Buckets(Kind kind, Object value) {
        this._kind = kind;
        this._value = value;
    }

    private Buckets(Builder<TBucket> builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static <TBucket> Buckets<TBucket> of(Function<Builder<TBucket>, ObjectBuilder<Buckets<TBucket>>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isArray() {
        return this._kind == Kind.Array;
    }

    public List<TBucket> array() {
        return (List)TaggedUnionUtils.get(this, Kind.Array);
    }

    public boolean isKeyed() {
        return this._kind == Kind.Keyed;
    }

    public Map<String, TBucket> keyed() {
        return (Map)TaggedUnionUtils.get(this, Kind.Keyed);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._kind) {
                case Array: {
                    generator.writeStartArray();
                    for (Object item0 : (List)this._value) {
                        JsonpUtils.serialize(item0, generator, this.tBucketSerializer, mapper);
                    }
                    generator.writeEnd();
                    break;
                }
                case Keyed: {
                    generator.writeStartObject();
                    for (Map.Entry item0 : ((Map)this._value).entrySet()) {
                        generator.writeKey((String)item0.getKey());
                        JsonpUtils.serialize(item0.getValue(), generator, this.tBucketSerializer, mapper);
                    }
                    generator.writeEnd();
                }
            }
        }
    }

    public static <TBucket> JsonpDeserializer<Buckets<TBucket>> createBucketsDeserializer(JsonpDeserializer<TBucket> tBucketDeserializer) {
        return new UnionDeserializer.Builder<Buckets, Kind, Object>(Buckets::new, false).addMember(Kind.Array, JsonpDeserializer.arrayDeserializer(tBucketDeserializer)).addMember(Kind.Keyed, JsonpDeserializer.stringMapDeserializer(tBucketDeserializer)).build();
    }

    public static class Builder<TBucket>
    extends ObjectBuilderBase
    implements ObjectBuilder<Buckets<TBucket>> {
        private Kind _kind;
        private Object _value;

        public ObjectBuilder<Buckets<TBucket>> array(List<TBucket> v) {
            this._kind = Kind.Array;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Buckets<TBucket>> keyed(Map<String, TBucket> v) {
            this._kind = Kind.Keyed;
            this._value = v;
            return this;
        }

        @Override
        public Buckets<TBucket> build() {
            this._checkSingleUse();
            return new Buckets(this);
        }
    }

    public static enum Kind {
        Array,
        Keyed;

    }
}

