/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatementBuilder;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.data.TupleValue;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.TupleType;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.relation.Relation;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.lambdas.Throwing;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.mail.internet.AddressException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.blob.api.BlobId;
import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;
import org.apache.james.mailrepository.api.MailKey;
import org.apache.james.mailrepository.api.MailRepositoryUrl;
import org.apache.james.mailrepository.cassandra.MailRepositoryTableV2;
import org.apache.james.server.core.MailImpl;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.apache.mailet.PerRecipientHeaders;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraMailRepositoryMailDaoV2 {
    private final CassandraAsyncExecutor executor;
    private final PreparedStatement insertMail;
    private final PreparedStatement deleteMail;
    private final PreparedStatement selectMail;
    private final PreparedStatement litBlobs;
    private final BlobId.Factory blobIdFactory;
    private final TupleType userHeaderNameHeaderValueTriple;

    @Inject
    @VisibleForTesting
    CassandraMailRepositoryMailDaoV2(CqlSession session, BlobId.Factory blobIdFactory) {
        this.executor = new CassandraAsyncExecutor(session);
        this.insertMail = this.prepareInsert(session);
        this.deleteMail = this.prepareDelete(session);
        this.selectMail = this.prepareSelect(session);
        this.litBlobs = this.prepareListBlobs(session);
        this.blobIdFactory = blobIdFactory;
        this.userHeaderNameHeaderValueTriple = DataTypes.tupleOf((DataType[])new DataType[]{DataTypes.TEXT, DataTypes.TEXT, DataTypes.TEXT});
    }

    private PreparedStatement prepareDelete(CqlSession session) {
        return session.prepare(((Delete)QueryBuilder.deleteFrom((String)"mailRepositoryContentV2").where(List.of((Relation)Relation.column((String)"name").isEqualTo((Term)QueryBuilder.bindMarker((String)"name")), (Relation)Relation.column((String)"mailKey").isEqualTo((Term)QueryBuilder.bindMarker((String)"mailKey"))))).build());
    }

    private PreparedStatement prepareListBlobs(CqlSession session) {
        return session.prepare(QueryBuilder.selectFrom((String)"mailRepositoryContentV2").columns(new String[]{"headerBlobId", "bodyBlobId"}).build());
    }

    private PreparedStatement prepareInsert(CqlSession session) {
        return session.prepare(QueryBuilder.insertInto((String)"mailRepositoryContentV2").value("name", (Term)QueryBuilder.bindMarker((String)"name")).value("mailKey", (Term)QueryBuilder.bindMarker((String)"mailKey")).value("state", (Term)QueryBuilder.bindMarker((String)"state")).value("sender", (Term)QueryBuilder.bindMarker((String)"sender")).value("recipients", (Term)QueryBuilder.bindMarker((String)"recipients")).value("attributes", (Term)QueryBuilder.bindMarker((String)"attributes")).value("errorMessage", (Term)QueryBuilder.bindMarker((String)"errorMessage")).value("remoteAddr", (Term)QueryBuilder.bindMarker((String)"remoteAddr")).value("remoteHost", (Term)QueryBuilder.bindMarker((String)"remoteHost")).value("lastUpdated", (Term)QueryBuilder.bindMarker((String)"lastUpdated")).value("headerBlobId", (Term)QueryBuilder.bindMarker((String)"headerBlobId")).value("bodyBlobId", (Term)QueryBuilder.bindMarker((String)"bodyBlobId")).value("perRecipientSpecificHeaders", (Term)QueryBuilder.bindMarker((String)"perRecipientSpecificHeaders")).build());
    }

    private PreparedStatement prepareSelect(CqlSession session) {
        return session.prepare(((Select)QueryBuilder.selectFrom((String)"mailRepositoryContentV2").columns(MailRepositoryTableV2.MAIL_PROPERTIES).where(List.of((Relation)Relation.column((String)"name").isEqualTo((Term)QueryBuilder.bindMarker((String)"name")), (Relation)Relation.column((String)"mailKey").isEqualTo((Term)QueryBuilder.bindMarker((String)"mailKey"))))).build());
    }

    public Mono<Void> store(MailRepositoryUrl url, Mail mail, BlobId headerId, BlobId bodyId) {
        return Mono.fromCallable(() -> {
            BoundStatementBuilder statement = (BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)this.insertMail.boundStatementBuilder(new Object[0]).setString("name", url.asString())).setString("mailKey", mail.getName())).setString("headerBlobId", headerId.asString())).setString("bodyBlobId", bodyId.asString())).setString("state", mail.getState())).setList("recipients", this.asStringList(mail.getRecipients()), String.class)).setString("remoteAddr", mail.getRemoteAddr())).setString("remoteHost", mail.getRemoteHost())).setInstant("lastUpdated", (Instant)Optional.ofNullable(mail.getLastUpdated()).map(Date::toInstant).orElse(null))).setMap("attributes", this.toRawAttributeMap(mail), String.class, String.class)).setList("perRecipientSpecificHeaders", this.toTupleList(mail.getPerRecipientSpecificHeaders()), TupleValue.class);
            Optional.ofNullable(mail.getErrorMessage()).ifPresent(errorMessage -> statement.setString("errorMessage", mail.getErrorMessage()));
            mail.getMaybeSender().asOptional().map(MailAddress::asString).ifPresent(mailAddress -> statement.setString("sender", mailAddress));
            return statement.build();
        }).flatMap(arg_0 -> ((CassandraAsyncExecutor)this.executor).executeVoid(arg_0));
    }

    public Mono<Void> remove(MailRepositoryUrl url, MailKey key) {
        return this.executor.executeVoid((Statement)((BoundStatement)this.deleteMail.bind(new Object[0]).setString("name", url.asString())).setString("mailKey", key.asString()));
    }

    public Mono<Optional<MailDTO>> read(MailRepositoryUrl url, MailKey key) {
        return this.executor.executeSingleRowOptional((Statement)((BoundStatement)this.selectMail.bind(new Object[0]).setString("name", url.asString())).setString("mailKey", key.asString())).map(rowOptional -> rowOptional.map(this::toMail));
    }

    private MailDTO toMail(Row row) {
        MaybeSender sender = MaybeSender.getMailSender((String)row.getString("sender"));
        List recipients = (List)row.getList("recipients", String.class).stream().map(Throwing.function(MailAddress::new)).collect(ImmutableList.toImmutableList());
        String state = row.getString("state");
        String remoteAddr = row.getString("remoteAddr");
        String remoteHost = row.getString("remoteHost");
        String errorMessage = row.getString("errorMessage");
        String name = row.getString("mailKey");
        Date lastUpdated = Optional.ofNullable(row.getInstant("lastUpdated")).map(Date::from).orElse(null);
        Map rawAttributes = row.getMap("attributes", String.class, String.class);
        PerRecipientHeaders perRecipientHeaders = this.fromList(row.getList("perRecipientSpecificHeaders", TupleValue.class));
        MailImpl.Builder mailBuilder = MailImpl.builder().name(name).sender(sender).addRecipients((Collection)recipients).lastUpdated(lastUpdated).errorMessage(errorMessage).remoteHost(remoteHost).remoteAddr(remoteAddr).state(state).addAllHeadersForRecipients(perRecipientHeaders).addAttributes(this.toAttributes(rawAttributes));
        return new MailDTO(mailBuilder, this.blobIdFactory.from(row.getString("headerBlobId")), this.blobIdFactory.from(row.getString("bodyBlobId")));
    }

    private List<Attribute> toAttributes(Map<String, String> rowAttributes) {
        return (List)rowAttributes.entrySet().stream().map(Throwing.function(entry -> new Attribute(AttributeName.of((String)((String)entry.getKey())), AttributeValue.fromJsonString((String)((String)entry.getValue()))))).collect(ImmutableList.toImmutableList());
    }

    private ImmutableList<String> asStringList(Collection<MailAddress> mailAddresses) {
        return (ImmutableList)mailAddresses.stream().map(MailAddress::asString).collect(ImmutableList.toImmutableList());
    }

    private ImmutableMap<String, String> toRawAttributeMap(Mail mail) {
        return (ImmutableMap)mail.attributes().flatMap(attribute -> attribute.getValue().toJson().map(JsonNode::toString).map(value -> Pair.of((Object)attribute.getName().asString(), (Object)value)).stream()).collect(ImmutableMap.toImmutableMap(Pair::getLeft, Pair::getRight));
    }

    private ImmutableList<TupleValue> toTupleList(PerRecipientHeaders perRecipientHeaders) {
        return (ImmutableList)perRecipientHeaders.getHeadersByRecipient().entries().stream().map(entry -> this.userHeaderNameHeaderValueTriple.newValue(new Object[]{((MailAddress)entry.getKey()).asString(), ((PerRecipientHeaders.Header)entry.getValue()).getName(), ((PerRecipientHeaders.Header)entry.getValue()).getValue()})).collect(ImmutableList.toImmutableList());
    }

    private PerRecipientHeaders fromList(List<TupleValue> list) {
        PerRecipientHeaders result = new PerRecipientHeaders();
        list.forEach(tuple -> result.addHeaderForRecipient(PerRecipientHeaders.Header.builder().name(tuple.getString(1)).value(tuple.getString(2)).build(), this.toMailAddress(tuple.getString(0))));
        return result;
    }

    private MailAddress toMailAddress(String rawValue) {
        try {
            return new MailAddress(rawValue);
        }
        catch (AddressException e) {
            throw new RuntimeException(e);
        }
    }

    Flux<BlobId> listBlobs() {
        return this.executor.executeRows((Statement)this.litBlobs.bind(new Object[0])).flatMapIterable(row -> List.of(this.blobIdFactory.from(row.getString("headerBlobId")), this.blobIdFactory.from(row.getString("bodyBlobId"))));
    }

    public static class MailDTO {
        private final MailImpl.Builder mailBuilder;
        private final BlobId headerBlobId;
        private final BlobId bodyBlobId;

        public MailDTO(MailImpl.Builder mailBuilder, BlobId headerBlobId, BlobId bodyBlobId) {
            this.mailBuilder = mailBuilder;
            this.headerBlobId = headerBlobId;
            this.bodyBlobId = bodyBlobId;
        }

        public MailImpl.Builder getMailBuilder() {
            return this.mailBuilder;
        }

        public BlobId getHeaderBlobId() {
            return this.headerBlobId;
        }

        public BlobId getBodyBlobId() {
            return this.bodyBlobId;
        }

        public final boolean equals(Object o) {
            if (o instanceof MailDTO) {
                MailDTO mailDTO = (MailDTO)o;
                return Objects.equals(this.mailBuilder.build(), mailDTO.mailBuilder.build()) && Objects.equals(this.headerBlobId, mailDTO.headerBlobId) && Objects.equals(this.bodyBlobId, mailDTO.bodyBlobId);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.mailBuilder.build(), this.headerBlobId, this.bodyBlobId);
        }
    }
}

