/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.cassandra.init;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import java.time.ZonedDateTime;
import java.util.Optional;
import org.apache.james.backends.cassandra.components.CassandraModule;
import org.apache.james.backends.cassandra.utils.ZonedDateTimeRepresentation;

public interface CassandraZonedDateTimeModule {
    public static final String ZONED_DATE_TIME = "zonedDateTime";
    public static final CqlIdentifier DATE = CqlIdentifier.fromCql((String)"date");
    public static final CqlIdentifier TIME_ZONE = CqlIdentifier.fromCql((String)"timeZone");
    public static final CassandraModule MODULE = CassandraModule.type("zonedDateTime").statement(statement -> statement.withField(DATE, DataTypes.TIMESTAMP).withField(TIME_ZONE, DataTypes.TEXT)).build();

    public static UdtValue toUDT(UserDefinedType zonedDateTimeUserType, ZonedDateTime zonedDateTime) {
        ZonedDateTimeRepresentation representation = ZonedDateTimeRepresentation.fromZonedDateTime(zonedDateTime);
        return (UdtValue)((UdtValue)zonedDateTimeUserType.newValue().setInstant(DATE, representation.getDate().toInstant())).setString(TIME_ZONE, representation.getSerializedZoneId());
    }

    public static Optional<UdtValue> toUDT(UserDefinedType zonedDateTimeUserType, Optional<ZonedDateTime> zonedDateTimeOptional) {
        return zonedDateTimeOptional.map(zonedDateTime -> CassandraZonedDateTimeModule.toUDT(zonedDateTimeUserType, zonedDateTime));
    }

    public static Optional<ZonedDateTime> fromUDTOptional(UdtValue value) {
        return Optional.ofNullable(value).map(CassandraZonedDateTimeModule::fromUDT);
    }

    public static ZonedDateTime fromUDT(UdtValue udtValue) {
        return ZonedDateTimeRepresentation.fromDate(udtValue.getInstant(DATE), udtValue.getString(TIME_ZONE)).getZonedDateTime();
    }
}

