/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.ldap;

import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.core.healthcheck.ComponentName;
import org.apache.james.core.healthcheck.HealthCheck;
import org.apache.james.core.healthcheck.Result;
import org.apache.james.user.ldap.ReadOnlyUsersLDAPRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class LdapHealthCheck
implements HealthCheck {
    public static final ComponentName COMPONENT_NAME = new ComponentName("LDAP User Server");
    public static final Username LDAP_TEST_USER = Username.of((String)"ldap-test");
    private static final Logger LOGGER = LoggerFactory.getLogger(LdapHealthCheck.class);
    private final ReadOnlyUsersLDAPRepository ldapUserRepository;

    @Inject
    public LdapHealthCheck(ReadOnlyUsersLDAPRepository ldapUserRepository) {
        this.ldapUserRepository = ldapUserRepository;
    }

    public ComponentName componentName() {
        return COMPONENT_NAME;
    }

    public Mono<Result> check() {
        return Mono.fromCallable(() -> this.ldapUserRepository.getUserByName(LDAP_TEST_USER)).thenReturn((Object)Result.healthy((ComponentName)COMPONENT_NAME)).doOnError(e -> LOGGER.error("Error in LDAP server", e)).onErrorResume(e -> Mono.just((Object)Result.unhealthy((ComponentName)COMPONENT_NAME, (String)"Error checking LDAP server!", (Throwable)e))).subscribeOn(Schedulers.boundedElastic());
    }
}

