/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DecodeableControl;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class UnsolicitedCancelResponseControl
extends Control
implements DecodeableControl {
    @NotNull
    public static final String UNSOLICITED_CANCEL_RESPONSE_OID = "1.3.6.1.4.1.30221.2.5.7";
    private static final long serialVersionUID = 36962888392922937L;

    public UnsolicitedCancelResponseControl() {
        super(UNSOLICITED_CANCEL_RESPONSE_OID, false, null);
    }

    public UnsolicitedCancelResponseControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        super(oid, isCritical, value);
        if (value != null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_UNSOLICITED_CANCEL_RESPONSE_HAS_VALUE.get());
        }
    }

    @Override
    @NotNull
    public UnsolicitedCancelResponseControl decodeControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        return new UnsolicitedCancelResponseControl(oid, isCritical, value);
    }

    @Nullable
    public static UnsolicitedCancelResponseControl get(@NotNull LDAPResult result) throws LDAPException {
        Control c = result.getResponseControl(UNSOLICITED_CANCEL_RESPONSE_OID);
        if (c == null) {
            return null;
        }
        if (c instanceof UnsolicitedCancelResponseControl) {
            return (UnsolicitedCancelResponseControl)c;
        }
        return new UnsolicitedCancelResponseControl(c.getOID(), c.isCritical(), c.getValue());
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_UNSOLICITED_CANCEL_RESPONSE.get();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("UnsolicitedCancelResponseControl()");
    }
}

