/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.jgroups.Event;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.Property;
import org.jgroups.stack.Protocol;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.Util;

@MBean(description="Written by Sanne")
public class DELAY
extends Protocol {
    private static final Random randomNumberGenerator = new Random();
    @Property(description="Upper bound of number of milliseconds to delay passing a message up the stack (exclusive)")
    protected int in_delay;
    @Property(description="Upper bound number of milliseconds to delay passing a message down the stack (exclusive)")
    protected int out_delay;
    @Property(description="Number of nanoseconds to delay passing a message up the stack")
    protected int in_delay_nanos;
    @Property(description="Number of nanoseconds to delay passing a message down the stack")
    protected int out_delay_nanos;
    @Property(description="Keep the delay constant. By default delay time randoms between 0 and upper bound")
    protected boolean constant_delay;
    protected DelayedMessageHandler delayed_message_handler;
    protected DelayQueue<DelayedMessage> delayed_messages = new DelayQueue();

    public int getInDelay() {
        return this.in_delay;
    }

    public void setInDelay(int in_delay) {
        this.in_delay = in_delay;
    }

    public int getOutDelay() {
        return this.out_delay;
    }

    public void setOutDelay(int out_delay) {
        this.out_delay = out_delay;
    }

    public int getInDelayNanos() {
        return this.in_delay_nanos;
    }

    public void setInDelayNanos(int in_delay_nanos) {
        this.in_delay_nanos = in_delay_nanos;
    }

    public int getOutDelayNanos() {
        return this.out_delay_nanos;
    }

    public void setOutDelayNanos(int out_delay_nanos) {
        this.out_delay_nanos = out_delay_nanos;
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.delayed_message_handler = new DelayedMessageHandler();
        this.delayed_message_handler.start();
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.delayed_message_handler != null) {
            Util.interruptAndWaitToDie(this.delayed_message_handler);
        }
    }

    @Override
    public Object down(Event evt) {
        if (DELAY.isMessage(evt)) {
            this.delayed_messages.add(new DelayedMessage(evt, System.nanoTime()));
            return null;
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object up(Event evt) {
        if (DELAY.isMessage(evt)) {
            this.sleep(this.in_delay, this.in_delay_nanos);
        }
        return this.up_prot.up(evt);
    }

    @Override
    public void up(MessageBatch batch) {
        this.sleep(this.in_delay, this.in_delay_nanos);
        this.up_prot.up(batch);
    }

    private static boolean isMessage(Event evt) {
        return evt.getType() == 1;
    }

    private int computeDelay(int n) {
        if (n <= 1) {
            return 0;
        }
        return this.constant_delay ? n : randomNumberGenerator.nextInt(n);
    }

    private void sleep(int variable_milliseconds_delay, int nano_delay) {
        int millis = this.computeDelay(variable_milliseconds_delay);
        if (millis != 0 || nano_delay != 0) {
            Util.sleep(millis, nano_delay);
        }
    }

    private class DelayedMessageHandler
    extends Thread {
        private List<DelayedMessage> buffer = new ArrayList<DelayedMessage>();

        private DelayedMessageHandler() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        DELAY.this.delayed_messages.drainTo(this.buffer);
                        for (DelayedMessage evt : this.buffer) {
                            DELAY.this.down_prot.down(evt.event);
                        }
                        this.buffer.clear();
                    }
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }
    }

    private class DelayedMessage
    implements Delayed {
        private final Event event;
        private final long start;
        private final long delay_time;

        public DelayedMessage(Event event, long start) {
            this.event = event;
            this.start = start;
            this.delay_time = TimeUnit.NANOSECONDS.convert(DELAY.this.computeDelay(DELAY.this.out_delay), TimeUnit.MILLISECONDS) + (long)DELAY.this.out_delay_nanos;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.start + this.delay_time - System.nanoTime(), TimeUnit.NANOSECONDS);
        }

        @Override
        public int compareTo(Delayed o) {
            long other_delay;
            if (o == this) {
                return 0;
            }
            long my_delay = this.getDelay(TimeUnit.NANOSECONDS);
            return my_delay < (other_delay = o.getDelay(TimeUnit.NANOSECONDS)) ? -1 : (my_delay == other_delay ? 0 : 1);
        }
    }
}

