/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import java.io.Closeable;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.message.request.SubscribeRequest;
import org.apache.james.imap.processor.AbstractSubscriptionProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.SubscriptionManager;
import org.apache.james.mailbox.exception.SubscriptionException;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscribeProcessor
extends AbstractSubscriptionProcessor<SubscribeRequest> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscribeProcessor.class);

    public SubscribeProcessor(ImapProcessor next, MailboxManager mailboxManager, SubscriptionManager subscriptionManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(SubscribeRequest.class, next, mailboxManager, subscriptionManager, factory, metricFactory);
    }

    @Override
    protected void doProcessRequest(SubscribeRequest request, ImapSession session, ImapProcessor.Responder responder) {
        String mailboxName = request.getMailboxName();
        MailboxSession mailboxSession = session.getMailboxSession();
        try {
            this.getSubscriptionManager().subscribe(mailboxSession, mailboxName);
            this.unsolicitedResponses(session, responder, false);
            this.okComplete(request, responder);
        }
        catch (SubscriptionException e) {
            LOGGER.info("Subscribe failed for mailbox {}", (Object)mailboxName, (Object)e);
            this.unsolicitedResponses(session, responder, false);
            this.no(request, responder, HumanReadableText.GENERIC_SUBSCRIPTION_FAILURE);
        }
    }

    @Override
    protected Closeable addContextToMDC(SubscribeRequest message) {
        return MDCBuilder.create().addToContext("action", "SUBSCRIBE").addToContext("mailbox", message.getMailboxName()).build();
    }
}

