/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import org.apache.james.events.EventBus;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.MailboxTyper;
import org.apache.james.imap.processor.AppendProcessor;
import org.apache.james.imap.processor.AuthenticateProcessor;
import org.apache.james.imap.processor.CapabilityProcessor;
import org.apache.james.imap.processor.CheckProcessor;
import org.apache.james.imap.processor.CloseProcessor;
import org.apache.james.imap.processor.CompressProcessor;
import org.apache.james.imap.processor.CopyProcessor;
import org.apache.james.imap.processor.CreateProcessor;
import org.apache.james.imap.processor.DeleteACLProcessor;
import org.apache.james.imap.processor.DeleteProcessor;
import org.apache.james.imap.processor.EnableProcessor;
import org.apache.james.imap.processor.ExamineProcessor;
import org.apache.james.imap.processor.ExpungeProcessor;
import org.apache.james.imap.processor.GetACLProcessor;
import org.apache.james.imap.processor.GetAnnotationProcessor;
import org.apache.james.imap.processor.GetQuotaProcessor;
import org.apache.james.imap.processor.GetQuotaRootProcessor;
import org.apache.james.imap.processor.IdleProcessor;
import org.apache.james.imap.processor.LSubProcessor;
import org.apache.james.imap.processor.ListProcessor;
import org.apache.james.imap.processor.ListRightsProcessor;
import org.apache.james.imap.processor.LoginProcessor;
import org.apache.james.imap.processor.LogoutProcessor;
import org.apache.james.imap.processor.MoveProcessor;
import org.apache.james.imap.processor.MyRightsProcessor;
import org.apache.james.imap.processor.NamespaceProcessor;
import org.apache.james.imap.processor.NoopProcessor;
import org.apache.james.imap.processor.RenameProcessor;
import org.apache.james.imap.processor.SearchProcessor;
import org.apache.james.imap.processor.SelectProcessor;
import org.apache.james.imap.processor.SetACLProcessor;
import org.apache.james.imap.processor.SetAnnotationProcessor;
import org.apache.james.imap.processor.SetQuotaProcessor;
import org.apache.james.imap.processor.StartTLSProcessor;
import org.apache.james.imap.processor.StatusProcessor;
import org.apache.james.imap.processor.StoreProcessor;
import org.apache.james.imap.processor.SubscribeProcessor;
import org.apache.james.imap.processor.SystemMessageProcessor;
import org.apache.james.imap.processor.UnselectProcessor;
import org.apache.james.imap.processor.UnsubscribeProcessor;
import org.apache.james.imap.processor.XListProcessor;
import org.apache.james.imap.processor.fetch.FetchProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.SubscriptionManager;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.apache.james.metrics.api.MetricFactory;

public class DefaultProcessorChain {
    public static ImapProcessor createDefaultChain(ImapProcessor chainEndProcessor, MailboxManager mailboxManager, EventBus eventBus, SubscriptionManager subscriptionManager, StatusResponseFactory statusResponseFactory, MailboxTyper mailboxTyper, QuotaManager quotaManager, QuotaRootResolver quotaRootResolver, MetricFactory metricFactory) {
        AuthenticateProcessor authenticateProcessor;
        SubscribeProcessor subscribeProcessor;
        SystemMessageProcessor systemProcessor = new SystemMessageProcessor(chainEndProcessor, mailboxManager);
        LogoutProcessor logoutProcessor = new LogoutProcessor(systemProcessor, mailboxManager, statusResponseFactory, metricFactory);
        CapabilityProcessor capabilityProcessor = new CapabilityProcessor(logoutProcessor, mailboxManager, statusResponseFactory, metricFactory);
        CheckProcessor checkProcessor = new CheckProcessor(capabilityProcessor, mailboxManager, statusResponseFactory, metricFactory);
        LoginProcessor loginProcessor = new LoginProcessor(checkProcessor, mailboxManager, statusResponseFactory, metricFactory);
        capabilityProcessor.addProcessor(loginProcessor);
        RenameProcessor renameProcessor = new RenameProcessor(loginProcessor, mailboxManager, statusResponseFactory, metricFactory);
        DeleteProcessor deleteProcessor = new DeleteProcessor(renameProcessor, mailboxManager, statusResponseFactory, metricFactory);
        CreateProcessor createProcessor = new CreateProcessor(deleteProcessor, mailboxManager, statusResponseFactory, metricFactory);
        CloseProcessor closeProcessor = new CloseProcessor(createProcessor, mailboxManager, statusResponseFactory, metricFactory);
        UnsubscribeProcessor unsubscribeProcessor = new UnsubscribeProcessor(closeProcessor, mailboxManager, subscriptionManager, statusResponseFactory, metricFactory);
        if (mailboxManager.hasCapability(MailboxManager.MailboxCapabilities.Annotation)) {
            SetAnnotationProcessor setAnnotationProcessor = new SetAnnotationProcessor(unsubscribeProcessor, mailboxManager, statusResponseFactory, metricFactory);
            capabilityProcessor.addProcessor(setAnnotationProcessor);
            GetAnnotationProcessor getAnnotationProcessor = new GetAnnotationProcessor(setAnnotationProcessor, mailboxManager, statusResponseFactory, metricFactory);
            capabilityProcessor.addProcessor(getAnnotationProcessor);
            subscribeProcessor = new SubscribeProcessor(getAnnotationProcessor, mailboxManager, subscriptionManager, statusResponseFactory, metricFactory);
        } else {
            subscribeProcessor = new SubscribeProcessor(unsubscribeProcessor, mailboxManager, subscriptionManager, statusResponseFactory, metricFactory);
        }
        CopyProcessor copyProcessor = new CopyProcessor(subscribeProcessor, mailboxManager, statusResponseFactory, metricFactory);
        if (mailboxManager.hasCapability(MailboxManager.MailboxCapabilities.Move)) {
            MoveProcessor moveProcessor = new MoveProcessor(copyProcessor, mailboxManager, statusResponseFactory, metricFactory);
            authenticateProcessor = new AuthenticateProcessor(moveProcessor, mailboxManager, statusResponseFactory, metricFactory);
            capabilityProcessor.addProcessor(moveProcessor);
        } else {
            authenticateProcessor = new AuthenticateProcessor(copyProcessor, mailboxManager, statusResponseFactory, metricFactory);
        }
        ExpungeProcessor expungeProcessor = new ExpungeProcessor(authenticateProcessor, mailboxManager, statusResponseFactory, metricFactory);
        ExamineProcessor examineProcessor = new ExamineProcessor(expungeProcessor, mailboxManager, eventBus, statusResponseFactory, metricFactory);
        AppendProcessor appendProcessor = new AppendProcessor(examineProcessor, mailboxManager, statusResponseFactory, metricFactory);
        StoreProcessor storeProcessor = new StoreProcessor(appendProcessor, mailboxManager, statusResponseFactory, metricFactory);
        NoopProcessor noopProcessor = new NoopProcessor(storeProcessor, mailboxManager, statusResponseFactory, metricFactory);
        IdleProcessor idleProcessor = new IdleProcessor(noopProcessor, mailboxManager, statusResponseFactory, metricFactory);
        StatusProcessor statusProcessor = new StatusProcessor(idleProcessor, mailboxManager, statusResponseFactory, metricFactory);
        LSubProcessor lsubProcessor = new LSubProcessor(statusProcessor, mailboxManager, subscriptionManager, statusResponseFactory, metricFactory);
        XListProcessor xlistProcessor = new XListProcessor(lsubProcessor, mailboxManager, statusResponseFactory, mailboxTyper, metricFactory);
        ListProcessor listProcessor = new ListProcessor(xlistProcessor, mailboxManager, statusResponseFactory, metricFactory);
        SearchProcessor searchProcessor = new SearchProcessor(listProcessor, mailboxManager, statusResponseFactory, metricFactory);
        capabilityProcessor.addProcessor(searchProcessor);
        SelectProcessor selectProcessor = new SelectProcessor(searchProcessor, mailboxManager, eventBus, statusResponseFactory, metricFactory);
        NamespaceProcessor namespaceProcessor = new NamespaceProcessor(selectProcessor, mailboxManager, statusResponseFactory, metricFactory);
        capabilityProcessor.addProcessor(xlistProcessor);
        FetchProcessor fetchProcessor = new FetchProcessor(namespaceProcessor, mailboxManager, statusResponseFactory, metricFactory);
        StartTLSProcessor startTLSProcessor = new StartTLSProcessor(fetchProcessor, statusResponseFactory);
        UnselectProcessor unselectProcessor = new UnselectProcessor(startTLSProcessor, mailboxManager, statusResponseFactory, metricFactory);
        CompressProcessor compressProcessor = new CompressProcessor(unselectProcessor, statusResponseFactory);
        GetACLProcessor getACLProcessor = new GetACLProcessor(compressProcessor, mailboxManager, statusResponseFactory, metricFactory);
        SetACLProcessor setACLProcessor = new SetACLProcessor(getACLProcessor, mailboxManager, statusResponseFactory, metricFactory);
        DeleteACLProcessor deleteACLProcessor = new DeleteACLProcessor(setACLProcessor, mailboxManager, statusResponseFactory, metricFactory);
        ListRightsProcessor listRightsProcessor = new ListRightsProcessor(deleteACLProcessor, mailboxManager, statusResponseFactory, metricFactory);
        MyRightsProcessor myRightsProcessor = new MyRightsProcessor(listRightsProcessor, mailboxManager, statusResponseFactory, metricFactory);
        EnableProcessor enableProcessor = new EnableProcessor(myRightsProcessor, mailboxManager, statusResponseFactory, metricFactory, capabilityProcessor);
        GetQuotaProcessor getQuotaProcessor = new GetQuotaProcessor(enableProcessor, mailboxManager, statusResponseFactory, quotaManager, quotaRootResolver, metricFactory);
        SetQuotaProcessor setQuotaProcessor = new SetQuotaProcessor(getQuotaProcessor, mailboxManager, statusResponseFactory, metricFactory);
        GetQuotaRootProcessor getQuotaRootProcessor = new GetQuotaRootProcessor(setQuotaProcessor, mailboxManager, statusResponseFactory, quotaRootResolver, quotaManager, metricFactory);
        enableProcessor.addProcessor(selectProcessor);
        capabilityProcessor.addProcessor(startTLSProcessor);
        capabilityProcessor.addProcessor(idleProcessor);
        capabilityProcessor.addProcessor(namespaceProcessor);
        capabilityProcessor.addProcessor(expungeProcessor);
        capabilityProcessor.addProcessor(unselectProcessor);
        capabilityProcessor.addProcessor(compressProcessor);
        capabilityProcessor.addProcessor(authenticateProcessor);
        capabilityProcessor.addProcessor(enableProcessor);
        capabilityProcessor.addProcessor(selectProcessor);
        capabilityProcessor.addProcessor(getACLProcessor);
        capabilityProcessor.addProcessor(getQuotaRootProcessor);
        return getQuotaRootProcessor;
    }
}

