/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.quota;

import com.github.fge.lambdas.Throwing;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.james.core.Domain;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.model.QuotaRoot;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public interface MaxQuotaManager {
    public void setMaxStorage(QuotaRoot var1, QuotaSizeLimit var2) throws MailboxException;

    public void setMaxMessage(QuotaRoot var1, QuotaCountLimit var2) throws MailboxException;

    public void removeMaxMessage(QuotaRoot var1) throws MailboxException;

    public void removeMaxStorage(QuotaRoot var1) throws MailboxException;

    public void setGlobalMaxStorage(QuotaSizeLimit var1) throws MailboxException;

    public void removeGlobalMaxStorage() throws MailboxException;

    public void setGlobalMaxMessage(QuotaCountLimit var1) throws MailboxException;

    public void removeGlobalMaxMessage() throws MailboxException;

    public Optional<QuotaSizeLimit> getGlobalMaxStorage() throws MailboxException;

    public Optional<QuotaCountLimit> getGlobalMaxMessage() throws MailboxException;

    default public Optional<QuotaSizeLimit> getMaxStorage(QuotaRoot quotaRoot) throws MailboxException {
        Map<Quota.Scope, QuotaSizeLimit> maxStorageDetails = this.listMaxStorageDetails(quotaRoot);
        return this.getMaxStorage(maxStorageDetails);
    }

    default public Optional<QuotaSizeLimit> getMaxStorage(Map<Quota.Scope, QuotaSizeLimit> maxStorageDetails) {
        return Quota.allScopes().stream().map(maxStorageDetails::get).filter(Objects::nonNull).findFirst();
    }

    default public Optional<QuotaCountLimit> getMaxMessage(QuotaRoot quotaRoot) throws MailboxException {
        Map<Quota.Scope, QuotaCountLimit> maxMessagesDetails = this.listMaxMessagesDetails(quotaRoot);
        return this.getMaxMessage(maxMessagesDetails);
    }

    default public Optional<QuotaCountLimit> getMaxMessage(Map<Quota.Scope, QuotaCountLimit> maxMessagesDetails) {
        return Stream.of(Quota.Scope.User, Quota.Scope.Domain, Quota.Scope.Global).map(maxMessagesDetails::get).filter(Objects::nonNull).findFirst();
    }

    public Map<Quota.Scope, QuotaCountLimit> listMaxMessagesDetails(QuotaRoot var1);

    default public Publisher<Map<Quota.Scope, QuotaCountLimit>> listMaxMessagesDetailsReactive(QuotaRoot quotaRoot) {
        return Mono.fromCallable(() -> this.listMaxMessagesDetails(quotaRoot)).subscribeOn(Schedulers.elastic());
    }

    public Map<Quota.Scope, QuotaSizeLimit> listMaxStorageDetails(QuotaRoot var1);

    default public Publisher<Map<Quota.Scope, QuotaSizeLimit>> listMaxStorageDetailsReactive(QuotaRoot quotaRoot) {
        return Mono.fromCallable(() -> this.listMaxStorageDetails(quotaRoot)).subscribeOn(Schedulers.elastic());
    }

    default public QuotaDetails quotaDetails(QuotaRoot quotaRoot) {
        return new QuotaDetails(this.listMaxMessagesDetails(quotaRoot), this.listMaxStorageDetails(quotaRoot));
    }

    default public Publisher<QuotaDetails> quotaDetailsReactive(QuotaRoot quotaRoot) {
        return Mono.zip((Mono)Mono.from(this.listMaxMessagesDetailsReactive(quotaRoot)), (Mono)Mono.from(this.listMaxStorageDetailsReactive(quotaRoot))).map(tuple -> new QuotaDetails((Map)tuple.getT1(), (Map)tuple.getT2()));
    }

    public Optional<QuotaCountLimit> getDomainMaxMessage(Domain var1);

    public void setDomainMaxMessage(Domain var1, QuotaCountLimit var2) throws MailboxException;

    public void removeDomainMaxMessage(Domain var1) throws MailboxException;

    public void setDomainMaxStorage(Domain var1, QuotaSizeLimit var2) throws MailboxException;

    public Optional<QuotaSizeLimit> getDomainMaxStorage(Domain var1);

    public void removeDomainMaxStorage(Domain var1) throws MailboxException;

    default public Optional<QuotaCountLimit> getComputedMaxMessage(Domain domain) throws MailboxException {
        return Stream.of(Throwing.supplier(() -> this.getDomainMaxMessage(domain)).sneakyThrow(), Throwing.supplier(this::getGlobalMaxMessage).sneakyThrow()).map(Supplier::get).flatMap(Optional::stream).findFirst();
    }

    default public Optional<QuotaSizeLimit> getComputedMaxStorage(Domain domain) throws MailboxException {
        return Stream.of(Throwing.supplier(() -> this.getDomainMaxStorage(domain)).sneakyThrow(), Throwing.supplier(this::getGlobalMaxStorage).sneakyThrow()).map(Supplier::get).flatMap(Optional::stream).findFirst();
    }

    public static class QuotaDetails {
        private final Map<Quota.Scope, QuotaCountLimit> maxMessageDetails;
        private final Map<Quota.Scope, QuotaSizeLimit> maxStorageDetails;

        public QuotaDetails(Map<Quota.Scope, QuotaCountLimit> maxMessageDetails, Map<Quota.Scope, QuotaSizeLimit> maxStorageDetails) {
            this.maxMessageDetails = maxMessageDetails;
            this.maxStorageDetails = maxStorageDetails;
        }

        public Map<Quota.Scope, QuotaCountLimit> getMaxMessageDetails() {
            return this.maxMessageDetails;
        }

        public Map<Quota.Scope, QuotaSizeLimit> getMaxStorageDetails() {
            return this.maxStorageDetails;
        }
    }
}

