/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.user;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.backends.cassandra.utils.CassandraUtils;
import org.apache.james.core.Username;
import org.apache.james.mailbox.store.transaction.NonTransactionalMapper;
import org.apache.james.mailbox.store.user.SubscriptionMapper;
import org.apache.james.mailbox.store.user.model.Subscription;
import reactor.core.publisher.Flux;

public class CassandraSubscriptionMapper
extends NonTransactionalMapper
implements SubscriptionMapper {
    private final Session session;
    private final CassandraUtils cassandraUtils;
    private final PreparedStatement deleteStatement;
    private final PreparedStatement selectStatement;
    private final PreparedStatement insertStatement;
    private final CassandraAsyncExecutor executor;

    public CassandraSubscriptionMapper(Session session, CassandraUtils cassandraUtils) {
        this.session = session;
        this.executor = new CassandraAsyncExecutor(session);
        this.cassandraUtils = cassandraUtils;
        this.deleteStatement = session.prepare((RegularStatement)QueryBuilder.delete().from("subscription").where(QueryBuilder.eq((String)"user", (Object)QueryBuilder.bindMarker((String)"user"))).and(QueryBuilder.eq((String)"mailbox", (Object)QueryBuilder.bindMarker((String)"mailbox"))));
        this.selectStatement = session.prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"mailbox"}).from("subscription").where(QueryBuilder.eq((String)"user", (Object)QueryBuilder.bindMarker((String)"user"))));
        this.insertStatement = session.prepare((RegularStatement)QueryBuilder.insertInto((String)"subscription").value("user", (Object)QueryBuilder.bindMarker((String)"user")).value("mailbox", (Object)QueryBuilder.bindMarker((String)"mailbox")));
    }

    public synchronized void delete(Subscription subscription) {
        this.session.execute((Statement)this.deleteStatement.bind().setString("user", subscription.getUser().asString()).setString("mailbox", subscription.getMailbox()));
    }

    public List<Subscription> findSubscriptionsForUser(Username user) {
        return this.cassandraUtils.convertToStream(this.session.execute((Statement)this.selectStatement.bind().setString("user", user.asString()))).map(row -> new Subscription(user, row.getString("mailbox"))).collect(Collectors.toList());
    }

    public Flux<Subscription> findSubscriptionsForUserReactive(Username user) {
        return this.executor.executeRows((Statement)this.selectStatement.bind().setString("user", user.asString())).map(row -> new Subscription(user, row.getString("mailbox")));
    }

    public synchronized void save(Subscription subscription) {
        this.session.execute((Statement)this.insertStatement.bind().setString("user", subscription.getUser().asString()).setString("mailbox", subscription.getMailbox()));
    }
}

