/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import java.security.SecureRandom;
import java.time.Duration;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.mail.Flags;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.backends.cassandra.init.configuration.CassandraConfiguration;
import org.apache.james.backends.cassandra.init.configuration.CassandraConsistenciesConfiguration;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.mailbox.ApplicableFlagBuilder;
import org.apache.james.mailbox.FlagsBuilder;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.cassandra.ids.CassandraMessageId;
import org.apache.james.mailbox.cassandra.mail.AttachmentLoader;
import org.apache.james.mailbox.cassandra.mail.CassandraApplicableFlagDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraAttachmentMapper;
import org.apache.james.mailbox.cassandra.mail.CassandraDeletedMessageDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraFirstUnseenDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraIndexTableHandler;
import org.apache.james.mailbox.cassandra.mail.CassandraMailboxCounterDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMailboxRecentsDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageDAOV3;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageIdDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageIdToImapUidDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageMetadata;
import org.apache.james.mailbox.cassandra.mail.MessageRepresentation;
import org.apache.james.mailbox.cassandra.mail.task.RecomputeMailboxCountersService;
import org.apache.james.mailbox.cassandra.mail.utils.FlagsUpdateStageResult;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.ComposedMessageId;
import org.apache.james.mailbox.model.ComposedMessageIdWithMetaData;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxCounters;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageAttachmentMetadata;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.apache.james.mailbox.store.FlagsUpdateCalculator;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.ModSeqProvider;
import org.apache.james.mailbox.store.mail.UidProvider;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.mail.model.impl.SimpleMailboxMessage;
import org.apache.james.task.Task;
import org.apache.james.util.ReactorUtils;
import org.apache.james.util.streams.Limit;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.util.retry.Retry;

public class CassandraMessageMapper
implements MessageMapper {
    public static final Logger LOGGER = LoggerFactory.getLogger(CassandraMessageMapper.class);
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final int MAX_RETRY = 5;
    private static final Duration MIN_RETRY_BACKOFF = Duration.ofMillis(10L);
    private static final Duration MAX_RETRY_BACKOFF = Duration.ofMillis(1000L);
    private final ModSeqProvider modSeqProvider;
    private final UidProvider uidProvider;
    private final CassandraMessageDAO messageDAO;
    private final CassandraMessageDAOV3 messageDAOV3;
    private final CassandraMessageIdDAO messageIdDAO;
    private final CassandraMessageIdToImapUidDAO imapUidDAO;
    private final CassandraMailboxCounterDAO mailboxCounterDAO;
    private final CassandraMailboxRecentsDAO mailboxRecentDAO;
    private final CassandraApplicableFlagDAO applicableFlagDAO;
    private final CassandraIndexTableHandler indexTableHandler;
    private final CassandraFirstUnseenDAO firstUnseenDAO;
    private final AttachmentLoader attachmentLoader;
    private final CassandraDeletedMessageDAO deletedMessageDAO;
    private final BlobStore blobStore;
    private final CassandraConfiguration cassandraConfiguration;
    private final RecomputeMailboxCountersService recomputeMailboxCountersService;
    private final SecureRandom secureRandom;

    public CassandraMessageMapper(UidProvider uidProvider, ModSeqProvider modSeqProvider, CassandraAttachmentMapper attachmentMapper, CassandraMessageDAO messageDAO, CassandraMessageDAOV3 messageDAOV3, CassandraMessageIdDAO messageIdDAO, CassandraMessageIdToImapUidDAO imapUidDAO, CassandraMailboxCounterDAO mailboxCounterDAO, CassandraMailboxRecentsDAO mailboxRecentDAO, CassandraApplicableFlagDAO applicableFlagDAO, CassandraIndexTableHandler indexTableHandler, CassandraFirstUnseenDAO firstUnseenDAO, CassandraDeletedMessageDAO deletedMessageDAO, BlobStore blobStore, CassandraConfiguration cassandraConfiguration, RecomputeMailboxCountersService recomputeMailboxCountersService) {
        this.uidProvider = uidProvider;
        this.modSeqProvider = modSeqProvider;
        this.messageDAO = messageDAO;
        this.messageDAOV3 = messageDAOV3;
        this.messageIdDAO = messageIdDAO;
        this.imapUidDAO = imapUidDAO;
        this.mailboxCounterDAO = mailboxCounterDAO;
        this.mailboxRecentDAO = mailboxRecentDAO;
        this.indexTableHandler = indexTableHandler;
        this.firstUnseenDAO = firstUnseenDAO;
        this.attachmentLoader = new AttachmentLoader(attachmentMapper);
        this.applicableFlagDAO = applicableFlagDAO;
        this.deletedMessageDAO = deletedMessageDAO;
        this.blobStore = blobStore;
        this.cassandraConfiguration = cassandraConfiguration;
        this.recomputeMailboxCountersService = recomputeMailboxCountersService;
        this.secureRandom = new SecureRandom();
    }

    public Flux<MessageUid> listAllMessageUids(Mailbox mailbox) {
        CassandraId cassandraId = (CassandraId)mailbox.getMailboxId();
        return this.messageIdDAO.listUids(cassandraId);
    }

    public long countMessagesInMailbox(Mailbox mailbox) {
        return this.getMailboxCounters(mailbox).getCount();
    }

    public MailboxCounters getMailboxCounters(Mailbox mailbox) {
        return (MailboxCounters)this.getMailboxCountersReactive(mailbox).block();
    }

    public Mono<MailboxCounters> getMailboxCountersReactive(Mailbox mailbox) {
        CassandraId mailboxId = (CassandraId)mailbox.getMailboxId();
        return this.readMailboxCounters(mailboxId).flatMap(counters -> {
            if (!counters.isValid()) {
                return this.fixCounters(mailbox).then(this.readMailboxCounters(mailboxId));
            }
            return Mono.just((Object)counters);
        }).doOnNext(counters -> this.readRepair(mailbox, (MailboxCounters)counters));
    }

    public Mono<MailboxCounters> readMailboxCounters(CassandraId mailboxId) {
        return this.mailboxCounterDAO.retrieveMailboxCounters(mailboxId).defaultIfEmpty((Object)MailboxCounters.empty((MailboxId)mailboxId));
    }

    private void readRepair(Mailbox mailbox, MailboxCounters counters) {
        if (this.shouldReadRepair(counters)) {
            this.fixCounters(mailbox).subscribeOn(Schedulers.elastic()).subscribe();
        }
    }

    private Mono<Task.Result> fixCounters(Mailbox mailbox) {
        return this.recomputeMailboxCountersService.recomputeMailboxCounter(new RecomputeMailboxCountersService.Context(), mailbox, RecomputeMailboxCountersService.Options.trustMessageProjection());
    }

    private boolean shouldReadRepair(MailboxCounters counters) {
        boolean activated = this.cassandraConfiguration.getMailboxCountersReadRepairChanceMax() != 0.0f || this.cassandraConfiguration.getMailboxCountersReadRepairChanceOneHundred() != 0.0f;
        double ponderedReadRepairChance = (double)this.cassandraConfiguration.getMailboxCountersReadRepairChanceOneHundred() * (100.0 / (double)counters.getUnseen());
        return activated && (double)this.secureRandom.nextFloat() < Math.min((double)this.cassandraConfiguration.getMailboxCountersReadRepairChanceMax(), ponderedReadRepairChance);
    }

    public void delete(Mailbox mailbox, MailboxMessage message) {
        ComposedMessageIdWithMetaData metaData = message.getComposedMessageIdWithMetaData();
        this.deleteAndHandleIndexUpdates(metaData).block();
    }

    private Mono<Void> deleteAndHandleIndexUpdates(ComposedMessageIdWithMetaData composedMessageIdWithMetaData) {
        ComposedMessageId composedMessageId = composedMessageIdWithMetaData.getComposedMessageId();
        CassandraId mailboxId = (CassandraId)composedMessageId.getMailboxId();
        return this.delete(composedMessageIdWithMetaData).then(this.indexTableHandler.updateIndexOnDelete(composedMessageIdWithMetaData, mailboxId));
    }

    private Mono<Void> deleteAndHandleIndexUpdates(Collection<ComposedMessageIdWithMetaData> composedMessageIdWithMetaData) {
        if (composedMessageIdWithMetaData.isEmpty()) {
            return Mono.empty();
        }
        ComposedMessageId composedMessageId = composedMessageIdWithMetaData.iterator().next().getComposedMessageId();
        CassandraId mailboxId = (CassandraId)composedMessageId.getMailboxId();
        return Flux.fromIterable(composedMessageIdWithMetaData).concatMap(this::delete).then(this.indexTableHandler.updateIndexOnDeleteComposedId(mailboxId, composedMessageIdWithMetaData));
    }

    private Mono<Void> delete(ComposedMessageIdWithMetaData composedMessageIdWithMetaData) {
        ComposedMessageId composedMessageId = composedMessageIdWithMetaData.getComposedMessageId();
        CassandraMessageId messageId = (CassandraMessageId)composedMessageId.getMessageId();
        CassandraId mailboxId = (CassandraId)composedMessageId.getMailboxId();
        MessageUid uid = composedMessageId.getUid();
        return Flux.merge((Publisher[])new Publisher[]{this.imapUidDAO.delete(messageId, mailboxId), this.messageIdDAO.delete(mailboxId, uid)}).then();
    }

    public Iterator<MailboxMessage> findInMailbox(Mailbox mailbox, MessageRange messageRange, MessageMapper.FetchType ftype, int max) {
        return this.findInMailboxReactive(mailbox, messageRange, ftype, max).toIterable().iterator();
    }

    public Flux<ComposedMessageIdWithMetaData> listMessagesMetadata(Mailbox mailbox, MessageRange set) {
        CassandraId mailboxId = (CassandraId)mailbox.getMailboxId();
        return this.messageIdDAO.retrieveMessages(mailboxId, set, Limit.unlimited()).map(CassandraMessageMetadata::getComposedMessageId);
    }

    public Flux<MailboxMessage> findInMailboxReactive(Mailbox mailbox, MessageRange messageRange, MessageMapper.FetchType ftype, int limitAsInt) {
        CassandraId mailboxId = (CassandraId)mailbox.getMailboxId();
        Limit limit = Limit.from((int)limitAsInt);
        return limit.applyOnFlux(this.messageIdDAO.retrieveMessages(mailboxId, messageRange, limit)).flatMap(metadata -> this.toMailboxMessage((CassandraMessageMetadata)metadata, ftype), this.cassandraConfiguration.getMessageReadChunkSize()).sort(Comparator.comparing(MailboxMessage::getUid));
    }

    private Mono<MailboxMessage> toMailboxMessage(CassandraMessageMetadata metadata, MessageMapper.FetchType fetchType) {
        if (fetchType == MessageMapper.FetchType.METADATA && metadata.isComplete()) {
            return Mono.just((Object)metadata.asMailboxMessage(EMPTY_BYTE_ARRAY));
        }
        if (fetchType == MessageMapper.FetchType.HEADERS && metadata.isComplete()) {
            return Mono.from((Publisher)this.blobStore.readBytes(this.blobStore.getDefaultBucketName(), metadata.getHeaderContent().get(), BlobStore.StoragePolicy.SIZE_BASED)).map(metadata::asMailboxMessage);
        }
        return this.messageDAOV3.retrieveMessage(metadata.getComposedMessageId(), fetchType).switchIfEmpty(Mono.defer(() -> this.messageDAO.retrieveMessage(metadata.getComposedMessageId(), fetchType))).map(messageRepresentation -> Pair.of((Object)metadata.getComposedMessageId(), (Object)messageRepresentation)).flatMap(messageRepresentation -> this.attachmentLoader.addAttachmentToMessage((Pair<ComposedMessageIdWithMetaData, MessageRepresentation>)messageRepresentation, fetchType));
    }

    public List<MessageUid> findRecentMessageUidsInMailbox(Mailbox mailbox) {
        CassandraId mailboxId = (CassandraId)mailbox.getMailboxId();
        return (List)this.mailboxRecentDAO.getRecentMessageUidsInMailbox(mailboxId).collectList().block();
    }

    public MessageUid findFirstUnseenMessageUid(Mailbox mailbox) {
        CassandraId mailboxId = (CassandraId)mailbox.getMailboxId();
        return this.firstUnseenDAO.retrieveFirstUnread(mailboxId).blockOptional().orElse(null);
    }

    public List<MessageUid> retrieveMessagesMarkedForDeletion(Mailbox mailbox, MessageRange messageRange) {
        CassandraId mailboxId = (CassandraId)mailbox.getMailboxId();
        return (List)this.deletedMessageDAO.retrieveDeletedMessage(mailboxId, messageRange).collect(ImmutableList.toImmutableList()).block();
    }

    public Map<MessageUid, MessageMetaData> deleteMessages(Mailbox mailbox, List<MessageUid> uids) {
        CassandraId mailboxId = (CassandraId)mailbox.getMailboxId();
        return (Map)Flux.fromIterable((Iterable)MessageRange.toRanges(uids)).concatMap(range -> this.messageIdDAO.retrieveMessages(mailboxId, (MessageRange)range, Limit.unlimited())).map(CassandraMessageMetadata::getComposedMessageId).flatMap(this::expungeOne, this.cassandraConfiguration.getExpungeChunkSize()).collect(ImmutableMap.toImmutableMap(MailboxMessage::getUid, MailboxMessage::metaData)).flatMap(messageMap -> this.indexTableHandler.updateIndexOnDelete(mailboxId, (Collection<MessageMetaData>)messageMap.values()).thenReturn(messageMap)).subscribeOn(Schedulers.elastic()).block();
    }

    private Mono<SimpleMailboxMessage> expungeOne(ComposedMessageIdWithMetaData metaData) {
        return this.delete(metaData).then(this.messageDAOV3.retrieveMessage(metaData, MessageMapper.FetchType.METADATA).switchIfEmpty(Mono.defer(() -> this.messageDAO.retrieveMessage(metaData, MessageMapper.FetchType.METADATA)))).map(pair -> pair.toMailboxMessage(metaData, (List<MessageAttachmentMetadata>)ImmutableList.of()));
    }

    public MessageMetaData move(Mailbox destinationMailbox, MailboxMessage original) throws MailboxException {
        ComposedMessageIdWithMetaData composedMessageIdWithMetaData = original.getComposedMessageIdWithMetaData();
        MessageMetaData messageMetaData = this.copy(destinationMailbox, original);
        this.deleteAndHandleIndexUpdates(composedMessageIdWithMetaData).block();
        return messageMetaData;
    }

    public List<MessageMetaData> move(Mailbox mailbox, List<MailboxMessage> original) throws MailboxException {
        List beforeCopy = (List)original.stream().map(MailboxMessage::getComposedMessageIdWithMetaData).collect(ImmutableList.toImmutableList());
        List<MessageMetaData> messageMetaData = this.copy(mailbox, original);
        this.deleteAndHandleIndexUpdates(beforeCopy).block();
        return messageMetaData;
    }

    public ModSeq getHighestModSeq(Mailbox mailbox) throws MailboxException {
        return this.modSeqProvider.highestModSeq(mailbox);
    }

    public MessageMetaData add(Mailbox mailbox, MailboxMessage message) throws MailboxException {
        return this.block(this.addReactive(mailbox, message));
    }

    public Mono<MessageMetaData> addReactive(Mailbox mailbox, MailboxMessage message) {
        CassandraId mailboxId = (CassandraId)mailbox.getMailboxId();
        return this.addUidAndModseq(message, mailboxId).flatMap((Function)Throwing.function(messageWithUidAndModSeq -> this.save(mailbox, (MailboxMessage)messageWithUidAndModSeq).thenReturn(messageWithUidAndModSeq))).map(MailboxMessage::metaData);
    }

    private Mono<MailboxMessage> addUidAndModseq(MailboxMessage message, CassandraId mailboxId) {
        Mono messageUidMono = this.uidProvider.nextUidReactive((MailboxId)mailboxId).switchIfEmpty(Mono.error(() -> new MailboxException("Can not find a UID to save " + message.getMessageId() + " in " + mailboxId)));
        Mono nextModSeqMono = this.modSeqProvider.nextModSeqReactive((MailboxId)mailboxId).switchIfEmpty(Mono.error(() -> new MailboxException("Can not find a MODSEQ to save " + message.getMessageId() + " in " + mailboxId)));
        return Mono.zip((Mono)messageUidMono, (Mono)nextModSeqMono).doOnNext(tuple -> {
            message.setUid((MessageUid)tuple.getT1());
            message.setModSeq((ModSeq)tuple.getT2());
        }).thenReturn((Object)message);
    }

    private <T> T block(Mono<T> mono) throws MailboxException {
        try {
            return (T)mono.block();
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof MailboxException) {
                throw (MailboxException)e.getCause();
            }
            throw e;
        }
    }

    public Iterator<UpdatedFlags> updateFlags(Mailbox mailbox, FlagsUpdateCalculator flagUpdateCalculator, MessageRange range) {
        CassandraId mailboxId = (CassandraId)mailbox.getMailboxId();
        Flux toBeUpdated = this.messageIdDAO.retrieveMessages(mailboxId, range, Limit.unlimited()).map(CassandraMessageMetadata::getComposedMessageId);
        return this.updateFlags(flagUpdateCalculator, mailboxId, (Flux<ComposedMessageIdWithMetaData>)toBeUpdated).iterator();
    }

    private List<UpdatedFlags> updateFlags(FlagsUpdateCalculator flagUpdateCalculator, CassandraId mailboxId, Flux<ComposedMessageIdWithMetaData> toBeUpdated) {
        FlagsUpdateStageResult firstResult = (FlagsUpdateStageResult)this.runUpdateStage(mailboxId, toBeUpdated, flagUpdateCalculator).block();
        FlagsUpdateStageResult finalResult = this.handleUpdatesStagedRetry(mailboxId, flagUpdateCalculator, firstResult);
        if (finalResult.containsFailedResults()) {
            LOGGER.error("Can not update following UIDs {} for mailbox {}", finalResult.getFailed(), (Object)mailboxId.asUuid());
        }
        return finalResult.getSucceeded();
    }

    public List<UpdatedFlags> resetRecent(Mailbox mailbox) {
        CassandraId mailboxId = (CassandraId)mailbox.getMailboxId();
        Flux toBeUpdated = this.mailboxRecentDAO.getRecentMessageUidsInMailbox(mailboxId).collectList().flatMapIterable(MessageRange::toRanges).concatMap(range -> this.messageIdDAO.retrieveMessages(mailboxId, (MessageRange)range, Limit.unlimited())).map(CassandraMessageMetadata::getComposedMessageId).filter(message -> message.getFlags().contains(Flags.Flag.RECENT));
        FlagsUpdateCalculator calculator = new FlagsUpdateCalculator(new Flags(Flags.Flag.RECENT), MessageManager.FlagsUpdateMode.REMOVE);
        return this.updateFlags(calculator, mailboxId, (Flux<ComposedMessageIdWithMetaData>)toBeUpdated);
    }

    private FlagsUpdateStageResult handleUpdatesStagedRetry(CassandraId mailboxId, FlagsUpdateCalculator flagUpdateCalculator, FlagsUpdateStageResult firstResult) {
        FlagsUpdateStageResult globalResult = firstResult;
        for (int retryCount = 0; retryCount < this.cassandraConfiguration.getFlagsUpdateMessageMaxRetry() && globalResult.containsFailedResults(); ++retryCount) {
            FlagsUpdateStageResult stageResult = (FlagsUpdateStageResult)this.retryUpdatesStage(mailboxId, flagUpdateCalculator, globalResult.getFailed()).block();
            globalResult = globalResult.keepSucceded().merge(stageResult);
        }
        return globalResult;
    }

    private Mono<FlagsUpdateStageResult> retryUpdatesStage(CassandraId mailboxId, FlagsUpdateCalculator flagsUpdateCalculator, List<ComposedMessageId> failed) {
        if (!failed.isEmpty()) {
            Flux toUpdate = Flux.fromIterable(failed).flatMap(ids -> this.imapUidDAO.retrieve((CassandraMessageId)ids.getMessageId(), Optional.of((CassandraId)ids.getMailboxId()), this.chooseReadConsistencyUponWrites()).map(CassandraMessageMetadata::getComposedMessageId), 16);
            return this.runUpdateStage(mailboxId, (Flux<ComposedMessageIdWithMetaData>)toUpdate, flagsUpdateCalculator);
        }
        return Mono.empty();
    }

    private CassandraConsistenciesConfiguration.ConsistencyChoice chooseReadConsistencyUponWrites() {
        if (this.cassandraConfiguration.isMessageWriteStrongConsistency()) {
            return CassandraConsistenciesConfiguration.ConsistencyChoice.STRONG;
        }
        return CassandraConsistenciesConfiguration.ConsistencyChoice.WEAK;
    }

    private Mono<FlagsUpdateStageResult> runUpdateStage(CassandraId mailboxId, Flux<ComposedMessageIdWithMetaData> toBeUpdated, FlagsUpdateCalculator flagsUpdateCalculator) {
        return this.computeNewModSeq(mailboxId).flatMapMany(newModSeq -> toBeUpdated.concatMap(metadata -> this.tryFlagsUpdate(flagsUpdateCalculator, (ModSeq)newModSeq, (ComposedMessageIdWithMetaData)metadata))).reduce((Object)FlagsUpdateStageResult.none(), FlagsUpdateStageResult::merge).flatMap(result -> this.updateIndexesForUpdatesResult(mailboxId, (FlagsUpdateStageResult)result));
    }

    private Mono<ModSeq> computeNewModSeq(CassandraId mailboxId) {
        return this.modSeqProvider.nextModSeqReactive((MailboxId)mailboxId).switchIfEmpty(ReactorUtils.executeAndEmpty(() -> new RuntimeException("ModSeq generation failed for mailbox " + mailboxId.asUuid())));
    }

    private Mono<FlagsUpdateStageResult> updateIndexesForUpdatesResult(CassandraId mailboxId, FlagsUpdateStageResult result) {
        return this.indexTableHandler.updateIndexOnFlagsUpdate(mailboxId, result.getSucceeded()).onErrorResume(e -> {
            LOGGER.error("Could not update flag indexes for mailboxId {}. This will lead to inconsistencies across Cassandra tables", (Object)mailboxId, e);
            return Mono.empty();
        }).thenReturn((Object)result);
    }

    public MessageMetaData copy(Mailbox mailbox, MailboxMessage original) throws MailboxException {
        original.setFlags(new FlagsBuilder().add(new Flags[]{original.createFlags()}).add(new Flags.Flag[]{Flags.Flag.RECENT}).build());
        return this.setInMailbox(mailbox, original);
    }

    public List<MessageMetaData> copy(Mailbox mailbox, List<MailboxMessage> originals) throws MailboxException {
        return this.setInMailbox(mailbox, (List)originals.stream().map(original -> {
            original.setFlags(new FlagsBuilder().add(new Flags[]{original.createFlags()}).add(new Flags.Flag[]{Flags.Flag.RECENT}).build());
            return original;
        }).collect(ImmutableList.toImmutableList()));
    }

    public Optional<MessageUid> getLastUid(Mailbox mailbox) throws MailboxException {
        return this.uidProvider.lastUid(mailbox);
    }

    public Flags getApplicableFlag(Mailbox mailbox) {
        return ApplicableFlagBuilder.builder().add(new Flags[]{(Flags)this.applicableFlagDAO.retrieveApplicableFlag((CassandraId)mailbox.getMailboxId()).defaultIfEmpty((Object)new Flags()).block()}).build();
    }

    private MessageMetaData setInMailbox(Mailbox mailbox, MailboxMessage message) throws MailboxException {
        CassandraId mailboxId = (CassandraId)mailbox.getMailboxId();
        return (MessageMetaData)this.block(this.addUidAndModseq(message, mailboxId).flatMap(messageWithUidAndModseq -> this.insertMetadata((MailboxMessage)messageWithUidAndModseq, mailboxId, CassandraMessageMetadata.from(messageWithUidAndModseq).withMailboxId(mailboxId)).thenReturn(messageWithUidAndModseq)).map(MailboxMessage::metaData));
    }

    private List<MessageMetaData> setInMailbox(Mailbox mailbox, List<MailboxMessage> messages) throws MailboxException {
        CassandraId mailboxId = (CassandraId)mailbox.getMailboxId();
        Mono uids = this.uidProvider.nextUids((MailboxId)mailboxId, messages.size());
        Mono nextModSeq = this.modSeqProvider.nextModSeqReactive((MailboxId)mailboxId);
        Mono messagesWithUidAndModSeq = nextModSeq.flatMap(modSeq -> uids.map(uidList -> Pair.of((Object)uidList, (Object)modSeq))).map(pair -> ((List)pair.getKey()).stream().map(uid -> Pair.of((Object)uid, (Object)((ModSeq)pair.getRight())))).map(uidsAndModSeq -> (List)Streams.zip((Stream)uidsAndModSeq, messages.stream(), (uidAndModseq, aMessage) -> {
            aMessage.setUid((MessageUid)uidAndModseq.getKey());
            aMessage.setModSeq((ModSeq)uidAndModseq.getValue());
            return aMessage;
        }).collect(ImmutableList.toImmutableList()));
        return (List)this.block(messagesWithUidAndModSeq.flatMap(list -> this.insertIds((Collection<MailboxMessage>)list, mailboxId).thenReturn(list)).map(list -> (ImmutableList)list.stream().map(MailboxMessage::metaData).collect(ImmutableList.toImmutableList())));
    }

    private Mono<Void> save(Mailbox mailbox, MailboxMessage message) throws MailboxException {
        CassandraId mailboxId = (CassandraId)mailbox.getMailboxId();
        return this.messageDAOV3.save(message).flatMap(headerAndBodyBlobIds -> this.insertIds(message, mailboxId, (BlobId)headerAndBodyBlobIds.getT1()));
    }

    private Mono<Void> insertIds(MailboxMessage message, CassandraId mailboxId, BlobId headerBlobId) {
        CassandraMessageMetadata metadata = CassandraMessageMetadata.from(message, headerBlobId);
        return this.insertMetadata(message, mailboxId, metadata);
    }

    private Mono<Void> insertMetadata(MailboxMessage message, CassandraId mailboxId, CassandraMessageMetadata metadata) {
        return this.imapUidDAO.insert(metadata).then(Flux.merge((Publisher[])new Publisher[]{this.messageIdDAO.insert(metadata).retryWhen((Retry)Retry.backoff((long)5L, (Duration)MIN_RETRY_BACKOFF).maxBackoff(MAX_RETRY_BACKOFF)), this.indexTableHandler.updateIndexOnAdd(message, mailboxId)}).then());
    }

    private CassandraMessageMetadata computeId(MailboxMessage message, CassandraId mailboxId) {
        return CassandraMessageMetadata.from(message).withMailboxId(mailboxId);
    }

    private Mono<Void> insertIds(Collection<MailboxMessage> messages, CassandraId mailboxId) {
        int lowConcurrency = 4;
        return Flux.fromIterable(messages).map(message -> this.computeId((MailboxMessage)message, mailboxId)).concatMap(id -> this.imapUidDAO.insert((CassandraMessageMetadata)id).thenReturn(id)).flatMap(id -> this.messageIdDAO.insert((CassandraMessageMetadata)id).retryWhen((Retry)Retry.backoff((long)5L, (Duration)MIN_RETRY_BACKOFF).maxBackoff(MAX_RETRY_BACKOFF)), lowConcurrency).then(this.indexTableHandler.updateIndexOnAdd(messages, mailboxId));
    }

    private Mono<FlagsUpdateStageResult> tryFlagsUpdate(FlagsUpdateCalculator flagUpdateCalculator, ModSeq newModSeq, ComposedMessageIdWithMetaData oldMetaData) {
        Flags newFlags;
        Flags oldFlags = oldMetaData.getFlags();
        if (this.identicalFlags(oldFlags, newFlags = flagUpdateCalculator.buildNewFlags(oldFlags))) {
            return Mono.just((Object)FlagsUpdateStageResult.success(UpdatedFlags.builder().uid(oldMetaData.getComposedMessageId().getUid()).messageId(oldMetaData.getComposedMessageId().getMessageId()).modSeq(oldMetaData.getModSeq()).oldFlags(oldFlags).newFlags(newFlags).build()));
        }
        return this.updateFlags(oldMetaData, newFlags, newModSeq).map(success -> {
            if (success.booleanValue()) {
                return FlagsUpdateStageResult.success(UpdatedFlags.builder().uid(oldMetaData.getComposedMessageId().getUid()).messageId(oldMetaData.getComposedMessageId().getMessageId()).modSeq(newModSeq).oldFlags(oldFlags).newFlags(newFlags).build());
            }
            return FlagsUpdateStageResult.fail(oldMetaData.getComposedMessageId());
        });
    }

    private boolean identicalFlags(Flags oldFlags, Flags newFlags) {
        return oldFlags.equals((Object)newFlags);
    }

    private Mono<Boolean> updateFlags(ComposedMessageIdWithMetaData oldMetadata, Flags newFlags, ModSeq newModSeq) {
        ComposedMessageIdWithMetaData newMetadata = ComposedMessageIdWithMetaData.builder().composedMessageId(oldMetadata.getComposedMessageId()).modSeq(newModSeq).flags(newFlags).threadId(oldMetadata.getThreadId()).build();
        ComposedMessageId composedMessageId = newMetadata.getComposedMessageId();
        ModSeq previousModseq = oldMetadata.getModSeq();
        UpdatedFlags updatedFlags = UpdatedFlags.builder().messageId(composedMessageId.getMessageId()).modSeq(newMetadata.getModSeq()).oldFlags(oldMetadata.getFlags()).newFlags(newMetadata.getFlags()).uid(composedMessageId.getUid()).build();
        return this.imapUidDAO.updateMetadata(composedMessageId, updatedFlags, previousModseq).flatMap(success -> {
            if (success.booleanValue()) {
                return this.messageIdDAO.updateMetadata(composedMessageId, updatedFlags).thenReturn((Object)true);
            }
            return Mono.just((Object)false);
        });
    }
}

