/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.james.jmap.draft.methods.Method;
import org.apache.james.jmap.draft.model.Filter;
import org.apache.james.jmap.draft.model.Number;
import org.apache.james.mailbox.model.MessageId;

public class GetMessageListResponse
implements Method.Response {
    private final String accountId;
    private final Filter filter;
    private final List<String> sort;
    private final boolean collapseThreads;
    private final String state;
    private final boolean canCalculateUpdates;
    private final Number position;
    private final Number total;
    private final List<String> threadIds;
    private final List<MessageId> messageIds;

    public static Builder builder() {
        return new Builder();
    }

    @VisibleForTesting
    GetMessageListResponse(String accountId, Filter filter, List<String> sort, boolean collapseThreads, String state, boolean canCalculateUpdates, Number position, Number total, List<String> threadIds, List<MessageId> messageIds) {
        this.accountId = accountId;
        this.filter = filter;
        this.sort = sort;
        this.collapseThreads = collapseThreads;
        this.state = state;
        this.canCalculateUpdates = canCalculateUpdates;
        this.position = position;
        this.total = total;
        this.threadIds = threadIds;
        this.messageIds = messageIds;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public List<String> getSort() {
        return this.sort;
    }

    public boolean isCollapseThreads() {
        return this.collapseThreads;
    }

    public String getState() {
        return this.state;
    }

    public boolean isCanCalculateUpdates() {
        return this.canCalculateUpdates;
    }

    public Number getPosition() {
        return this.position;
    }

    public Number getTotal() {
        return this.total;
    }

    public List<String> getThreadIds() {
        return this.threadIds;
    }

    public List<MessageId> getMessageIds() {
        return this.messageIds;
    }

    public static class Builder {
        private String accountId;
        private Filter filter;
        private final ImmutableList.Builder<String> sort = ImmutableList.builder();
        private boolean collapseThreads;
        private String state;
        private boolean canCalculateUpdates;
        private Optional<Number> position;
        private Optional<Number> total;
        private final ImmutableList.Builder<String> threadIds = ImmutableList.builder();
        private final ImmutableList.Builder<MessageId> messageIds = ImmutableList.builder();

        private Builder() {
            this.position = Optional.empty();
            this.total = Optional.empty();
        }

        public Builder accountId(String accountId) {
            throw new NotImplementedException("not implemented");
        }

        public Builder filter(Filter filter) {
            this.filter = filter;
            return this;
        }

        public Builder sort(List<String> sort) {
            this.sort.addAll(sort);
            return this;
        }

        public Builder collapseThreads(boolean collapseThreads) {
            throw new NotImplementedException("not implemented");
        }

        public Builder state(String state) {
            throw new NotImplementedException("not implemented");
        }

        public Builder canCalculateUpdates(boolean canCalculateUpdates) {
            throw new NotImplementedException("not implemented");
        }

        public Builder position(int position) {
            throw new NotImplementedException("not implemented");
        }

        public Builder total(int total) {
            throw new NotImplementedException("not implemented");
        }

        public Builder threadIds(List<String> threadIds) {
            throw new NotImplementedException("not implemented");
        }

        public Builder messageId(MessageId messageId) {
            this.messageIds.add((Object)messageId);
            return this;
        }

        public Builder messageIds(List<MessageId> messageIds) {
            this.messageIds.addAll(messageIds);
            return this;
        }

        public GetMessageListResponse build() {
            return new GetMessageListResponse(this.accountId, this.filter, (List<String>)this.sort.build(), this.collapseThreads, this.state, this.canCalculateUpdates, this.position.orElse(Number.ZERO), this.total.orElse(Number.ZERO), (List<String>)this.threadIds.build(), (List<MessageId>)this.messageIds.build());
        }
    }
}

