/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.mail;

import eu.timepit.refined.api.Refined;
import eu.timepit.refined.boolean;
import eu.timepit.refined.collection;
import eu.timepit.refined.string;
import java.io.Serializable;
import org.apache.james.core.Username;
import org.apache.james.jmap.core.CapabilityIdentifier$;
import org.apache.james.jmap.json.MailboxSerializer;
import org.apache.james.jmap.mail.InvalidPropertyException;
import org.apache.james.jmap.mail.InvalidUpdateException;
import org.apache.james.jmap.mail.MailboxPatchObject$;
import org.apache.james.jmap.mail.PatchUpdateValidationException;
import org.apache.james.jmap.mail.Rfc4314Rights;
import org.apache.james.jmap.mail.SharedWithPartialUpdate;
import org.apache.james.jmap.mail.Update;
import play.api.libs.json.JsError;
import play.api.libs.json.JsResult;
import play.api.libs.json.JsSuccess;
import play.api.libs.json.JsValue;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class SharedWithPartialUpdate$
implements Serializable {
    public static final SharedWithPartialUpdate$ MODULE$ = new SharedWithPartialUpdate$();

    public Either<PatchUpdateValidationException, Update> parse(MailboxSerializer serializer, Set<Refined<String, string.Uri>> capabilities, String property, JsValue newValue) {
        if (capabilities.contains((Object)new Refined((Object)CapabilityIdentifier$.MODULE$.JAMES_SHARES()))) {
            return this.parseUsername(property).flatMap((Function1 & Serializable)username -> MODULE$.parseRights(newValue, property, serializer).map((Function1 & Serializable)rights -> new SharedWithPartialUpdate((Username)username, (Rfc4314Rights)rights)));
        }
        return MailboxPatchObject$.MODULE$.notFound(property);
    }

    public Either<PatchUpdateValidationException, Username> parseUsername(String property) {
        Right right;
        try {
            right = package$.MODULE$.Right().apply((Object)Username.of((String)property.substring(MailboxPatchObject$.MODULE$.sharedWithPrefix().length())));
        }
        catch (Exception e) {
            right = package$.MODULE$.Left().apply((Object)new InvalidPropertyException(property, e.getMessage()));
        }
        return right;
    }

    public Either<PatchUpdateValidationException, Rfc4314Rights> parseRights(JsValue newValue, String property, MailboxSerializer serializer) {
        JsResult<Rfc4314Rights> jsResult = serializer.deserializeRfc4314Rights(newValue);
        if (jsResult instanceof JsSuccess) {
            JsSuccess jsSuccess = (JsSuccess)jsResult;
            Rfc4314Rights rights = (Rfc4314Rights)jsSuccess.value();
            return package$.MODULE$.Right().apply((Object)rights);
        }
        if (jsResult instanceof JsError) {
            JsError jsError = (JsError)jsResult;
            Seq errors = jsError.errors();
            Either refinedKey = eu.timepit.refined.package$.MODULE$.refineV().apply((Object)property, boolean.Not$.MODULE$.notValidate(collection.Empty$.MODULE$.emptyValidate((Function1 & Serializable)s -> Predef$.MODULE$.wrapString(s))));
            return (Either)refinedKey.fold((Function1 & Serializable)refinedError -> package$.MODULE$.Left().apply((Object)new InvalidPropertyException(property, new StringBuilder(46).append("Invalid property specified in a patch object: ").append((String)refinedError).toString())), (Function1 & Serializable)refinedProperty -> SharedWithPartialUpdate$.$anonfun$parseRights$3(errors, (String)((Refined)refinedProperty).value()));
        }
        throw new MatchError(jsResult);
    }

    public SharedWithPartialUpdate apply(Username username, Rfc4314Rights rights) {
        return new SharedWithPartialUpdate(username, rights);
    }

    public Option<Tuple2<Username, Rfc4314Rights>> unapply(SharedWithPartialUpdate x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple2((Object)x$0.username(), (Object)x$0.rights()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SharedWithPartialUpdate$.class);
    }

    public static final /* synthetic */ Left $anonfun$parseRights$3(Seq errors$1, String refinedProperty) {
        return package$.MODULE$.Left().apply((Object)new InvalidUpdateException(refinedProperty, new StringBuilder(55).append("Specified value do not match the expected JSON format: ").append(errors$1).toString()));
    }

    private SharedWithPartialUpdate$() {
    }
}

