/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.aes;

import com.google.crypto.tink.subtle.Hex;
import java.util.Arrays;
import java.util.Objects;
import org.apache.james.blob.aes.CryptoConfigBuilder;

public class CryptoConfig {
    private final String salt;
    private final char[] password;

    public static CryptoConfigBuilder builder() {
        return new CryptoConfigBuilder();
    }

    public CryptoConfig(String salt, char[] password) {
        this.salt = salt;
        this.password = password;
    }

    public byte[] salt() {
        return Hex.decode((String)this.salt);
    }

    public char[] password() {
        return this.password;
    }

    public final boolean equals(Object o) {
        if (o instanceof CryptoConfig) {
            CryptoConfig that = (CryptoConfig)o;
            return Objects.equals(this.salt, that.salt) && Arrays.equals(this.password, that.password);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.salt, this.password);
    }
}

