/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james;

import java.time.ZonedDateTime;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.vacation.api.AccountId;
import org.apache.james.vacation.api.NotificationRegistry;
import org.apache.james.vacation.api.RecipientId;
import org.apache.james.vacation.api.Vacation;
import org.apache.james.vacation.api.VacationPatch;
import org.apache.james.vacation.api.VacationRepository;
import org.apache.james.vacation.api.VacationService;
import reactor.core.publisher.Mono;

public class DefaultVacationService
implements VacationService {
    private final VacationRepository vacationRepository;
    private final NotificationRegistry notificationRegistry;

    @Inject
    public DefaultVacationService(VacationRepository vacationRepository, NotificationRegistry notificationRegistry) {
        this.vacationRepository = vacationRepository;
        this.notificationRegistry = notificationRegistry;
    }

    public Mono<Void> modifyVacation(AccountId accountId, VacationPatch vacationPatch) {
        return this.vacationRepository.modifyVacation(accountId, vacationPatch).then(this.notificationRegistry.flush(accountId));
    }

    public Mono<Vacation> retrieveVacation(AccountId accountId) {
        return this.vacationRepository.retrieveVacation(accountId);
    }

    public Mono<Void> registerNotification(AccountId accountId, RecipientId recipientId, Optional<ZonedDateTime> expiryDate) {
        return this.notificationRegistry.register(accountId, recipientId, expiryDate);
    }

    public Mono<Boolean> isNotificationRegistered(AccountId accountId, RecipientId recipientId) {
        return this.notificationRegistry.isRegistered(accountId, recipientId);
    }

    public Mono<Void> flushNotifications(AccountId accountId) {
        return this.notificationRegistry.flush(accountId);
    }
}

