/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james;

import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.apache.james.UserEntityValidator;
import org.apache.james.core.Username;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;

public class DefaultUserEntityValidator
implements UserEntityValidator {
    private final UsersRepository usersRepository;

    @Inject
    public DefaultUserEntityValidator(UsersRepository usersRepository) {
        this.usersRepository = usersRepository;
    }

    @Override
    public Optional<UserEntityValidator.ValidationFailure> canCreate(Username username, Set<UserEntityValidator.EntityType> ignoredTypes) throws UsersRepositoryException {
        if (ignoredTypes.contains(UserEntityValidator.EntityType.USER)) {
            return Optional.empty();
        }
        if (this.usersRepository.contains(username)) {
            return Optional.of(new UserEntityValidator.ValidationFailure("'" + username.asString() + "' user already exist"));
        }
        return Optional.empty();
    }
}

