/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.protocols.xml.internal.unmarshall;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsResponse;
import software.amazon.awssdk.awscore.AwsResponseMetadata;
import software.amazon.awssdk.awscore.DefaultAwsResponseMetadata;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.http.SdkHttpFullResponse;
import software.amazon.awssdk.http.SdkHttpResponse;
import software.amazon.awssdk.utils.http.SdkHttpUtils;

@SdkInternalApi
public final class AwsXmlResponseHandler<T>
implements HttpResponseHandler<T> {
    private final HttpResponseHandler<T> delegate;

    public AwsXmlResponseHandler(HttpResponseHandler<T> responseHandler) {
        this.delegate = responseHandler;
    }

    public T handle(SdkHttpFullResponse response, ExecutionAttributes executionAttributes) throws Exception {
        Object result = this.delegate.handle(response, executionAttributes);
        if (result instanceof AwsResponse) {
            AwsResponseMetadata responseMetadata = this.generateResponseMetadata((SdkHttpResponse)response);
            return (T)((AwsResponse)result).toBuilder().responseMetadata(responseMetadata).build();
        }
        return (T)result;
    }

    private AwsResponseMetadata generateResponseMetadata(SdkHttpResponse response) {
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("AWS_REQUEST_ID", SdkHttpUtils.firstMatchingHeaderFromCollection((Map)response.headers(), (Collection)X_AMZN_REQUEST_ID_HEADERS).orElse(null));
        response.headers().forEach((key, value) -> {
            String cfr_ignored_0 = (String)metadata.put((String)key, value.get(0));
        });
        return DefaultAwsResponseMetadata.create(metadata);
    }

    public boolean needsConnectionLeftOpen() {
        return this.delegate.needsConnectionLeftOpen();
    }
}

