/*
 * Decompiled with CFR 0.152.
 */
package com.linagora.elasticsearch.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import java.util.Date;

public class JsonMetrics {

    public static class JsonTimer
    extends JsonMetric<Timer> {
        private static final String TYPE = "timer";

        public JsonTimer(String name, long timestamp, Timer value) {
            super(name, timestamp, value);
        }

        @Override
        public String type() {
            return TYPE;
        }
    }

    public static class JsonMeter
    extends JsonMetric<Meter> {
        private static final String TYPE = "meter";

        public JsonMeter(String name, long timestamp, Meter value) {
            super(name, timestamp, value);
        }

        @Override
        public String type() {
            return TYPE;
        }
    }

    public static class JsonHistogram
    extends JsonMetric<Histogram> {
        private static final String TYPE = "histogram";

        public JsonHistogram(String name, long timestamp, Histogram value) {
            super(name, timestamp, value);
        }

        @Override
        public String type() {
            return TYPE;
        }
    }

    public static class JsonCounter
    extends JsonMetric<Counter> {
        private static final String TYPE = "counter";

        public JsonCounter(String name, long timestamp, Counter value) {
            super(name, timestamp, value);
        }

        @Override
        public String type() {
            return TYPE;
        }
    }

    public static class JsonGauge
    extends JsonMetric<Gauge<?>> {
        private static final String TYPE = "gauge";

        public JsonGauge(String name, long timestamp, Gauge<?> value) {
            super(name, timestamp, value);
        }

        @Override
        public String type() {
            return TYPE;
        }
    }

    public static abstract class JsonMetric<T> {
        private final String name;
        private long timestamp;
        private final T value;

        public JsonMetric(String name, long timestamp, T value) {
            this.name = name;
            this.timestamp = timestamp;
            this.value = value;
        }

        public String name() {
            return this.name;
        }

        public long timestamp() {
            return this.timestamp;
        }

        public Date timestampAsDate() {
            return new Date(this.timestamp * 1000L);
        }

        public T value() {
            return this.value;
        }

        public String toString() {
            return String.format("%s %s %s", this.type(), this.name, this.timestamp);
        }

        public abstract String type();
    }
}

