/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq.view.cassandra;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.queue.rabbitmq.EnqueueId;
import org.apache.james.queue.rabbitmq.MailQueueName;
import org.apache.james.util.FunctionalUtils;
import reactor.core.publisher.Mono;

public class DeletedMailsDAO {
    private final CassandraAsyncExecutor executor;
    private final PreparedStatement selectOne;
    private final PreparedStatement insertOne;
    private final PreparedStatement deleteOne;

    @Inject
    DeletedMailsDAO(Session session) {
        this.executor = new CassandraAsyncExecutor(session);
        this.selectOne = this.prepareSelectExist(session);
        this.insertOne = this.prepareInsert(session);
        this.deleteOne = this.prepareDeleteOne(session);
    }

    private PreparedStatement prepareInsert(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.insertInto((String)"deletedMailsV2").value("queueName", (Object)QueryBuilder.bindMarker((String)"queueName")).value("enqueueId", (Object)QueryBuilder.bindMarker((String)"enqueueId")));
    }

    private PreparedStatement prepareSelectExist(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select().from("deletedMailsV2").where(QueryBuilder.eq((String)"queueName", (Object)QueryBuilder.bindMarker((String)"queueName"))).and(QueryBuilder.eq((String)"enqueueId", (Object)QueryBuilder.bindMarker((String)"enqueueId"))));
    }

    private PreparedStatement prepareDeleteOne(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.delete().from("deletedMailsV2").where(QueryBuilder.eq((String)"queueName", (Object)QueryBuilder.bindMarker((String)"queueName"))).and(QueryBuilder.eq((String)"enqueueId", (Object)QueryBuilder.bindMarker((String)"enqueueId"))));
    }

    Mono<Void> markAsDeleted(MailQueueName mailQueueName, EnqueueId enqueueId) {
        return this.executor.executeVoid((Statement)this.insertOne.bind().setString("queueName", mailQueueName.asString()).setUUID("enqueueId", enqueueId.asUUID()));
    }

    Mono<Boolean> isDeleted(MailQueueName mailQueueName, EnqueueId enqueueId) {
        return this.executor.executeReturnExists((Statement)this.selectOne.bind().setString("queueName", mailQueueName.asString()).setUUID("enqueueId", enqueueId.asUUID()));
    }

    Mono<Void> removeDeletedMark(MailQueueName mailQueueName, EnqueueId enqueueId) {
        return this.executor.executeVoid((Statement)this.deleteOne.bind().setString("queueName", mailQueueName.asString()).setUUID("enqueueId", enqueueId.asUUID()));
    }

    Mono<Boolean> isStillEnqueued(MailQueueName mailQueueName, EnqueueId enqueueId) {
        return this.isDeleted(mailQueueName, enqueueId).map(FunctionalUtils.negate());
    }
}

