/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.core;

import java.util.Objects;
import org.elasticsearch.common.ParseField;

public abstract class IndexerJobStats {
    public static ParseField NUM_PAGES = new ParseField("pages_processed", new String[0]);
    public static ParseField NUM_INPUT_DOCUMENTS = new ParseField("documents_processed", new String[0]);
    public static ParseField NUM_OUTPUT_DOCUMENTS = new ParseField("documents_indexed", new String[0]);
    public static ParseField NUM_INVOCATIONS = new ParseField("trigger_count", new String[0]);
    public static ParseField INDEX_TIME_IN_MS = new ParseField("index_time_in_ms", new String[0]);
    public static ParseField SEARCH_TIME_IN_MS = new ParseField("search_time_in_ms", new String[0]);
    public static ParseField PROCESSING_TIME_IN_MS = new ParseField("processing_time_in_ms", new String[0]);
    public static ParseField INDEX_TOTAL = new ParseField("index_total", new String[0]);
    public static ParseField SEARCH_TOTAL = new ParseField("search_total", new String[0]);
    public static ParseField PROCESSING_TOTAL = new ParseField("processing_total", new String[0]);
    public static ParseField SEARCH_FAILURES = new ParseField("search_failures", new String[0]);
    public static ParseField INDEX_FAILURES = new ParseField("index_failures", new String[0]);
    protected final long numPages;
    protected final long numInputDocuments;
    protected final long numOuputDocuments;
    protected final long numInvocations;
    protected final long indexTime;
    protected final long indexTotal;
    protected final long searchTime;
    protected final long searchTotal;
    protected final long processingTime;
    protected final long processingTotal;
    protected final long indexFailures;
    protected final long searchFailures;

    public IndexerJobStats(long numPages, long numInputDocuments, long numOutputDocuments, long numInvocations, long indexTime, long searchTime, long processingTime, long indexTotal, long searchTotal, long processingTotal, long indexFailures, long searchFailures) {
        this.numPages = numPages;
        this.numInputDocuments = numInputDocuments;
        this.numOuputDocuments = numOutputDocuments;
        this.numInvocations = numInvocations;
        this.indexTime = indexTime;
        this.indexTotal = indexTotal;
        this.searchTime = searchTime;
        this.searchTotal = searchTotal;
        this.processingTime = processingTime;
        this.processingTotal = processingTotal;
        this.indexFailures = indexFailures;
        this.searchFailures = searchFailures;
    }

    public long getNumPages() {
        return this.numPages;
    }

    public long getNumDocuments() {
        return this.numInputDocuments;
    }

    public long getNumInvocations() {
        return this.numInvocations;
    }

    public long getOutputDocuments() {
        return this.numOuputDocuments;
    }

    public long getIndexFailures() {
        return this.indexFailures;
    }

    public long getSearchFailures() {
        return this.searchFailures;
    }

    public long getIndexTime() {
        return this.indexTime;
    }

    public long getSearchTime() {
        return this.searchTime;
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    public long getIndexTotal() {
        return this.indexTotal;
    }

    public long getSearchTotal() {
        return this.searchTotal;
    }

    public long getProcessingTotal() {
        return this.processingTotal;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IndexerJobStats)) {
            return false;
        }
        IndexerJobStats that = (IndexerJobStats)other;
        return Objects.equals(this.numPages, that.numPages) && Objects.equals(this.numInputDocuments, that.numInputDocuments) && Objects.equals(this.numOuputDocuments, that.numOuputDocuments) && Objects.equals(this.numInvocations, that.numInvocations) && Objects.equals(this.indexTime, that.indexTime) && Objects.equals(this.searchTime, that.searchTime) && Objects.equals(this.processingTime, that.processingTime) && Objects.equals(this.indexFailures, that.indexFailures) && Objects.equals(this.searchFailures, that.searchFailures) && Objects.equals(this.searchTotal, that.searchTotal) && Objects.equals(this.processingTotal, that.processingTotal) && Objects.equals(this.indexTotal, that.indexTotal);
    }

    public int hashCode() {
        return Objects.hash(this.numPages, this.numInputDocuments, this.numOuputDocuments, this.numInvocations, this.indexTime, this.searchTime, this.processingTime, this.indexFailures, this.searchFailures, this.searchTotal, this.indexTotal, this.processingTotal);
    }

    public final String toString() {
        return "{pages=" + this.numPages + ", input_docs=" + this.numInputDocuments + ", output_docs=" + this.numOuputDocuments + ", invocations=" + this.numInvocations + ", index_failures=" + this.indexFailures + ", search_failures=" + this.searchFailures + ", index_time_in_ms=" + this.indexTime + ", index_total=" + this.indexTotal + ", search_time_in_ms=" + this.searchTime + ", search_total=" + this.searchTotal + ", processing_time_in_ms=" + this.processingTime + ", processing_total=" + this.processingTotal + "}";
    }
}

