/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.protocols;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.ProvidesIntoSet;
import org.apache.james.modules.protocols.JSPFModule;
import org.apache.james.modules.protocols.SmtpGuiceProbe;
import org.apache.james.server.core.configuration.ConfigurationProvider;
import org.apache.james.smtpserver.SendMailHandler;
import org.apache.james.smtpserver.netty.OioSMTPServerFactory;
import org.apache.james.smtpserver.netty.SMTPServerFactory;
import org.apache.james.utils.GuiceProbe;
import org.apache.james.utils.InitializationOperation;
import org.apache.james.utils.InitilizationOperationBuilder;

public class SMTPServerModule
extends AbstractModule {
    protected void configure() {
        this.install((Module)new JSPFModule());
        this.bind(SMTPServerFactory.class).in(Scopes.SINGLETON);
        this.bind(OioSMTPServerFactory.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)this.binder(), GuiceProbe.class).addBinding().to(SmtpGuiceProbe.class);
    }

    @ProvidesIntoSet
    InitializationOperation configureSmtp(ConfigurationProvider configurationProvider, SMTPServerFactory smtpServerFactory, SendMailHandler sendMailHandler) {
        return InitilizationOperationBuilder.forClass(SMTPServerFactory.class).init(() -> {
            smtpServerFactory.configure(configurationProvider.getConfiguration("smtpserver"));
            smtpServerFactory.init();
            sendMailHandler.init(null);
        });
    }
}

