/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jspf.executor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.james.jspf.core.Logger;
import org.apache.james.jspf.core.SPFSession;
import org.apache.james.jspf.executor.SPFResult;

public class FutureSPFResult
extends SPFResult {
    private boolean isReady;
    private List<IFutureSPFResultListener> listeners;
    private int waiters;
    private final Logger log;

    public FutureSPFResult() {
        this.log = null;
        this.isReady = false;
    }

    public FutureSPFResult(Logger log) {
        this.log = log;
        this.isReady = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSPFResult(SPFSession session) {
        Iterator<IFutureSPFResultListener> listenerIt = null;
        FutureSPFResult futureSPFResult = this;
        synchronized (futureSPFResult) {
            if (!this.isReady) {
                this.setSPFSession(session);
                this.isReady = true;
                if (this.waiters > 0) {
                    this.notifyAll();
                }
                if (this.listeners != null) {
                    listenerIt = this.listeners.iterator();
                    this.listeners = null;
                }
            }
        }
        if (listenerIt != null) {
            while (listenerIt.hasNext()) {
                IFutureSPFResultListener listener = (IFutureSPFResultListener)listenerIt.next();
                try {
                    listener.onSPFResult(this);
                }
                catch (Throwable e) {
                    if (this.log == null) continue;
                    this.log.warn("An exception was thrown by the listener " + listener, e);
                }
            }
            listenerIt = null;
        }
    }

    private synchronized void checkReady() {
        while (!this.isReady) {
            try {
                ++this.waiters;
                this.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                --this.waiters;
            }
        }
    }

    public String getExplanation() {
        this.checkReady();
        return super.getExplanation();
    }

    public String getHeader() {
        this.checkReady();
        return super.getHeader();
    }

    public String getHeaderName() {
        this.checkReady();
        return super.getHeaderName();
    }

    public String getHeaderText() {
        this.checkReady();
        return super.getHeaderText();
    }

    public String getResult() {
        this.checkReady();
        return super.getResult();
    }

    public synchronized boolean isReady() {
        return this.isReady;
    }

    public synchronized void addListener(IFutureSPFResultListener listener) {
        if (!this.isReady) {
            if (this.listeners == null) {
                this.listeners = new ArrayList<IFutureSPFResultListener>();
            }
            this.listeners.add(listener);
        } else {
            listener.onSPFResult(this);
        }
    }

    public synchronized void removeListener(IFutureSPFResultListener listener) {
        if (!this.isReady && this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    public static interface IFutureSPFResultListener {
        public void onSPFResult(FutureSPFResult var1);
    }
}

