/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.collections;

import java.util.function.Consumer;
import org.apache.activemq.artemis.utils.collections.RepeatableIterator;
import org.apache.activemq.artemis.utils.collections.ResettableIterator;

public class RepeatableIteratorWrapper<E>
implements RepeatableIterator<E>,
ResettableIterator<E> {
    private ResettableIterator<E> iterator;
    private E last;
    private boolean repeat;

    public RepeatableIteratorWrapper(ResettableIterator<E> iterator) {
        this.iterator = iterator;
    }

    @Override
    public void repeat() {
        if (this.last != null) {
            this.repeat = true;
        }
    }

    @Override
    public boolean hasNext() {
        return this.repeat || this.iterator.hasNext();
    }

    @Override
    public E next() {
        if (this.repeat) {
            this.repeat = false;
            return this.last;
        }
        this.last = this.iterator.next();
        return this.last;
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }

    @Override
    public void forEachRemaining(Consumer<? super E> action) {
        this.iterator.forEachRemaining(action);
    }

    @Override
    public void reset() {
        this.iterator.reset();
    }
}

