/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.api;

import com.google.common.io.ByteSource;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BucketName;
import org.reactivestreams.Publisher;

public interface BlobStore {
    public static final String DEFAULT_BUCKET_NAME_QUALIFIER = "defaultBucket";

    public Publisher<BlobId> save(BucketName var1, byte[] var2, StoragePolicy var3);

    public Publisher<BlobId> save(BucketName var1, InputStream var2, StoragePolicy var3);

    public Publisher<BlobId> save(BucketName var1, ByteSource var2, StoragePolicy var3);

    default public Publisher<BlobId> save(BucketName bucketName, String data, StoragePolicy storagePolicy) {
        return this.save(bucketName, data.getBytes(StandardCharsets.UTF_8), storagePolicy);
    }

    public Publisher<byte[]> readBytes(BucketName var1, BlobId var2);

    public InputStream read(BucketName var1, BlobId var2);

    default public Publisher<byte[]> readBytes(BucketName bucketName, BlobId blobId, StoragePolicy storagePolicy) {
        return this.readBytes(bucketName, blobId);
    }

    default public InputStream read(BucketName bucketName, BlobId blobId, StoragePolicy storagePolicy) {
        return this.read(bucketName, blobId);
    }

    public BucketName getDefaultBucketName();

    public Publisher<BucketName> listBuckets();

    public Publisher<Void> deleteBucket(BucketName var1);

    public Publisher<Boolean> delete(BucketName var1, BlobId var2);

    public Publisher<BlobId> listBlobs(BucketName var1);

    public static enum StoragePolicy {
        SIZE_BASED,
        LOW_COST,
        HIGH_PERFORMANCE;

    }
}

