/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.rest.table.v1.handler;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnCategory;
import org.apache.iotdb.db.exception.WriteProcessRejectException;
import org.apache.iotdb.db.protocol.rest.table.v1.model.InsertTabletRequest;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.DataNodeDevicePathCache;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertTabletStatement;
import org.apache.iotdb.db.utils.TimestampPrecisionUtils;
import org.apache.tsfile.enums.ColumnCategory;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.BitMap;

public class StatementConstructionHandler {
    private static final DataNodeDevicePathCache DEVICE_PATH_CACHE = DataNodeDevicePathCache.getInstance();

    private StatementConstructionHandler() {
    }

    public static InsertTabletStatement constructInsertTabletStatement(InsertTabletRequest insertTabletReq) throws IllegalPathException, WriteProcessRejectException {
        InsertTabletStatement insertStatement = new InsertTabletStatement();
        insertStatement.setDevicePath(DEVICE_PATH_CACHE.getPartialPath(insertTabletReq.getTable()));
        insertStatement.setMeasurements(insertTabletReq.getColumnNames().toArray(new String[0]));
        long[] timestamps = insertTabletReq.getTimestamps().stream().mapToLong(Long::longValue).toArray();
        if (timestamps.length != 0) {
            TimestampPrecisionUtils.checkTimestampPrecision(timestamps[timestamps.length - 1]);
        }
        insertStatement.setTimes(timestamps);
        int columnSize = insertTabletReq.getColumnNames().size();
        int rowSize = insertTabletReq.getTimestamps().size();
        List rawData = insertTabletReq.getValues();
        Object[] columns = new Object[columnSize];
        BitMap[] bitMaps = new BitMap[columnSize];
        List rawDataType = insertTabletReq.getDataTypes();
        TSDataType[] dataTypes = new TSDataType[columnSize];
        for (int i = 0; i < columnSize; ++i) {
            dataTypes[i] = TSDataType.valueOf((String)((String)rawDataType.get(i)).toUpperCase(Locale.ROOT));
        }
        block9: for (int columnIndex = 0; columnIndex < columnSize; ++columnIndex) {
            bitMaps[columnIndex] = new BitMap(rowSize);
            switch (dataTypes[columnIndex]) {
                case BOOLEAN: {
                    boolean[] booleanValues = new boolean[rowSize];
                    for (int rowIndex = 0; rowIndex < rowSize; ++rowIndex) {
                        Object data = ((List)rawData.get(rowIndex)).get(columnIndex);
                        if (data == null) {
                            bitMaps[columnIndex].mark(rowIndex);
                            continue;
                        }
                        booleanValues[rowIndex] = "1".equals(data.toString()) ? true : ("0".equals(data.toString()) ? false : (Boolean)data);
                    }
                    columns[columnIndex] = booleanValues;
                    continue block9;
                }
                case INT32: 
                case DATE: {
                    int[] intValues = new int[rowSize];
                    for (int rowIndex = 0; rowIndex < rowSize; ++rowIndex) {
                        Object object = ((List)rawData.get(rowIndex)).get(columnIndex);
                        if (object == null) {
                            bitMaps[columnIndex].mark(rowIndex);
                            continue;
                        }
                        if (object instanceof Integer) {
                            intValues[rowIndex] = (Integer)object;
                            continue;
                        }
                        throw new WriteProcessRejectException("unsupported data type: " + object.getClass().toString());
                    }
                    columns[columnIndex] = intValues;
                    continue block9;
                }
                case INT64: 
                case TIMESTAMP: {
                    long[] longValues = new long[rowSize];
                    for (int rowIndex = 0; rowIndex < rowSize; ++rowIndex) {
                        Object object = ((List)rawData.get(rowIndex)).get(columnIndex);
                        if (object == null) {
                            bitMaps[columnIndex].mark(rowIndex);
                            continue;
                        }
                        if (object instanceof Integer) {
                            longValues[rowIndex] = ((Integer)object).intValue();
                            continue;
                        }
                        if (object instanceof Long) {
                            longValues[rowIndex] = (Long)object;
                            continue;
                        }
                        throw new WriteProcessRejectException("unsupported data type: " + object.getClass().toString());
                    }
                    columns[columnIndex] = longValues;
                    continue block9;
                }
                case FLOAT: {
                    float[] floatValues = new float[rowSize];
                    for (int rowIndex = 0; rowIndex < rowSize; ++rowIndex) {
                        Object data = ((List)rawData.get(rowIndex)).get(columnIndex);
                        if (data == null) {
                            bitMaps[columnIndex].mark(rowIndex);
                            continue;
                        }
                        floatValues[rowIndex] = Float.parseFloat(String.valueOf(data));
                    }
                    columns[columnIndex] = floatValues;
                    continue block9;
                }
                case DOUBLE: {
                    double[] doubleValues = new double[rowSize];
                    for (int rowIndex = 0; rowIndex < rowSize; ++rowIndex) {
                        if (((List)rawData.get(rowIndex)).get(columnIndex) == null) {
                            bitMaps[columnIndex].mark(rowIndex);
                            continue;
                        }
                        doubleValues[rowIndex] = Double.parseDouble(String.valueOf(((List)rawData.get(rowIndex)).get(columnIndex)));
                    }
                    columns[columnIndex] = doubleValues;
                    continue block9;
                }
                case TEXT: 
                case BLOB: 
                case STRING: {
                    Binary[] binaryValues = new Binary[rowSize];
                    for (int rowIndex = 0; rowIndex < rowSize; ++rowIndex) {
                        if (((List)rawData.get(rowIndex)).get(columnIndex) == null) {
                            bitMaps[columnIndex].mark(rowIndex);
                            binaryValues[rowIndex] = new Binary("".getBytes(StandardCharsets.UTF_8));
                            continue;
                        }
                        binaryValues[rowIndex] = new Binary(((List)rawData.get(rowIndex)).get(columnIndex).toString().getBytes(StandardCharsets.UTF_8));
                    }
                    columns[columnIndex] = binaryValues;
                    continue block9;
                }
                default: {
                    throw new IllegalArgumentException("Invalid input: " + (String)rawDataType.get(columnIndex));
                }
            }
        }
        insertStatement.setColumns(columns);
        insertStatement.setBitMaps(bitMaps);
        insertStatement.setRowCount(rowSize);
        insertStatement.setDataTypes(dataTypes);
        insertStatement.setAligned(false);
        insertStatement.setWriteToTable(true);
        TsTableColumnCategory[] columnCategories = new TsTableColumnCategory[insertTabletReq.getColumnCategories().size()];
        for (int i = 0; i < columnCategories.length; ++i) {
            columnCategories[i] = TsTableColumnCategory.fromTsFileColumnCategory((ColumnCategory)ColumnCategory.valueOf((String)((String)insertTabletReq.getColumnCategories().get(i))));
        }
        insertStatement.setColumnCategories(columnCategories);
        return insertStatement;
    }
}

