/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.common.type;

import java.util.Collections;
import java.util.List;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.read.common.block.column.DoubleColumnBuilder;
import org.apache.tsfile.read.common.type.AbstractType;
import org.apache.tsfile.read.common.type.Type;
import org.apache.tsfile.read.common.type.TypeEnum;

public class DoubleType
extends AbstractType {
    public static final DoubleType DOUBLE = new DoubleType();

    private DoubleType() {
    }

    @Override
    public int getInt(Column c, int position) {
        return (int)c.getDouble(position);
    }

    @Override
    public long getLong(Column c, int position) {
        return (long)c.getDouble(position);
    }

    @Override
    public float getFloat(Column c, int position) {
        return (float)c.getDouble(position);
    }

    @Override
    public double getDouble(Column c, int position) {
        return c.getDouble(position);
    }

    @Override
    public void writeInt(ColumnBuilder builder, int value) {
        builder.writeDouble(value);
    }

    @Override
    public void writeLong(ColumnBuilder builder, long value) {
        builder.writeDouble(value);
    }

    @Override
    public void writeFloat(ColumnBuilder builder, float value) {
        builder.writeDouble(value);
    }

    @Override
    public void writeDouble(ColumnBuilder builder, double value) {
        builder.writeDouble(value);
    }

    @Override
    public ColumnBuilder createColumnBuilder(int expectedEntries) {
        return new DoubleColumnBuilder(null, expectedEntries);
    }

    @Override
    public TypeEnum getTypeEnum() {
        return TypeEnum.DOUBLE;
    }

    @Override
    public String getDisplayName() {
        return "DOUBLE";
    }

    @Override
    public boolean isComparable() {
        return true;
    }

    @Override
    public boolean isOrderable() {
        return true;
    }

    @Override
    public List<Type> getTypeParameters() {
        return Collections.emptyList();
    }

    public static DoubleType getInstance() {
        return DOUBLE;
    }
}

