/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.TableExpressionType;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class ArithmeticBinaryExpression
extends Expression {
    private final Operator operator;
    private final Expression left;
    private final Expression right;

    public ArithmeticBinaryExpression(Operator operator, Expression left, Expression right) {
        super(null);
        this.operator = operator;
        this.left = left;
        this.right = right;
    }

    public ArithmeticBinaryExpression(@Nonnull NodeLocation location, Operator operator, Expression left, Expression right) {
        super(Objects.requireNonNull(location, "location is null"));
        this.operator = operator;
        this.left = left;
        this.right = right;
    }

    public ArithmeticBinaryExpression(ByteBuffer byteBuffer) {
        super(null);
        this.operator = Operator.values()[ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer)];
        this.left = Expression.deserialize(byteBuffer);
        this.right = Expression.deserialize(byteBuffer);
    }

    @Override
    public TableExpressionType getExpressionType() {
        return TableExpressionType.ARITHMETIC_BINARY;
    }

    @Override
    protected void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((int)this.operator.ordinal(), (OutputStream)stream);
        Expression.serialize(this.left, stream);
        Expression.serialize(this.right, stream);
    }

    public Operator getOperator() {
        return this.operator;
    }

    public Expression getLeft() {
        return this.left;
    }

    public Expression getRight() {
        return this.right;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitArithmeticBinary(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of((Object)this.left, (Object)this.right);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArithmeticBinaryExpression that = (ArithmeticBinaryExpression)o;
        return this.operator == that.operator && Objects.equals(this.left, that.left) && Objects.equals(this.right, that.right);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.operator, this.left, this.right});
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!ArithmeticBinaryExpression.sameClass(this, other)) {
            return false;
        }
        return this.operator == ((ArithmeticBinaryExpression)other).operator;
    }

    public static enum Operator {
        ADD("+"),
        SUBTRACT("-"),
        MULTIPLY("*"),
        DIVIDE("/"),
        MODULUS("%");

        private final String value;

        private Operator(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

