/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.pipe.source;

import java.util.Optional;
import org.apache.iotdb.commons.pipe.datastructure.pattern.TablePattern;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanVisitor;
import org.apache.iotdb.confignode.consensus.request.write.auth.AuthorRelationalPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.DatabaseSchemaPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.DeleteDatabasePlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeCreateTableOrViewPlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeDeleteDevicesPlan;
import org.apache.iotdb.confignode.consensus.request.write.table.AbstractTablePlan;
import org.apache.iotdb.confignode.consensus.request.write.table.AddTableColumnPlan;
import org.apache.iotdb.confignode.consensus.request.write.table.CommitDeleteColumnPlan;
import org.apache.iotdb.confignode.consensus.request.write.table.CommitDeleteTablePlan;
import org.apache.iotdb.confignode.consensus.request.write.table.RenameTableColumnPlan;
import org.apache.iotdb.confignode.consensus.request.write.table.RenameTablePlan;
import org.apache.iotdb.confignode.consensus.request.write.table.SetTableColumnCommentPlan;
import org.apache.iotdb.confignode.consensus.request.write.table.SetTableCommentPlan;
import org.apache.iotdb.confignode.consensus.request.write.table.SetTablePropertiesPlan;

public class PipeConfigPhysicalPlanTablePatternParseVisitor
extends ConfigPhysicalPlanVisitor<Optional<ConfigPhysicalPlan>, TablePattern> {
    @Override
    public Optional<ConfigPhysicalPlan> visitPlan(ConfigPhysicalPlan plan, TablePattern pattern) {
        return Optional.of(plan);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitCreateDatabase(DatabaseSchemaPlan createDatabasePlan, TablePattern pattern) {
        return this.visitDatabaseSchemaPlan(createDatabasePlan, pattern);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitAlterDatabase(DatabaseSchemaPlan alterDatabasePlan, TablePattern pattern) {
        return this.visitDatabaseSchemaPlan(alterDatabasePlan, pattern);
    }

    public Optional<ConfigPhysicalPlan> visitDatabaseSchemaPlan(DatabaseSchemaPlan databaseSchemaPlan, TablePattern pattern) {
        return pattern.matchesDatabase(PathUtils.unQualifyDatabaseName((String)databaseSchemaPlan.getSchema().getName())) ? Optional.of(databaseSchemaPlan) : Optional.empty();
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitDeleteDatabase(DeleteDatabasePlan deleteDatabasePlan, TablePattern pattern) {
        return pattern.matchesDatabase(PathUtils.unQualifyDatabaseName((String)deleteDatabasePlan.getName())) ? Optional.of(deleteDatabasePlan) : Optional.empty();
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitPipeCreateTableOrView(PipeCreateTableOrViewPlan pipeCreateTableOrViewPlan, TablePattern pattern) {
        return pattern.matchesDatabase(PathUtils.unQualifyDatabaseName((String)pipeCreateTableOrViewPlan.getDatabase())) && pattern.matchesTable(pipeCreateTableOrViewPlan.getTable().getTableName()) ? Optional.of(pipeCreateTableOrViewPlan) : Optional.empty();
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitAddTableColumn(AddTableColumnPlan addTableColumnPlan, TablePattern pattern) {
        return this.visitAbstractTablePlan(addTableColumnPlan, pattern);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitSetTableProperties(SetTablePropertiesPlan setTablePropertiesPlan, TablePattern pattern) {
        return this.visitAbstractTablePlan(setTablePropertiesPlan, pattern);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitCommitDeleteColumn(CommitDeleteColumnPlan commitDeleteColumnPlan, TablePattern pattern) {
        return this.visitAbstractTablePlan(commitDeleteColumnPlan, pattern);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitRenameTableColumn(RenameTableColumnPlan renameTableColumnPlan, TablePattern pattern) {
        return this.visitAbstractTablePlan(renameTableColumnPlan, pattern);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitCommitDeleteTable(CommitDeleteTablePlan commitDeleteTablePlan, TablePattern pattern) {
        return this.visitAbstractTablePlan(commitDeleteTablePlan, pattern);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitPipeDeleteDevices(PipeDeleteDevicesPlan pipeDeleteDevicesPlan, TablePattern pattern) {
        return this.visitAbstractTablePlan(pipeDeleteDevicesPlan, pattern);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitSetTableComment(SetTableCommentPlan setTableCommentPlan, TablePattern pattern) {
        return this.visitAbstractTablePlan(setTableCommentPlan, pattern);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitSetTableColumnComment(SetTableColumnCommentPlan setTableColumnCommentPlan, TablePattern pattern) {
        return this.visitAbstractTablePlan(setTableColumnCommentPlan, pattern);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitRenameTable(RenameTablePlan renameTablePlan, TablePattern pattern) {
        return this.visitAbstractTablePlan(renameTablePlan, pattern);
    }

    private Optional<ConfigPhysicalPlan> visitAbstractTablePlan(AbstractTablePlan plan, TablePattern pattern) {
        return pattern.matchesDatabase(PathUtils.unQualifyDatabaseName((String)plan.getDatabase())) && pattern.matchesTable(plan.getTableName()) ? Optional.of(plan) : Optional.empty();
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitRGrantUserDB(AuthorRelationalPlan plan, TablePattern pattern) {
        return this.visitAuthorDBPlan(plan, pattern);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitRGrantRoleDB(AuthorRelationalPlan plan, TablePattern pattern) {
        return this.visitAuthorDBPlan(plan, pattern);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitRRevokeUserDBPrivilege(AuthorRelationalPlan plan, TablePattern pattern) {
        return this.visitAuthorDBPlan(plan, pattern);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitRRevokeRoleDBPrivilege(AuthorRelationalPlan plan, TablePattern pattern) {
        return this.visitAuthorDBPlan(plan, pattern);
    }

    private Optional<ConfigPhysicalPlan> visitAuthorDBPlan(AuthorRelationalPlan plan, TablePattern pattern) {
        return pattern.matchesDatabase(plan.getDatabaseName()) ? Optional.of(plan) : Optional.empty();
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitRGrantUserTB(AuthorRelationalPlan plan, TablePattern pattern) {
        return this.visitAuthorTBPlan(plan, pattern);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitRGrantRoleTB(AuthorRelationalPlan plan, TablePattern pattern) {
        return this.visitAuthorTBPlan(plan, pattern);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitRRevokeUserTBPrivilege(AuthorRelationalPlan plan, TablePattern pattern) {
        return this.visitAuthorTBPlan(plan, pattern);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitRRevokeRoleTBPrivilege(AuthorRelationalPlan plan, TablePattern pattern) {
        return this.visitAuthorTBPlan(plan, pattern);
    }

    private Optional<ConfigPhysicalPlan> visitAuthorTBPlan(AuthorRelationalPlan plan, TablePattern pattern) {
        return pattern.matchesDatabase(plan.getDatabaseName()) && pattern.matchesTable(plan.getTableName()) ? Optional.of(plan) : Optional.empty();
    }
}

