/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tool.schema;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.iotdb.cli.utils.IoTPrinter;
import org.apache.iotdb.isession.SessionDataSet;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.session.Session;
import org.apache.iotdb.tool.common.Constants;
import org.apache.iotdb.tool.schema.AbstractExportSchema;
import org.apache.iotdb.tool.schema.AbstractSchemaTool;
import org.apache.tsfile.read.common.Field;
import org.apache.tsfile.read.common.RowRecord;

public class ExportSchemaTree
extends AbstractExportSchema {
    private static final IoTPrinter ioTPrinter = new IoTPrinter(System.out);
    private static Session session;

    @Override
    public void init() throws InterruptedException, IoTDBConnectionException, StatementExecutionException {
        session = new Session(host, Integer.parseInt(port), username, password);
        session.open(false);
    }

    @Override
    protected void exportSchemaToSqlFile() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected void exportSchemaToCsvFile(String pathPattern, int index) {
        File file = new File(targetDirectory);
        if (!file.isDirectory()) {
            file.mkdir();
        }
        String path = targetDirectory + targetFile + index;
        try {
            SessionDataSet sessionDataSet = session.executeQueryStatement("show timeseries " + pathPattern, timeout);
            ExportSchemaTree.writeCsvFile(sessionDataSet, path, sessionDataSet.getColumnNames(), linesPerFile);
            sessionDataSet.closeOperationHandle();
            ioTPrinter.println("Export completely!");
        }
        catch (IOException | IoTDBConnectionException | StatementExecutionException e) {
            ioTPrinter.println("Cannot dump result because: " + e.getMessage());
        }
    }

    private static void writeCsvFile(SessionDataSet sessionDataSet, String filePath, List<String> headers, int linesPerFile) throws IOException, IoTDBConnectionException, StatementExecutionException {
        int viewTypeIndex = headers.indexOf("ViewType");
        int timeseriesIndex = headers.indexOf("Timeseries");
        int fileIndex = 0;
        boolean hasNext = true;
        while (hasNext) {
            int i = 0;
            String finalFilePath = filePath + "_" + fileIndex + ".csv";
            AbstractSchemaTool.CSVPrinterWrapper csvPrinterWrapper = new AbstractSchemaTool.CSVPrinterWrapper(finalFilePath);
            while (i++ < linesPerFile) {
                if (sessionDataSet.hasNext()) {
                    RowRecord rowRecord;
                    List fields;
                    if (i == 1) {
                        csvPrinterWrapper.printRecord(Constants.HEAD_COLUMNS);
                    }
                    if (((Field)(fields = (rowRecord = sessionDataSet.next()).getFields()).get(timeseriesIndex)).getStringValue().startsWith("root.__system.") || !((Field)fields.get(viewTypeIndex)).getStringValue().equals("BASE")) continue;
                    Constants.HEAD_COLUMNS.forEach(column -> {
                        Field field = (Field)fields.get(headers.indexOf(column));
                        String fieldStringValue = field.getStringValue();
                        if (!"null".equals(field.getStringValue())) {
                            csvPrinterWrapper.print(fieldStringValue);
                        } else {
                            csvPrinterWrapper.print("");
                        }
                    });
                    csvPrinterWrapper.println();
                    continue;
                }
                hasNext = false;
                break;
            }
            ++fileIndex;
            csvPrinterWrapper.flush();
            csvPrinterWrapper.close();
        }
    }
}

