/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.reader.page;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.tsfile.compress.IUnCompressor;
import org.apache.tsfile.encrypt.EncryptParameter;
import org.apache.tsfile.encrypt.EncryptUtils;
import org.apache.tsfile.encrypt.IDecryptor;
import org.apache.tsfile.file.header.PageHeader;

public class LazyLoadPageData {
    private final byte[] chunkData;
    private final int pageDataOffset;
    private final IUnCompressor unCompressor;
    private final EncryptParameter encryptParam;

    public LazyLoadPageData(byte[] data, int offset, IUnCompressor unCompressor) {
        this.chunkData = data;
        this.pageDataOffset = offset;
        this.unCompressor = unCompressor;
        this.encryptParam = EncryptUtils.getEncryptParameter();
    }

    public LazyLoadPageData(byte[] data, int offset, IUnCompressor unCompressor, EncryptParameter encryptParam) {
        this.chunkData = data;
        this.pageDataOffset = offset;
        this.unCompressor = unCompressor;
        this.encryptParam = encryptParam;
    }

    public ByteBuffer uncompressPageData(PageHeader pageHeader) throws IOException {
        int compressedPageBodyLength = pageHeader.getCompressedSize();
        byte[] uncompressedPageData = new byte[pageHeader.getUncompressedSize()];
        IDecryptor decryptor = IDecryptor.getDecryptor(this.encryptParam);
        byte[] decryptedPageData = decryptor.decrypt(this.chunkData, this.pageDataOffset, compressedPageBodyLength);
        try {
            this.unCompressor.uncompress(decryptedPageData, 0, compressedPageBodyLength, uncompressedPageData, 0);
        }
        catch (Exception e) {
            throw new IOException("Uncompress error! uncompress size: " + pageHeader.getUncompressedSize() + "compressed size: " + pageHeader.getCompressedSize() + "page header: " + pageHeader + e.getMessage());
        }
        return ByteBuffer.wrap(uncompressedPageData);
    }

    public IUnCompressor getUnCompressor() {
        return this.unCompressor;
    }
}

