/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.subscription.consumer;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.commons.subscription.meta.consumer.ConsumerGroupMeta;
import org.apache.iotdb.commons.subscription.meta.consumer.ConsumerMeta;
import org.apache.iotdb.confignode.persistence.subscription.SubscriptionInfo;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.impl.subscription.SubscriptionOperation;
import org.apache.iotdb.confignode.procedure.impl.subscription.consumer.AlterConsumerGroupProcedure;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.confignode.rpc.thrift.TCreateConsumerReq;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class CreateConsumerProcedure
extends AlterConsumerGroupProcedure {
    private TCreateConsumerReq createConsumerReq;

    public CreateConsumerProcedure() {
    }

    public CreateConsumerProcedure(TCreateConsumerReq createConsumerReq) throws PipeException {
        this.createConsumerReq = createConsumerReq;
    }

    @Override
    protected SubscriptionOperation getOperation() {
        return SubscriptionOperation.CREATE_CONSUMER;
    }

    @Override
    protected void validateAndGetOldAndNewMeta(ConfigNodeProcedureEnv env) {
        ((SubscriptionInfo)this.subscriptionInfo.get()).validateBeforeCreatingConsumer(this.createConsumerReq);
        this.existingConsumerGroupMeta = ((SubscriptionInfo)this.subscriptionInfo.get()).getConsumerGroupMeta(this.createConsumerReq.getConsumerGroupId());
        long creationTime = System.currentTimeMillis();
        ConsumerMeta newConsumerMeta = new ConsumerMeta(this.createConsumerReq.getConsumerId(), creationTime, this.createConsumerReq.getConsumerAttributes());
        if (this.existingConsumerGroupMeta == null) {
            this.updatedConsumerGroupMeta = new ConsumerGroupMeta(this.createConsumerReq.getConsumerGroupId(), creationTime, newConsumerMeta);
        } else {
            this.updatedConsumerGroupMeta = this.existingConsumerGroupMeta.deepCopy();
            this.updatedConsumerGroupMeta.addConsumer(newConsumerMeta);
        }
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(ProcedureType.CREATE_CONSUMER_PROCEDURE.getTypeCode());
        super.serialize(stream);
        ReadWriteIOUtils.write((String)this.createConsumerReq.getConsumerId(), (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.createConsumerReq.getConsumerGroupId(), (OutputStream)stream);
        int size = this.createConsumerReq.getConsumerAttributes().size();
        ReadWriteIOUtils.write((int)size, (OutputStream)stream);
        if (size != 0) {
            for (Map.Entry entry : this.createConsumerReq.getConsumerAttributes().entrySet()) {
                ReadWriteIOUtils.write((String)((String)entry.getKey()), (OutputStream)stream);
                ReadWriteIOUtils.write((String)((String)entry.getValue()), (OutputStream)stream);
            }
        }
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.readShort((ByteBuffer)byteBuffer);
        super.deserialize(byteBuffer);
        this.createConsumerReq = new TCreateConsumerReq().setConsumerId(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer)).setConsumerGroupId(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer)).setConsumerAttributes(new HashMap());
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        for (int i = 0; i < size; ++i) {
            this.createConsumerReq.getConsumerAttributes().put(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer), ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
        }
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && Objects.equals(this.createConsumerReq, ((CreateConsumerProcedure)o).createConsumerReq);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.createConsumerReq);
    }
}

