/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tool.schema;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.cli.utils.IoTPrinter;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.exception.ArgsErrorException;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.session.Session;
import org.apache.iotdb.tool.schema.AbstractSchemaTool;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;

public class ImportSchema
extends AbstractSchemaTool {
    private static final String FILE_ARGS = "s";
    private static final String FILE_NAME = "source";
    private static final String FILE_ARGS_NAME = "sourceDir/sourceFile";
    private static final String FAILED_FILE_ARGS = "fd";
    private static final String FAILED_FILE_NAME = "fail_dir";
    private static final String FAILED_FILE_ARGS_NAME = "failDir";
    private static final String ALIGNED_ARGS = "aligned";
    private static Boolean aligned = false;
    private static final String BATCH_POINT_SIZE_ARGS = "batch";
    private static final String BATCH_POINT_SIZE_NAME = "batch_size";
    private static final String BATCH_POINT_SIZE_ARGS_NAME = "batchSize";
    private static int batchPointSize = 10000;
    private static final String CSV_SUFFIXS = "csv";
    private static final String LINES_PER_FAILED_FILE_ARGS = "lpf";
    private static final String LINES_PER_FAILED_FILE_NAME = "lines_per_file";
    private static final String LINES_PER_FAILED_FILE_ARGS_NAME = "linesPerFile";
    private static final String IMPORT_SCHEMA_CLI_PREFIX = "ImportSchema";
    private static int linesPerFailedFile = 10000;
    private static String targetPath;
    private static String failedFileDirectory;
    private static final String INSERT_CSV_MEET_ERROR_MSG = "Meet error when insert csv because ";
    private static final IoTPrinter ioTPrinter;

    private static Options createOptions() {
        Options options = ImportSchema.createNewOptions();
        Option opFile = Option.builder((String)FILE_ARGS).required().longOpt(FILE_NAME).hasArg().argName(FILE_ARGS_NAME).desc("If input a file path, load a csv file, otherwise load all csv file under this directory (required)").build();
        options.addOption(opFile);
        Option opFailedFile = Option.builder((String)FAILED_FILE_ARGS).longOpt(FAILED_FILE_NAME).hasArg().argName(FAILED_FILE_ARGS_NAME).desc("Specifying a directory to save failed file, default YOUR_CSV_FILE_PATH (optional)").build();
        options.addOption(opFailedFile);
        Option opBatchPointSize = Option.builder((String)BATCH_POINT_SIZE_ARGS).longOpt(BATCH_POINT_SIZE_NAME).hasArg().argName(BATCH_POINT_SIZE_ARGS_NAME).desc("10000 (only not aligned optional)").build();
        options.addOption(opBatchPointSize);
        Option opFailedLinesPerFile = Option.builder((String)LINES_PER_FAILED_FILE_ARGS).longOpt(LINES_PER_FAILED_FILE_NAME).hasArg().argName(LINES_PER_FAILED_FILE_ARGS_NAME).desc("Lines per failed file").build();
        options.addOption(opFailedLinesPerFile);
        Option opHelp = Option.builder((String)"help").longOpt("help").desc("Display help information").build();
        options.addOption(opHelp);
        return options;
    }

    private static void parseSpecialParams(CommandLine commandLine) throws ArgsErrorException {
        targetPath = commandLine.getOptionValue(FILE_ARGS);
        if (commandLine.getOptionValue(BATCH_POINT_SIZE_ARGS) != null) {
            batchPointSize = Integer.parseInt(commandLine.getOptionValue(BATCH_POINT_SIZE_ARGS));
        }
        if (commandLine.getOptionValue(FAILED_FILE_ARGS) != null) {
            failedFileDirectory = commandLine.getOptionValue(FAILED_FILE_ARGS);
            File file = new File(failedFileDirectory);
            if (!file.isDirectory()) {
                file.mkdir();
                failedFileDirectory = file.getAbsolutePath() + File.separator;
            } else if (!failedFileDirectory.endsWith("/") && !failedFileDirectory.endsWith("\\")) {
                failedFileDirectory = failedFileDirectory + File.separator;
            }
        }
        if (commandLine.getOptionValue(ALIGNED_ARGS) != null) {
            aligned = Boolean.valueOf(commandLine.getOptionValue(ALIGNED_ARGS));
        }
        if (commandLine.getOptionValue(LINES_PER_FAILED_FILE_ARGS) != null) {
            linesPerFailedFile = Integer.parseInt(commandLine.getOptionValue(LINES_PER_FAILED_FILE_ARGS));
        }
    }

    public static void main(String[] args) throws IoTDBConnectionException {
        Options options = ImportSchema.createOptions();
        HelpFormatter hf = new HelpFormatter();
        hf.setOptionComparator(null);
        hf.setWidth(92);
        CommandLine commandLine = null;
        DefaultParser parser = new DefaultParser();
        if (args == null || args.length == 0) {
            ioTPrinter.println("Too few params input, please check the following hint.");
            hf.printHelp(IMPORT_SCHEMA_CLI_PREFIX, options, true);
            System.exit(1);
        }
        try {
            commandLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            ioTPrinter.println("Parse error: " + e.getMessage());
            hf.printHelp(IMPORT_SCHEMA_CLI_PREFIX, options, true);
            System.exit(1);
        }
        if (commandLine.hasOption("help")) {
            hf.printHelp(IMPORT_SCHEMA_CLI_PREFIX, options, true);
            System.exit(1);
        }
        try {
            ImportSchema.parseBasicParams(commandLine);
            String filename = commandLine.getOptionValue(FILE_ARGS);
            if (filename == null) {
                hf.printHelp(IMPORT_SCHEMA_CLI_PREFIX, options, true);
                System.exit(1);
            }
            ImportSchema.parseSpecialParams(commandLine);
        }
        catch (ArgsErrorException e) {
            ioTPrinter.println("Args error: " + e.getMessage());
            System.exit(1);
        }
        catch (Exception e) {
            ioTPrinter.println("Encounter an error, because: " + e.getMessage());
            System.exit(1);
        }
        System.exit(ImportSchema.importFromTargetPath(host, Integer.parseInt(port), username, password, targetPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int importFromTargetPath(String host, int port, String username, String password, String targetPath) {
        block21: {
            int n;
            try {
                session = new Session(host, port, username, password, false);
                session.open(false);
                File file = new File(targetPath);
                if (file.isFile()) {
                    ImportSchema.importFromSingleFile(file);
                    break block21;
                }
                if (file.isDirectory()) {
                    File[] files = file.listFiles();
                    if (files == null) {
                        int n2 = 0;
                        return n2;
                    }
                    Arrays.sort(files, (f1, f2) -> f1.getName().compareTo(f2.getName()));
                    for (File subFile : files) {
                        if (!subFile.isFile()) continue;
                        ImportSchema.importFromSingleFile(subFile);
                    }
                    break block21;
                }
                ioTPrinter.println("File not found!");
                n = 1;
            }
            catch (IoTDBConnectionException e) {
                ioTPrinter.println("Encounter an error when connecting to server, because " + e.getMessage());
                int n3 = 1;
                return n3;
            }
            finally {
                if (session != null) {
                    try {
                        session.close();
                    }
                    catch (IoTDBConnectionException ioTDBConnectionException) {}
                }
            }
            return n;
        }
        return 0;
    }

    private static void importFromSingleFile(File file) {
        if (file.getName().endsWith(CSV_SUFFIXS)) {
            try {
                CSVParser csvRecords = ImportSchema.readCsvFile(file.getAbsolutePath());
                List headerNames = csvRecords.getHeaderNames();
                Stream records = csvRecords.stream();
                if (headerNames.isEmpty()) {
                    ioTPrinter.println(file.getName() + " : Empty file!");
                    return;
                }
                if (!ImportSchema.checkHeader(headerNames)) {
                    return;
                }
                String failedFilePath = null;
                failedFilePath = failedFileDirectory == null ? file.getAbsolutePath() + ".failed" : failedFileDirectory + file.getName() + ".failed";
                ImportSchema.writeScheme(file.getName(), headerNames, records, failedFilePath);
            }
            catch (IOException | IllegalPathException e) {
                ioTPrinter.println(file.getName() + " : CSV file read exception because: " + e.getMessage());
            }
        } else {
            ioTPrinter.println(file.getName() + " : The file name must end with \"csv\"!");
        }
    }

    private static void writeScheme(String fileName, List<String> headerNames, Stream<CSVRecord> records, String failedFilePath) throws IllegalPathException {
        ArrayList<String> paths = new ArrayList<String>();
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        ArrayList<TSEncoding> encodings = new ArrayList<TSEncoding>();
        ArrayList<CompressionType> compressors = new ArrayList<CompressionType>();
        ArrayList<String> pathsWithAlias = new ArrayList<String>();
        ArrayList<TSDataType> dataTypesWithAlias = new ArrayList<TSDataType>();
        ArrayList<TSEncoding> encodingsWithAlias = new ArrayList<TSEncoding>();
        ArrayList<CompressionType> compressorsWithAlias = new ArrayList<CompressionType>();
        ArrayList<String> measurementAlias = new ArrayList<String>();
        AtomicReference<Boolean> hasStarted = new AtomicReference<Boolean>(false);
        AtomicInteger pointSize = new AtomicInteger(0);
        ArrayList<List<Object>> failedRecords = new ArrayList<List<Object>>();
        records.forEach(recordObj -> {
            boolean failed = false;
            if (!aligned.booleanValue()) {
                if (Boolean.FALSE.equals(hasStarted.get())) {
                    hasStarted.set(true);
                } else if (pointSize.get() >= batchPointSize) {
                    try {
                        if (CollectionUtils.isNotEmpty((Collection)paths)) {
                            ImportSchema.writeAndEmptyDataSet(paths, dataTypes, encodings, compressors, null, null, null, null, 3);
                        }
                    }
                    catch (Exception e) {
                        paths.forEach(t -> failedRecords.add(Collections.singletonList(t)));
                    }
                    try {
                        if (CollectionUtils.isNotEmpty((Collection)pathsWithAlias)) {
                            ImportSchema.writeAndEmptyDataSet(pathsWithAlias, dataTypesWithAlias, encodingsWithAlias, compressorsWithAlias, null, null, null, measurementAlias, 3);
                        }
                    }
                    catch (Exception e) {
                        paths.forEach(t -> failedRecords.add(Collections.singletonList(t)));
                    }
                    paths.clear();
                    dataTypes.clear();
                    encodings.clear();
                    compressors.clear();
                    measurementAlias.clear();
                    pointSize.set(0);
                }
            } else {
                paths.clear();
                dataTypes.clear();
                encodings.clear();
                compressors.clear();
                measurementAlias.clear();
            }
            String path = recordObj.get(headerNames.indexOf(HEAD_COLUMNS.get(0)));
            String alias = recordObj.get(headerNames.indexOf(HEAD_COLUMNS.get(1)));
            String dataTypeRaw = recordObj.get(headerNames.indexOf(HEAD_COLUMNS.get(2)));
            TSDataType dataType = ImportSchema.typeInfer(dataTypeRaw);
            String encodingTypeRaw = recordObj.get(headerNames.indexOf(HEAD_COLUMNS.get(3)));
            TSEncoding encodingType = ImportSchema.encodingInfer(encodingTypeRaw);
            String compressionTypeRaw = recordObj.get(headerNames.indexOf(HEAD_COLUMNS.get(4)));
            CompressionType compressionType = ImportSchema.compressInfer(compressionTypeRaw);
            if (StringUtils.isBlank((CharSequence)path) || path.trim().startsWith("root.__system")) {
                ioTPrinter.println(String.format("Line '%s', column '%s': illegal path %s", recordObj.getRecordNumber(), headerNames, path));
                failedRecords.add(recordObj.stream().collect(Collectors.toList()));
                failed = true;
            } else if (ObjectUtils.isEmpty((Object)dataType)) {
                ioTPrinter.println(String.format("Line '%s', column '%s': '%s' unknown dataType %n", recordObj.getRecordNumber(), path, dataTypeRaw));
                failedRecords.add(recordObj.stream().collect(Collectors.toList()));
                failed = true;
            } else if (ObjectUtils.isEmpty((Object)encodingType)) {
                ioTPrinter.println(String.format("Line '%s', column '%s': '%s' unknown encodingType %n", recordObj.getRecordNumber(), path, encodingTypeRaw));
                failedRecords.add(recordObj.stream().collect(Collectors.toList()));
                failed = true;
            } else if (ObjectUtils.isEmpty((Object)compressionType)) {
                ioTPrinter.println(String.format("Line '%s', column '%s': '%s' unknown compressionType %n", recordObj.getRecordNumber(), path, compressionTypeRaw));
                failedRecords.add(recordObj.stream().collect(Collectors.toList()));
                failed = true;
            } else {
                if (StringUtils.isBlank((CharSequence)alias)) {
                    paths.add(path);
                    dataTypes.add(dataType);
                    encodings.add(encodingType);
                    compressors.add(compressionType);
                } else {
                    pathsWithAlias.add(path);
                    dataTypesWithAlias.add(dataType);
                    encodingsWithAlias.add(encodingType);
                    compressorsWithAlias.add(compressionType);
                    measurementAlias.add(alias);
                }
                pointSize.getAndIncrement();
            }
            if (!failed && aligned.booleanValue()) {
                String deviceId = path.substring(0, path.lastIndexOf("."));
                paths.add(0, path.substring(deviceId.length() + 1));
                ImportSchema.writeAndEmptyDataSetAligned(deviceId, paths, dataTypes, encodings, compressors, measurementAlias, 3);
            }
        });
        try {
            if (CollectionUtils.isNotEmpty(paths)) {
                ImportSchema.writeAndEmptyDataSet(paths, dataTypes, encodings, compressors, null, null, null, null, 3);
            }
        }
        catch (Exception e) {
            paths.forEach(t -> failedRecords.add(Collections.singletonList(t)));
        }
        try {
            if (CollectionUtils.isNotEmpty(pathsWithAlias)) {
                ImportSchema.writeAndEmptyDataSet(pathsWithAlias, dataTypesWithAlias, encodingsWithAlias, compressorsWithAlias, null, null, null, measurementAlias, 3);
            }
        }
        catch (Exception e) {
            pathsWithAlias.forEach(t -> failedRecords.add(Collections.singletonList(t)));
        }
        pointSize.set(0);
        if (!failedRecords.isEmpty()) {
            ImportSchema.writeFailedLinesFile(failedFilePath, failedRecords);
        }
        if (Boolean.TRUE.equals(hasStarted.get())) {
            if (!failedRecords.isEmpty()) {
                ioTPrinter.println(fileName + " : Import completely fail!");
            } else {
                ioTPrinter.println(fileName + " : Import completely successful!");
            }
        } else {
            ioTPrinter.println(fileName + " : No records!");
        }
    }

    private static boolean checkHeader(List<String> headerNames) {
        List strangers;
        if (CollectionUtils.isNotEmpty(headerNames) && new HashSet<String>(headerNames).size() == HEAD_COLUMNS.size() && CollectionUtils.isNotEmpty(strangers = headerNames.stream().filter(t -> !HEAD_COLUMNS.contains(t)).collect(Collectors.toList()))) {
            ioTPrinter.println("The header of the CSV file to be imported is illegal. The correct format is \"Timeseries, Alibaba, DataType, Encoding, Compression\"!");
            return false;
        }
        return true;
    }

    private static void writeFailedLinesFile(String failedFilePath, ArrayList<List<Object>> failedRecords) {
        int failedRecordsSize;
        int fileIndex = 0;
        int from = 0;
        int restFailedRecords = failedRecordsSize = failedRecords.size();
        while (from < failedRecordsSize) {
            int step = Math.min(restFailedRecords, linesPerFailedFile);
            ImportSchema.writeCsvFile(failedRecords.subList(from, from + step), failedFilePath + "_" + fileIndex++);
            from += step;
            restFailedRecords -= step;
        }
    }

    private static void writeAndEmptyDataSet(List<String> paths, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors, List<Map<String, String>> propsList, List<Map<String, String>> tagsList, List<Map<String, String>> attributesList, List<String> measurementAliasList, int retryTime) throws StatementExecutionException {
        block7: {
            try {
                session.createMultiTimeseries(paths, dataTypes, encodings, compressors, propsList, tagsList, attributesList, measurementAliasList);
            }
            catch (IoTDBConnectionException e) {
                if (retryTime <= 0) break block7;
                try {
                    session.open();
                }
                catch (IoTDBConnectionException ex) {
                    ioTPrinter.println(INSERT_CSV_MEET_ERROR_MSG + e.getMessage());
                }
                ImportSchema.writeAndEmptyDataSet(paths, dataTypes, encodings, compressors, propsList, tagsList, attributesList, measurementAliasList, --retryTime);
            }
            catch (StatementExecutionException e) {
                try {
                    session.close();
                }
                catch (IoTDBConnectionException ioTDBConnectionException) {
                    // empty catch block
                }
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeAndEmptyDataSetAligned(String deviceId, List<String> measurements, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors, List<String> measurementAliasList, int retryTime) {
        block11: {
            try {
                session.createAlignedTimeseries(deviceId, measurements, dataTypes, encodings, compressors, measurementAliasList);
            }
            catch (IoTDBConnectionException e) {
                if (retryTime <= 0) break block11;
                try {
                    session.open();
                }
                catch (IoTDBConnectionException ex) {
                    ioTPrinter.println(INSERT_CSV_MEET_ERROR_MSG + e.getMessage());
                }
                ImportSchema.writeAndEmptyDataSetAligned(deviceId, measurements, dataTypes, encodings, compressors, measurementAliasList, --retryTime);
            }
            catch (StatementExecutionException e) {
                ioTPrinter.println(INSERT_CSV_MEET_ERROR_MSG + e.getMessage());
                try {
                    session.close();
                }
                catch (IoTDBConnectionException ioTDBConnectionException) {
                    // empty catch block
                }
                System.exit(1);
            }
            finally {
                deviceId = null;
                measurements.clear();
                dataTypes.clear();
                encodings.clear();
                compressors.clear();
                measurementAliasList.clear();
            }
        }
    }

    private static CSVParser readCsvFile(String path) throws IOException {
        return CSVFormat.Builder.create((CSVFormat)CSVFormat.DEFAULT).setHeader(new String[0]).setSkipHeaderRecord(true).setQuote('`').setEscape('\\').setIgnoreEmptyLines(true).build().parse((Reader)new InputStreamReader(new FileInputStream(path)));
    }

    private static TSDataType typeInfer(String typeStr) {
        try {
            if (StringUtils.isNotBlank((CharSequence)typeStr)) {
                return TSDataType.valueOf((String)typeStr);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    private static CompressionType compressInfer(String compressionType) {
        try {
            if (StringUtils.isNotBlank((CharSequence)compressionType)) {
                return CompressionType.valueOf((String)compressionType);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    private static TSEncoding encodingInfer(String encodingType) {
        try {
            if (StringUtils.isNotBlank((CharSequence)encodingType)) {
                return TSEncoding.valueOf((String)encodingType);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    static {
        failedFileDirectory = null;
        ioTPrinter = new IoTPrinter(System.out);
    }
}

