/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.subtask;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.impl.ReadPointCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.reader.IDataBlockReader;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.writer.AbstractCompactionWriter;
import org.apache.iotdb.db.storageengine.dataregion.read.QueryDataSource;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.write.chunk.ChunkWriterImpl;
import org.apache.tsfile.write.chunk.IChunkWriter;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.apache.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadPointPerformerSubTask
implements Callable<Void> {
    private static final Logger logger = LoggerFactory.getLogger((String)"COMPACTION");
    private final IDeviceID device;
    private final List<String> measurementList;
    private final FragmentInstanceContext fragmentInstanceContext;
    private final QueryDataSource queryDataSource;
    private final AbstractCompactionWriter compactionWriter;
    private final Map<String, MeasurementSchema> schemaMap;
    private final int taskId;

    public ReadPointPerformerSubTask(IDeviceID device, List<String> measurementList, FragmentInstanceContext fragmentInstanceContext, QueryDataSource queryDataSource, AbstractCompactionWriter compactionWriter, Map<String, MeasurementSchema> schemaMap, int taskId) {
        this.device = device;
        this.measurementList = measurementList;
        this.fragmentInstanceContext = fragmentInstanceContext;
        this.queryDataSource = queryDataSource;
        this.compactionWriter = compactionWriter;
        this.schemaMap = schemaMap;
        this.taskId = taskId;
    }

    @Override
    public Void call() throws Exception {
        for (String measurement : this.measurementList) {
            List<IMeasurementSchema> measurementSchemas = Collections.singletonList((IMeasurementSchema)this.schemaMap.get(measurement));
            IDataBlockReader dataBlockReader = ReadPointCompactionPerformer.constructReader(this.device, Collections.singletonList(measurement), measurementSchemas, new ArrayList<String>(this.schemaMap.keySet()), this.fragmentInstanceContext, this.queryDataSource, false);
            if (!dataBlockReader.hasNextBatch()) continue;
            this.compactionWriter.startMeasurement(measurement, (IChunkWriter)new ChunkWriterImpl(measurementSchemas.get(0), true), this.taskId);
            ReadPointCompactionPerformer.writeWithReader(this.compactionWriter, dataBlockReader, this.device, this.taskId, false);
            this.compactionWriter.endMeasurement(this.taskId);
        }
        return null;
    }
}

